/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.obfuscation.spring;

import com.github.robtimus.obfuscation.Obfuscator;
import com.github.robtimus.obfuscation.spring.ObfuscatorSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class ObfuscatorSupportBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DefaultListableBeanFactory listableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        listableBeanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ObfuscatorAutowireCandidateResolver(listableBeanFactory));
    }

    private static final class ObfuscatorAutowireCandidateResolver
    extends ObfuscatorSupport
    implements AutowireCandidateResolver {
        private final AutowireCandidateResolver delegate;

        private ObfuscatorAutowireCandidateResolver(DefaultListableBeanFactory beanFactory) {
            this(beanFactory.getAutowireCandidateResolver(), beanFactory);
        }

        private ObfuscatorAutowireCandidateResolver(AutowireCandidateResolver delegate, DefaultListableBeanFactory beanFactory) {
            super(beanFactory);
            this.delegate = delegate;
        }

        public boolean isAutowireCandidate(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
            return this.delegate.isAutowireCandidate(bdHolder, descriptor);
        }

        public boolean isRequired(DependencyDescriptor descriptor) {
            return this.delegate.isRequired(descriptor);
        }

        public boolean hasQualifier(DependencyDescriptor descriptor) {
            return this.delegate.hasQualifier(descriptor);
        }

        public Object getSuggestedValue(DependencyDescriptor descriptor) {
            if (Obfuscator.class.isAssignableFrom(descriptor.getDeclaredType())) {
                return this.obfuscator(descriptor.getAnnotations());
            }
            return this.delegate.getSuggestedValue(descriptor);
        }

        public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, String beanName) {
            return this.delegate.getLazyResolutionProxyIfNecessary(descriptor, beanName);
        }

        public AutowireCandidateResolver cloneIfNecessary() {
            AutowireCandidateResolver clonedDelegate = this.delegate.cloneIfNecessary();
            return clonedDelegate == this.delegate ? this : new ObfuscatorAutowireCandidateResolver(clonedDelegate, this.beanFactory());
        }
    }
}

