/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.obfuscation.spring;

import com.github.robtimus.obfuscation.Obfuscator;
import com.github.robtimus.obfuscation.annotation.CharacterRepresentationProvider;
import com.github.robtimus.obfuscation.annotation.ObjectFactory;
import com.github.robtimus.obfuscation.spring.BeanFactoryObjectFactory;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

abstract class ObfuscatorSupport {
    static final Obfuscator DEFAULT_OBFUSCATOR = Obfuscator.fixedLength((int)3);
    private final DefaultListableBeanFactory beanFactory;
    private final ObjectFactory objectFactory;

    ObfuscatorSupport(DefaultListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.objectFactory = new BeanFactoryObjectFactory((AutowireCapableBeanFactory)beanFactory);
    }

    final DefaultListableBeanFactory beanFactory() {
        return this.beanFactory;
    }

    final ObjectFactory objectFactory() {
        return this.objectFactory;
    }

    final Optional<Obfuscator> optionalObfuscator(Annotation[] annotations) {
        return this.objectFactory.obfuscator(annotations);
    }

    final Obfuscator obfuscator(Annotation[] annotations) {
        return this.optionalObfuscator(annotations).orElseGet(this::defaultObfuscator);
    }

    private Obfuscator defaultObfuscator() {
        ObjectProvider beanProvider = this.beanFactory.getBeanProvider(Obfuscator.class);
        return (Obfuscator)beanProvider.getIfAvailable(() -> DEFAULT_OBFUSCATOR);
    }

    private CharacterRepresentationProvider getCharacterRepresentationProvider(Annotation[] annotations, Class<?> type) {
        return this.objectFactory().characterRepresentationProvider(annotations).orElseGet(() -> CharacterRepresentationProvider.getDefaultInstance((Class)type));
    }

    final <T> T obfuscateValue(Object unobfuscatedValue, Obfuscator obfuscator, Annotation[] annotations, Class<?> type) {
        CharacterRepresentationProvider characterRepresentationProvider = this.getCharacterRepresentationProvider(annotations, type);
        return (T)obfuscator.obfuscateObject(unobfuscatedValue, () -> characterRepresentationProvider.toCharSequence(unobfuscatedValue));
    }
}

