/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.obfuscation.spring;

import com.github.robtimus.obfuscation.annotation.ObjectFactory;
import java.util.Objects;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class BeanFactoryObjectFactory
implements ObjectFactory {
    private final AutowireCapableBeanFactory beanFactory;

    public BeanFactoryObjectFactory(AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = Objects.requireNonNull(beanFactory);
    }

    public <T> T instance(Class<T> type) {
        ObjectProvider beanProvider = this.beanFactory.getBeanProvider(type);
        return (T)beanProvider.getIfAvailable(() -> this.beanFactory.createBean(type));
    }
}

