/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.obfuscation.spring.boot.autoconfigure;

import com.github.robtimus.obfuscation.Obfuscator;
import com.github.robtimus.obfuscation.spring.boot.autoconfigure.ObfuscatorProperties;
import com.github.robtimus.obfuscation.spring.boot.autoconfigure.ObfuscatorPropertiesCondition;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(value={Obfuscator.class})
@Conditional(value={DefaultObfuscatorCondition.class})
@EnableConfigurationProperties
public class ObfuscatorAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="obfuscation.default-obfuscator")
    public ObfuscatorProperties defaultObfuscatorProperties() {
        return new ObfuscatorProperties();
    }

    @Bean
    public Obfuscator defaultObfuscator(AutowireCapableBeanFactory beanFactory) {
        ObfuscatorProperties properties = this.defaultObfuscatorProperties();
        return properties.createObfuscator(beanFactory);
    }

    static final class DefaultObfuscatorCondition
    extends ObfuscatorPropertiesCondition {
        private DefaultObfuscatorCondition() {
            super("obfuscation.default-obfuscator");
        }
    }
}

