/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.obfuscation.spring.boot.autoconfigure;

import com.github.robtimus.obfuscation.Obfuscator;
import com.github.robtimus.obfuscation.annotation.ObfuscatorProvider;
import com.github.robtimus.obfuscation.annotation.ObjectFactory;
import com.github.robtimus.obfuscation.spring.BeanFactoryObjectFactory;
import com.github.robtimus.obfuscation.spring.boot.autoconfigure.Messages;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.constraints.Min;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.validation.annotation.Validated;

@Validated
@ValidObfuscatorProperties
public class ObfuscatorProperties {
    private static final String FIELD_MODE = "mode";
    private static final String FIELD_MASK_CHAR = "maskChar";
    private static final String FIELD_FIXED_LENGTH = "fixedLength";
    private static final String FIELD_FIXED_VALUE = "fixedValue";
    private static final String FIELD_KEEP_AT_START = "keepAtStart";
    private static final String FIELD_KEEP_AT_END = "keepAtEnd";
    private static final String FIELD_AT_LEAST_FROM_START = "atLeastFromStart";
    private static final String FIELD_AT_LEAST_FROM_END = "atLeastFromEnd";
    private static final String FIELD_FIXED_TOTAL_LENGTH = "fixedTotalLength";
    private static final String FIELD_PROVIDER_CLASS = "providerClass";
    private ObfuscationMode mode;
    private Character maskChar;
    @Min(value=0L)
    private @Min(value=0L) Integer fixedLength;
    private String fixedValue;
    @Min(value=0L)
    private @Min(value=0L) Integer keepAtStart;
    @Min(value=0L)
    private @Min(value=0L) Integer keepAtEnd;
    @Min(value=0L)
    private @Min(value=0L) Integer atLeastFromStart;
    @Min(value=0L)
    private @Min(value=0L) Integer atLeastFromEnd;
    private Integer fixedTotalLength;
    private Class<? extends ObfuscatorProvider> providerClass;

    public ObfuscationMode getMode() {
        return this.mode;
    }

    public void setMode(ObfuscationMode mode) {
        this.mode = mode;
    }

    public Character getMaskChar() {
        return this.maskChar;
    }

    public void setMaskChar(Character maskChar) {
        this.maskChar = maskChar;
    }

    public Integer getFixedLength() {
        return this.fixedLength;
    }

    public void setFixedLength(Integer fixedLength) {
        this.fixedLength = fixedLength;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public Integer getKeepAtStart() {
        return this.keepAtStart;
    }

    public void setKeepAtStart(Integer keepAtStart) {
        this.keepAtStart = keepAtStart;
    }

    public Integer getKeepAtEnd() {
        return this.keepAtEnd;
    }

    public void setKeepAtEnd(Integer keepAtEnd) {
        this.keepAtEnd = keepAtEnd;
    }

    public Integer getAtLeastFromStart() {
        return this.atLeastFromStart;
    }

    public void setAtLeastFromStart(Integer atLeastFromStart) {
        this.atLeastFromStart = atLeastFromStart;
    }

    public Integer getAtLeastFromEnd() {
        return this.atLeastFromEnd;
    }

    public void setAtLeastFromEnd(Integer atLeastFromEnd) {
        this.atLeastFromEnd = atLeastFromEnd;
    }

    public Integer getFixedTotalLength() {
        return this.fixedTotalLength;
    }

    public void setFixedTotalLength(Integer fixedTotalLength) {
        this.fixedTotalLength = fixedTotalLength;
    }

    public Class<? extends ObfuscatorProvider> getProviderClass() {
        return this.providerClass;
    }

    public void setProviderClass(Class<? extends ObfuscatorProvider> providerClass) {
        if (providerClass != null) {
            providerClass.asSubclass(ObfuscatorProvider.class);
        }
        this.providerClass = providerClass;
    }

    public Obfuscator createObfuscator(AutowireCapableBeanFactory beanFactory) {
        BeanFactoryObjectFactory objectFactory = new BeanFactoryObjectFactory(beanFactory);
        return this.createObfuscator((ObjectFactory)objectFactory);
    }

    public Obfuscator createObfuscator(ObjectFactory objectFactory) {
        Objects.requireNonNull(objectFactory);
        ObfuscationMode obfuscationMode = this.determineObfuscationMode();
        return (Obfuscator)obfuscationMode.factory.apply(this, objectFactory);
    }

    public static List<Obfuscator> createObfuscators(Collection<ObfuscatorProperties> properties, AutowireCapableBeanFactory beanFactory) {
        BeanFactoryObjectFactory objectFactory = new BeanFactoryObjectFactory(beanFactory);
        return ObfuscatorProperties.createObfuscators(properties, (ObjectFactory)objectFactory);
    }

    public static List<Obfuscator> createObfuscators(Collection<ObfuscatorProperties> properties, ObjectFactory objectFactory) {
        Objects.requireNonNull(objectFactory);
        return properties.stream().map(p -> p.createObfuscator(objectFactory)).collect(Collectors.toList());
    }

    ObfuscationMode determineObfuscationMode() {
        if (this.mode != null) {
            return this.mode;
        }
        Set<ObfuscationMode> obfuscationModes = this.determineObfuscationModes();
        if (obfuscationModes.isEmpty()) {
            throw new IllegalStateException(Messages.ObfuscatorProperties.noObfuscationModes.get());
        }
        if (obfuscationModes.size() > 1) {
            throw new IllegalStateException(Messages.ObfuscatorProperties.multipleObfuscationModes.get());
        }
        return obfuscationModes.iterator().next();
    }

    private Set<ObfuscationMode> determineObfuscationModes() {
        if (this.mode != null) {
            return Collections.singleton(this.mode);
        }
        EnumSet<ObfuscationMode> obfuscationModes = EnumSet.noneOf(ObfuscationMode.class);
        if (this.fixedLength != null) {
            obfuscationModes.add(ObfuscationMode.FIXED_LENGTH);
        }
        if (this.fixedValue != null) {
            obfuscationModes.add(ObfuscationMode.FIXED_VALUE);
        }
        if (this.keepAtStart != null || this.keepAtEnd != null || this.atLeastFromStart != null || this.atLeastFromEnd != null || this.fixedTotalLength != null) {
            obfuscationModes.add(ObfuscationMode.PORTION);
        }
        if (this.providerClass != null) {
            obfuscationModes.add(ObfuscationMode.PROVIDER);
        }
        return obfuscationModes;
    }

    private char maskChar() {
        return this.maskChar != null ? this.maskChar.charValue() : (char)'*';
    }

    private int fixedLength() {
        if (this.fixedLength == null) {
            throw new IllegalStateException(Messages.ObfuscatorProperties.missingProperty.get(FIELD_FIXED_LENGTH));
        }
        return this.fixedLength;
    }

    private String fixedValue() {
        if (this.fixedValue == null) {
            throw new IllegalStateException(Messages.ObfuscatorProperties.missingProperty.get(FIELD_FIXED_VALUE));
        }
        return this.fixedValue;
    }

    private Obfuscator createPortionObfuscator() {
        return Obfuscator.portion().keepAtStart(this.keepAtStart != null ? this.keepAtStart : 0).keepAtEnd(this.keepAtEnd != null ? this.keepAtEnd : 0).atLeastFromStart(this.atLeastFromStart != null ? this.atLeastFromStart : 0).atLeastFromEnd(this.atLeastFromEnd != null ? this.atLeastFromEnd : 0).withFixedTotalLength(this.fixedTotalLength != null ? this.fixedTotalLength : -1).withMaskChar(this.maskChar()).build();
    }

    private Obfuscator createObfuscatorFromProvider(ObjectFactory objectFactory) {
        Class<? extends ObfuscatorProvider> obfuscatorProviderClass = this.obfuscatorProviderClass();
        ObfuscatorProvider obfuscatorProvider = objectFactory.obfuscatorProvider(obfuscatorProviderClass);
        return obfuscatorProvider.obfuscator();
    }

    private Class<? extends ObfuscatorProvider> obfuscatorProviderClass() {
        if (this.providerClass == null) {
            throw new IllegalStateException(Messages.ObfuscatorProperties.missingProperty.get(FIELD_PROVIDER_CLASS));
        }
        return this.providerClass;
    }

    public static final class ObfuscatorPropertiesValidator
    implements ConstraintValidator<ValidObfuscatorProperties, ObfuscatorProperties> {
        public boolean isValid(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            Set obfuscationModes = properties.determineObfuscationModes();
            if (obfuscationModes.isEmpty()) {
                context.buildConstraintViolationWithTemplate(Messages.ObfuscatorProperties.noObfuscationModes.get()).addPropertyNode(ObfuscatorProperties.FIELD_MODE).addConstraintViolation();
                return false;
            }
            if (obfuscationModes.size() > 1) {
                context.buildConstraintViolationWithTemplate(Messages.ObfuscatorProperties.multipleObfuscationModes.get()).addPropertyNode(ObfuscatorProperties.FIELD_MODE).addConstraintViolation();
                return false;
            }
            ObfuscationMode obfuscationMode = (ObfuscationMode)((Object)obfuscationModes.iterator().next());
            return obfuscationMode.validator.test(properties, context);
        }

        private static boolean isValidForAll(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            boolean valid = true;
            valid &= ObfuscatorPropertiesValidator.fixedLengthNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.fixedValueNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.portionFieldsNotSet(properties, context);
            return valid &= ObfuscatorPropertiesValidator.providerClassNotSet(properties, context);
        }

        private static boolean isValidForNone(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            boolean valid = true;
            valid &= ObfuscatorPropertiesValidator.maskCharNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.fixedLengthNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.fixedValueNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.portionFieldsNotSet(properties, context);
            return valid &= ObfuscatorPropertiesValidator.providerClassNotSet(properties, context);
        }

        private static boolean isValidForFixedLength(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            boolean valid = true;
            valid &= ObfuscatorPropertiesValidator.fixedLengthSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.fixedValueNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.portionFieldsNotSet(properties, context);
            return valid &= ObfuscatorPropertiesValidator.providerClassNotSet(properties, context);
        }

        private static boolean isValidForFixedValue(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            boolean valid = true;
            valid &= ObfuscatorPropertiesValidator.fixedValueSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.maskCharNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.fixedLengthNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.portionFieldsNotSet(properties, context);
            return valid &= ObfuscatorPropertiesValidator.providerClassNotSet(properties, context);
        }

        private static boolean isValidForPortion(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            boolean valid = true;
            valid &= ObfuscatorPropertiesValidator.fixedLengthNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.fixedValueNotSet(properties, context);
            return valid &= ObfuscatorPropertiesValidator.providerClassNotSet(properties, context);
        }

        private static boolean isValidForClass(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            boolean valid = true;
            valid &= ObfuscatorPropertiesValidator.providerClassSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.maskCharNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.fixedLengthNotSet(properties, context);
            valid &= ObfuscatorPropertiesValidator.fixedValueNotSet(properties, context);
            return valid &= ObfuscatorPropertiesValidator.portionFieldsNotSet(properties, context);
        }

        private static boolean maskCharNotSet(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            return ObfuscatorPropertiesValidator.isNotSet(properties.getMaskChar(), ObfuscatorProperties.FIELD_MASK_CHAR, context);
        }

        private static boolean fixedLengthNotSet(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            return ObfuscatorPropertiesValidator.isNotSet(properties.getFixedLength(), ObfuscatorProperties.FIELD_FIXED_LENGTH, context);
        }

        private static boolean fixedValueNotSet(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            return ObfuscatorPropertiesValidator.isNotSet(properties.getFixedValue(), ObfuscatorProperties.FIELD_FIXED_VALUE, context);
        }

        private static boolean portionFieldsNotSet(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            boolean valid = true;
            valid &= ObfuscatorPropertiesValidator.isNotSet(properties.getKeepAtStart(), ObfuscatorProperties.FIELD_KEEP_AT_START, context);
            valid &= ObfuscatorPropertiesValidator.isNotSet(properties.getKeepAtEnd(), ObfuscatorProperties.FIELD_KEEP_AT_END, context);
            valid &= ObfuscatorPropertiesValidator.isNotSet(properties.getAtLeastFromStart(), ObfuscatorProperties.FIELD_AT_LEAST_FROM_START, context);
            valid &= ObfuscatorPropertiesValidator.isNotSet(properties.getAtLeastFromEnd(), ObfuscatorProperties.FIELD_AT_LEAST_FROM_END, context);
            return valid &= ObfuscatorPropertiesValidator.isNotSet(properties.getFixedTotalLength(), ObfuscatorProperties.FIELD_FIXED_TOTAL_LENGTH, context);
        }

        private static boolean providerClassNotSet(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            return ObfuscatorPropertiesValidator.isNotSet(properties.getProviderClass(), ObfuscatorProperties.FIELD_PROVIDER_CLASS, context);
        }

        private static boolean isNotSet(Object value, String fieldName, ConstraintValidatorContext context) {
            if (value != null) {
                context.buildConstraintViolationWithTemplate("{javax.validation.constraints.Null.message}").addPropertyNode(fieldName).addConstraintViolation();
                return false;
            }
            return true;
        }

        private static boolean fixedLengthSet(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            return ObfuscatorPropertiesValidator.isSet(properties.getFixedLength(), ObfuscatorProperties.FIELD_FIXED_LENGTH, context);
        }

        private static boolean fixedValueSet(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            return ObfuscatorPropertiesValidator.isSet(properties.getFixedValue(), ObfuscatorProperties.FIELD_FIXED_VALUE, context);
        }

        private static boolean providerClassSet(ObfuscatorProperties properties, ConstraintValidatorContext context) {
            return ObfuscatorPropertiesValidator.isSet(properties.getProviderClass(), ObfuscatorProperties.FIELD_PROVIDER_CLASS, context);
        }

        private static boolean isSet(Object value, String fieldName, ConstraintValidatorContext context) {
            if (value == null) {
                context.buildConstraintViolationWithTemplate("{javax.validation.constraints.NotNull.message}").addPropertyNode(fieldName).addConstraintViolation();
                return false;
            }
            return true;
        }
    }

    @Documented
    @Constraint(validatedBy={ObfuscatorPropertiesValidator.class})
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValidObfuscatorProperties {
        public String message() default "invalid obfuscator properties";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static enum ObfuscationMode {
        ALL((p, f) -> Obfuscator.all((char)((ObfuscatorProperties)p).maskChar()), (x$0, x$1) -> ObfuscatorPropertiesValidator.access$1100(x$0, x$1)),
        NONE((p, f) -> Obfuscator.none(), (x$0, x$1) -> ObfuscatorPropertiesValidator.access$1000(x$0, x$1)),
        FIXED_LENGTH((p, f) -> Obfuscator.fixedLength((int)((ObfuscatorProperties)p).fixedLength(), (char)((ObfuscatorProperties)p).maskChar()), (x$0, x$1) -> ObfuscatorPropertiesValidator.access$700(x$0, x$1)),
        FIXED_VALUE((p, f) -> Obfuscator.fixedValue((String)((ObfuscatorProperties)p).fixedValue()), (x$0, x$1) -> ObfuscatorPropertiesValidator.access$500(x$0, x$1)),
        PORTION((p, f) -> ObfuscatorProperties.access$400(p), (x$0, x$1) -> ObfuscatorPropertiesValidator.access$300(x$0, x$1)),
        PROVIDER((p, f) -> ObfuscatorProperties.access$200(p, f), (x$0, x$1) -> ObfuscatorPropertiesValidator.access$100(x$0, x$1));

        private final BiFunction<ObfuscatorProperties, ObjectFactory, Obfuscator> factory;
        private final BiPredicate<ObfuscatorProperties, ConstraintValidatorContext> validator;

        private ObfuscationMode(BiFunction<ObfuscatorProperties, ObjectFactory, Obfuscator> factory, BiPredicate<ObfuscatorProperties, ConstraintValidatorContext> validator) {
            this.factory = factory;
            this.validator = validator;
        }
    }
}

