/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.obfuscation.spring.boot.autoconfigure;

import com.github.robtimus.obfuscation.spring.boot.autoconfigure.Messages;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ObfuscatorPropertiesCondition
extends SpringBootCondition {
    private static final List<String> NAMES = Collections.unmodifiableList(Arrays.asList("mode", "mask-char", "fixed-length", "fixed-value", "keep-at-start", "keep-at-end", "at-least-from-start", "at-least-from-end", "fixed-total-length", "provider-class"));
    private final List<String> properties = NAMES.stream().map(n -> prefix + "." + n).collect(Collectors.toList());

    protected ObfuscatorPropertiesCondition(String prefix) {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment = context.getEnvironment();
        boolean hasProperty = this.properties.stream().anyMatch(arg_0 -> ((Environment)environment).containsProperty(arg_0));
        return hasProperty ? ConditionOutcome.match() : ConditionOutcome.noMatch((String)Messages.ObfuscatorPropertiesCondition.noMatch.get(this.properties));
    }
}

