/*
 * Decompiled with CFR 0.152.
 */
package org.rx;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.rx.bean.RandomList;
import org.rx.bean.Tuple;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.core.YamlConfiguration;
import org.rx.exception.InvalidException;
import org.rx.net.AuthenticEndpoint;
import org.rx.net.MemoryMode;
import org.rx.net.Sockets;
import org.rx.net.TransportFlags;
import org.rx.net.dns.DnsClient;
import org.rx.net.dns.DnsServer;
import org.rx.net.rpc.Remoting;
import org.rx.net.rpc.RpcClientConfig;
import org.rx.net.rpc.RpcServerConfig;
import org.rx.net.shadowsocks.ShadowsocksConfig;
import org.rx.net.shadowsocks.ShadowsocksServer;
import org.rx.net.shadowsocks.encryption.CipherKind;
import org.rx.net.socks.Authenticator;
import org.rx.net.socks.SocksConfig;
import org.rx.net.socks.SocksContext;
import org.rx.net.socks.SocksProxyServer;
import org.rx.net.socks.SocksUser;
import org.rx.net.socks.upstream.Socks5UdpUpstream;
import org.rx.net.socks.upstream.Socks5Upstream;
import org.rx.net.socks.upstream.Upstream;
import org.rx.net.support.IPAddress;
import org.rx.net.support.IPSearcher;
import org.rx.net.support.SocksSupport;
import org.rx.net.support.UnresolvedEndpoint;
import org.rx.net.support.UpstreamSupport;
import org.rx.net.transport.TcpClientConfig;
import org.rx.net.transport.TcpServerConfig;
import org.rx.util.function.Action;
import org.rx.util.function.TripleAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main
implements SocksSupport {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    static RSSConf conf;
    static boolean udp2raw;
    final SocksProxyServer proxyServer;

    public static void main(String[] args) {
        Map<String, String> options = Sys.mainOptions(args);
        Integer port = Reflects.convertQuietly(options.get("port"), Integer.class);
        if (port == null) {
            log.info("Invalid port arg");
            return;
        }
        Integer connectTimeout = Reflects.convertQuietly(options.get("connectTimeout"), Integer.class, 60000);
        String mode = options.get("shadowMode");
        if (Extends.eq(mode, "1")) {
            Main.launchServer(options, port, connectTimeout);
            return;
        }
        Main.launchClient(options, port, connectTimeout);
    }

    static void launchClient(Map<String, String> options, Integer port, Integer connectTimeout) {
        String[] arg1 = Strings.split(options.get("shadowUsers"), ",");
        if (arg1.length == 0) {
            log.info("Invalid shadowUsers arg");
            return;
        }
        RandomList shadowServers = new RandomList();
        RandomList<DnsServer.ResolveInterceptor> dnsInterceptors = new RandomList<DnsServer.ResolveInterceptor>();
        SocksConfig frontConf = new SocksConfig(port);
        YamlConfiguration watcher = new YamlConfiguration("conf.yml").enableWatch();
        watcher.onChanged.combine((s, e) -> {
            RSSConf changed = s.readAs(RSSConf.class);
            if (changed == null) {
                return;
            }
            conf = changed;
            Linq<AuthenticEndpoint> svrs = Linq.from(Main.conf.shadowServer).select(p -> Reflects.convertQuietly(p, AuthenticEndpoint.class));
            if (!svrs.any() || svrs.any(Objects::isNull)) {
                throw new InvalidException("Invalid shadowServer arg", new Object[0]);
            }
            for (UpstreamSupport support : shadowServers) {
                Extends.tryClose(support.getSupport());
            }
            shadowServers.clear();
            dnsInterceptors.clear();
            for (AuthenticEndpoint shadowServer : svrs) {
                RpcClientConfig rpcConf = RpcClientConfig.poolMode(Sockets.newEndpoint(shadowServer.getEndpoint(), shadowServer.getEndpoint().getPort() + 1), Main.conf.rpcMinSize, Main.conf.rpcMaxSize);
                TcpClientConfig tcpConfig = rpcConf.getTcpConfig();
                tcpConfig.setTransportFlags(TransportFlags.BACKEND_AES_COMBO.flags());
                String weight = shadowServer.getParameters().get("w");
                if (Strings.isEmpty((CharSequence)weight)) continue;
                final SocksSupport facade = Remoting.createFacade(SocksSupport.class, rpcConf);
                shadowServers.add(new UpstreamSupport(shadowServer, new SocksSupport(){

                    @Override
                    public void fakeEndpoint(BigInteger hash, String realEndpoint) {
                        facade.fakeEndpoint(hash, realEndpoint);
                    }

                    @Override
                    public List<InetAddress> resolveHost(String host) {
                        if (Sockets.isBypass(Main.conf.directList, host)) {
                            return DnsClient.inlandClient().resolveAll(host);
                        }
                        return facade.resolveHost(host);
                    }

                    @Override
                    public void addWhiteList(InetAddress endpoint) {
                        facade.addWhiteList(endpoint);
                    }
                }), Integer.parseInt(weight));
            }
            dnsInterceptors.addAll((Collection<DnsServer.ResolveInterceptor>)Linq.from(shadowServers).select(UpstreamSupport::getSupport).toList());
            log.info("reload svrs {}", (Object)Sys.toJsonString(svrs));
            if (Main.conf.bypassHosts != null) {
                frontConf.getBypassList().addAll(Main.conf.bypassHosts);
            }
        });
        watcher.raiseChange();
        Linq<Tuple> shadowUsers = Linq.from(arg1).select(shadowUser -> {
            String[] sArgs = Strings.split(shadowUser, ":", 4);
            ShadowsocksConfig config = new ShadowsocksConfig(Sockets.newAnyEndpoint(Integer.parseInt(sArgs[0])), CipherKind.AES_256_GCM.getCipherName(), sArgs[1]);
            config.setTcpTimeoutSeconds(Main.conf.tcpTimeoutSeconds);
            config.setUdpTimeoutSeconds(Main.conf.udpTimeoutSeconds);
            SocksUser user = new SocksUser(sArgs[2]);
            user.setPassword(Main.conf.socksPwd);
            user.setMaxIpCount(Integer.parseInt(sArgs[3]));
            return Tuple.of(config, user);
        });
        Integer shadowDnsPort = Reflects.convertQuietly(options.get("shadowDnsPort"), Integer.class, 53);
        DnsServer dnsSvr = new DnsServer(shadowDnsPort);
        dnsSvr.setTtl(36000);
        dnsSvr.setInterceptors(dnsInterceptors);
        dnsSvr.addHostsFile("hosts.txt");
        InetSocketAddress shadowDnsEp = Sockets.newLoopbackEndpoint(shadowDnsPort);
        Sockets.injectNameService(Collections.singletonList(shadowDnsEp));
        frontConf.setTransportFlags(TransportFlags.BACKEND_COMPRESS.flags());
        frontConf.setMemoryMode(MemoryMode.MEDIUM);
        frontConf.setConnectTimeoutMillis(connectTimeout);
        frontConf.setReadTimeoutSeconds(Main.conf.tcpTimeoutSeconds);
        frontConf.setUdpReadTimeoutSeconds(Main.conf.udpTimeoutSeconds);
        frontConf.setEnableUdp2raw(udp2raw);
        frontConf.setUdp2rawServers(Linq.from(shadowServers).select(p -> p.getEndpoint().getEndpoint()).toList());
        if (frontConf.isEnableUdp2raw() && Main.conf.udp2rawEndpoint != null) {
            log.info("udp2rawEndpoint: {}", (Object)Main.conf.udp2rawEndpoint);
            AuthenticEndpoint udp2rawSvrEp = AuthenticEndpoint.valueOf(Main.conf.udp2rawEndpoint);
            frontConf.getUdp2rawServers().add(udp2rawSvrEp.getEndpoint());
        }
        SocksProxyServer frontSvr = new SocksProxyServer(frontConf, Authenticator.dbAuth(shadowUsers.select(p -> (SocksUser)p.right).toList(), port + 1));
        Upstream shadowDnsUpstream = new Upstream(new UnresolvedEndpoint(shadowDnsEp));
        TripleAction<SocksProxyServer, SocksContext> firstRoute = (s, e) -> {
            UnresolvedEndpoint dstEp = e.getFirstDestination();
            if (dstEp.getPort() == 53) {
                e.setUpstream(shadowDnsUpstream);
                e.setHandled(true);
                return;
            }
            if (Sockets.isBypass(frontConf.getBypassList(), dstEp.getHost())) {
                e.setUpstream(new Upstream(dstEp));
                e.setHandled(true);
            }
        };
        frontSvr.onRoute.replace(firstRoute, (s, e) -> e.setUpstream(new Socks5Upstream(e.getFirstDestination(), frontConf, () -> (UpstreamSupport)shadowServers.next(e.getSource(), Main.conf.steeringTTL, true))));
        frontSvr.onUdpRoute.replace(firstRoute, (s, e) -> {
            UnresolvedEndpoint dstEp = e.getFirstDestination();
            e.setUpstream(new Socks5UdpUpstream(dstEp, frontConf, () -> (UpstreamSupport)shadowServers.next(e.getSource(), Main.conf.steeringTTL, true)));
        });
        frontSvr.setAesRouter(SocksProxyServer.DNS_AES_ROUTER);
        Main app = new Main(frontSvr);
        Action fn = () -> {
            InetAddress addr = InetAddress.getByName(IPSearcher.DEFAULT.searchCurrent().getIp());
            Extends.eachQuietly(shadowServers, p -> p.getSupport().addWhiteList(addr));
        };
        fn.invoke();
        Tasks.schedulePeriod(fn, (long)Main.conf.autoWhiteListSeconds * 1000L);
        InetSocketAddress frontSvrEp = Sockets.newLoopbackEndpoint(port);
        for (Tuple tuple : shadowUsers) {
            ShadowsocksConfig ssConfig = (ShadowsocksConfig)tuple.left;
            SocksUser user = (SocksUser)tuple.right;
            AuthenticEndpoint srvEp = new AuthenticEndpoint(frontSvrEp, user.getUsername(), user.getPassword());
            ssConfig.setMemoryMode(MemoryMode.MEDIUM);
            ssConfig.setConnectTimeoutMillis(connectTimeout);
            SocksConfig directConf = new SocksConfig(port);
            frontConf.setMemoryMode(MemoryMode.MEDIUM);
            frontConf.setConnectTimeoutMillis(connectTimeout);
            ShadowsocksServer server = new ShadowsocksServer(ssConfig);
            TripleAction<ShadowsocksServer, SocksContext> ssFirstRoute = (s, e) -> {
                UnresolvedEndpoint dstEp = e.getFirstDestination();
                if (dstEp.getPort() == 53) {
                    e.setUpstream(shadowDnsUpstream);
                    e.setHandled(true);
                    return;
                }
                if (Sockets.isBypass(ssConfig.getBypassList(), dstEp.getHost())) {
                    e.setUpstream(new Upstream(dstEp));
                    e.setHandled(true);
                }
            };
            server.onRoute.replace(ssFirstRoute, (s, e) -> {
                boolean gfw;
                String host = e.getFirstDestination().getHost();
                if (Sockets.isBypass(Main.conf.gfwList, host)) {
                    gfw = true;
                } else if (Sockets.isBypass(Main.conf.directList, host)) {
                    gfw = false;
                } else {
                    IPAddress ipAddress = Tasks.awaitQuietly(() -> IPSearcher.DEFAULT.search(host, true), (long)Main.conf.waitIpInfoMillis);
                    boolean bl = gfw = ipAddress == null || !ipAddress.isChina();
                }
                if (!gfw) {
                    e.setUpstream(new Upstream(e.getFirstDestination()));
                    return;
                }
                e.setUpstream(new Socks5Upstream(e.getFirstDestination(), directConf, () -> new UpstreamSupport(srvEp, null)));
            });
            server.onUdpRoute.replace(ssFirstRoute, (s, e) -> e.setUpstream(new Upstream(e.getFirstDestination(), srvEp)));
        }
        app.ddns();
        log.info("Server started..");
        app.await();
    }

    static void launchServer(Map<String, String> options, Integer port, Integer connectTimeout) {
        AuthenticEndpoint shadowUser = Reflects.convertQuietly(options.get("shadowUser"), AuthenticEndpoint.class);
        if (shadowUser == null) {
            log.info("Invalid shadowUser arg");
            return;
        }
        SocksUser ssUser = new SocksUser(shadowUser.getUsername());
        ssUser.setPassword(shadowUser.getPassword());
        ssUser.setMaxIpCount(-1);
        SocksConfig backConf = new SocksConfig(port);
        backConf.setTransportFlags(TransportFlags.FRONTEND_COMPRESS.flags());
        backConf.setMemoryMode(MemoryMode.MEDIUM);
        backConf.setConnectTimeoutMillis(connectTimeout);
        backConf.setEnableUdp2raw(udp2raw);
        SocksProxyServer backSvr = new SocksProxyServer(backConf, (u, p) -> Extends.eq(u, ssUser.getUsername()) && Extends.eq(p, ssUser.getPassword()) ? ssUser : SocksUser.ANONYMOUS);
        backSvr.setAesRouter(SocksProxyServer.DNS_AES_ROUTER);
        RpcServerConfig rpcConf = new RpcServerConfig(new TcpServerConfig(port + 1));
        rpcConf.getTcpConfig().setTransportFlags(TransportFlags.FRONTEND_AES_COMBO.flags());
        Main app = new Main(backSvr);
        Remoting.register(app, rpcConf);
        app.await();
    }

    void ddns() {
        Tasks.schedulePeriod(() -> {
            if (conf == null) {
                log.warn("conf is null");
            }
            InetAddress wanIp = InetAddress.getByName(IPSearcher.DEFAULT.currentIp());
            for (String ddns : Main.conf.ddnsDomains) {
                List<InetAddress> currentIps = DnsClient.inlandClient().resolveAll(ddns);
                if (currentIps.contains(wanIp)) continue;
                int i = ddns.indexOf(".");
                String domain = ddns.substring(i + 1);
                String name = ddns.substring(0, i);
                log.info("ddns-{}.{}: {}->{}", new Object[]{name, domain, currentIps, wanIp});
                IPSearcher.godaddyDns(conf.getGodaddyKey(), domain, name, wanIp.getHostAddress());
            }
        }, (long)Main.conf.ddnsSeconds * 1000L);
    }

    @Override
    public void fakeEndpoint(BigInteger hash, String endpoint) {
        SocksSupport.fakeDict().putIfAbsent(hash, UnresolvedEndpoint.valueOf(endpoint));
    }

    @Override
    public List<InetAddress> resolveHost(String host) {
        return DnsClient.outlandClient().resolveAll(host);
    }

    @Override
    public void addWhiteList(InetAddress endpoint) {
        this.proxyServer.getConfig().getWhiteList().add(endpoint);
    }

    synchronized void await() {
        this.wait();
    }

    public Main(SocksProxyServer proxyServer) {
        this.proxyServer = proxyServer;
    }

    static {
        udp2raw = false;
    }

    public static class RSSConf {
        public List<String> shadowServer;
        public String socksPwd;
        public int tcpTimeoutSeconds = 120;
        public int udpTimeoutSeconds = 600;
        public int rpcMinSize = 2;
        public int rpcMaxSize = 6;
        public int autoWhiteListSeconds = 120;
        public List<String> bypassHosts;
        public int steeringTTL;
        public List<String> gfwList;
        public List<String> directList;
        public int waitIpInfoMillis = 1000;
        public int ddnsSeconds;
        public List<String> ddnsDomains;
        public String godaddyKey;
        public boolean pcap2socks;
        public String udp2rawEndpoint;

        public List<String> getShadowServer() {
            return this.shadowServer;
        }

        public String getSocksPwd() {
            return this.socksPwd;
        }

        public int getTcpTimeoutSeconds() {
            return this.tcpTimeoutSeconds;
        }

        public int getUdpTimeoutSeconds() {
            return this.udpTimeoutSeconds;
        }

        public int getRpcMinSize() {
            return this.rpcMinSize;
        }

        public int getRpcMaxSize() {
            return this.rpcMaxSize;
        }

        public int getAutoWhiteListSeconds() {
            return this.autoWhiteListSeconds;
        }

        public List<String> getBypassHosts() {
            return this.bypassHosts;
        }

        public int getSteeringTTL() {
            return this.steeringTTL;
        }

        public List<String> getGfwList() {
            return this.gfwList;
        }

        public List<String> getDirectList() {
            return this.directList;
        }

        public int getWaitIpInfoMillis() {
            return this.waitIpInfoMillis;
        }

        public int getDdnsSeconds() {
            return this.ddnsSeconds;
        }

        public List<String> getDdnsDomains() {
            return this.ddnsDomains;
        }

        public String getGodaddyKey() {
            return this.godaddyKey;
        }

        public boolean isPcap2socks() {
            return this.pcap2socks;
        }

        public String getUdp2rawEndpoint() {
            return this.udp2rawEndpoint;
        }

        public void setShadowServer(List<String> shadowServer) {
            this.shadowServer = shadowServer;
        }

        public void setSocksPwd(String socksPwd) {
            this.socksPwd = socksPwd;
        }

        public void setTcpTimeoutSeconds(int tcpTimeoutSeconds) {
            this.tcpTimeoutSeconds = tcpTimeoutSeconds;
        }

        public void setUdpTimeoutSeconds(int udpTimeoutSeconds) {
            this.udpTimeoutSeconds = udpTimeoutSeconds;
        }

        public void setRpcMinSize(int rpcMinSize) {
            this.rpcMinSize = rpcMinSize;
        }

        public void setRpcMaxSize(int rpcMaxSize) {
            this.rpcMaxSize = rpcMaxSize;
        }

        public void setAutoWhiteListSeconds(int autoWhiteListSeconds) {
            this.autoWhiteListSeconds = autoWhiteListSeconds;
        }

        public void setBypassHosts(List<String> bypassHosts) {
            this.bypassHosts = bypassHosts;
        }

        public void setSteeringTTL(int steeringTTL) {
            this.steeringTTL = steeringTTL;
        }

        public void setGfwList(List<String> gfwList) {
            this.gfwList = gfwList;
        }

        public void setDirectList(List<String> directList) {
            this.directList = directList;
        }

        public void setWaitIpInfoMillis(int waitIpInfoMillis) {
            this.waitIpInfoMillis = waitIpInfoMillis;
        }

        public void setDdnsSeconds(int ddnsSeconds) {
            this.ddnsSeconds = ddnsSeconds;
        }

        public void setDdnsDomains(List<String> ddnsDomains) {
            this.ddnsDomains = ddnsDomains;
        }

        public void setGodaddyKey(String godaddyKey) {
            this.godaddyKey = godaddyKey;
        }

        public void setPcap2socks(boolean pcap2socks) {
            this.pcap2socks = pcap2socks;
        }

        public void setUdp2rawEndpoint(String udp2rawEndpoint) {
            this.udp2rawEndpoint = udp2rawEndpoint;
        }

        public String toString() {
            return "Main.RSSConf(shadowServer=" + this.getShadowServer() + ", socksPwd=" + this.getSocksPwd() + ", tcpTimeoutSeconds=" + this.getTcpTimeoutSeconds() + ", udpTimeoutSeconds=" + this.getUdpTimeoutSeconds() + ", rpcMinSize=" + this.getRpcMinSize() + ", rpcMaxSize=" + this.getRpcMaxSize() + ", autoWhiteListSeconds=" + this.getAutoWhiteListSeconds() + ", bypassHosts=" + this.getBypassHosts() + ", steeringTTL=" + this.getSteeringTTL() + ", gfwList=" + this.getGfwList() + ", directList=" + this.getDirectList() + ", waitIpInfoMillis=" + this.getWaitIpInfoMillis() + ", ddnsSeconds=" + this.getDdnsSeconds() + ", ddnsDomains=" + this.getDdnsDomains() + ", godaddyKey=" + this.getGodaddyKey() + ", pcap2socks=" + this.isPcap2socks() + ", udp2rawEndpoint=" + this.getUdp2rawEndpoint() + ")";
        }
    }
}

