/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import java.io.Serializable;
import lombok.NonNull;
import org.rx.core.Extends;

public class DataRange<T extends Comparable<T>>
implements Serializable {
    private static final long serialVersionUID = 2698228026798507997L;
    public T start;
    public T end;

    public DataRange(@NonNull T start, @NonNull T end) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        Extends.require(start, start.compareTo(end) <= 0);
        this.start = start;
        this.end = end;
    }

    public boolean has(T data) {
        return this.start.compareTo(data) <= 0 && this.end.compareTo(data) > 0;
    }

    public T getStart() {
        return this.start;
    }

    public T getEnd() {
        return this.end;
    }

    public void setStart(T start) {
        this.start = start;
    }

    public void setEnd(T end) {
        this.end = end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataRange)) {
            return false;
        }
        DataRange other = (DataRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$start = this.getStart();
        T other$start = other.getStart();
        if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
            return false;
        }
        T this$end = this.getEnd();
        T other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !this$end.equals(other$end));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataRange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : $start.hashCode());
        T $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : $end.hashCode());
        return result;
    }

    public String toString() {
        return "DataRange(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
    }

    public DataRange() {
    }
}

