/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import com.alibaba.fastjson2.annotation.JSONField;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.rx.bean.DataColumn;
import org.rx.bean.DataTable;
import org.rx.core.Extends;
import org.rx.core.Reflects;
import org.rx.exception.InvalidException;

public class DataRow
implements Extends {
    private static final long serialVersionUID = 252345291901055072L;
    @JSONField(serialize=false)
    final DataTable table;
    final List<Object> items;

    DataRow(DataTable table) {
        this.table = table;
        this.items = new ArrayList<Object>(table.columns.size());
    }

    public Object[] getArray() {
        return this.items.toArray();
    }

    public void setArray(Object ... array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Extends.require(array, array.length == this.table.columns.size());
        this.items.clear();
        for (int i = 0; i < array.length; ++i) {
            this.set(i, array[i]);
        }
    }

    public <T> T get(int ordinal) {
        return this.get(this.table.getColumn(ordinal));
    }

    public void set(int ordinal, Object item) {
        this.set(this.table.getColumn(ordinal), item);
    }

    public <T> T get(String columnName) {
        return this.get(this.table.getColumn(columnName));
    }

    public void set(String columnName, Object item) {
        this.set(this.table.getColumn(columnName), item);
    }

    public <T> T get(@NonNull DataColumn<T> column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        Extends.require(column, column.getTable() == this.table);
        if (this.items.size() <= column.ordinal) {
            return null;
        }
        return (T)this.items.get(column.ordinal);
    }

    public <T> void set(@NonNull DataColumn<T> column, T item) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        Extends.require(column, column.getTable() == this.table);
        if (column.dataType != null && !Reflects.isInstance(item, column.dataType)) {
            throw new InvalidException("Item type error", new Object[0]);
        }
        if (column.ordinal < this.items.size()) {
            this.items.set(column.ordinal, item);
        } else {
            this.items.add(column.ordinal, item);
        }
    }

    public DataTable getTable() {
        return this.table;
    }
}

