/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import com.alibaba.fastjson2.JSONObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.aggregate.Aggregate;
import org.h2.expression.aggregate.AggregateType;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.result.LocalResult;
import org.h2.value.Value;
import org.h2.value.ValueToObjectConverter;
import org.rx.bean.DataColumn;
import org.rx.bean.DataRow;
import org.rx.bean.FluentIterable;
import org.rx.bean.Tuple;
import org.rx.core.Arrays;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.core.StringBuilder;
import org.rx.core.Sys;
import org.rx.exception.InvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTable
implements Extends {
    private static final Logger log = LoggerFactory.getLogger(DataTable.class);
    private static final long serialVersionUID = -7379386582995440975L;
    public static final String HS_COLUMN_TYPE = "HS_COLUMN_TYPE";
    public static final String HS_COUNT_MAP = "HS_COUNT_MAP";
    String tableName;
    final List<DataColumn> columns = new ArrayList<DataColumn>();
    List<DataColumn> readOnlyColumns;
    final List<DataRow> rows = new ArrayList<DataRow>();
    Iterator<DataRow> fluentRows;

    public static DataTable read(ResultSet resultSet) {
        return DataTable.read(resultSet, false);
    }

    public static DataTable read(ResultSet resultSet, boolean preferColumnName) {
        DataTable dt = new DataTable();
        try (ResultSet rs = resultSet;){
            ResultSetMetaData metaData = rs.getMetaData();
            dt.setTableName(metaData.getTableName(1));
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                dt.addColumn(preferColumnName ? metaData.getColumnName(i) : metaData.getColumnLabel(i));
            }
            ArrayList<Object> buf = new ArrayList<Object>(columnCount);
            while (rs.next()) {
                buf.clear();
                for (int i = 1; i <= columnCount; ++i) {
                    buf.add(rs.getObject(i));
                }
                dt.addRow(buf.toArray());
            }
        }
        return dt;
    }

    public static DataTable read(JdbcResultSet resultSet) {
        DataTable dt = new DataTable();
        try (JdbcResultSet rs = resultSet;){
            LocalResult result = (LocalResult)rs.getResult();
            Expression[] exprs = (Expression[])Reflects.readField(result, "expressions");
            if (exprs.length > 0) {
                dt.setTableName(exprs[0].getTableName());
            }
            for (Expression expr : exprs) {
                DataTable.addColumnName(dt, expr);
            }
            JdbcConnection conn = (JdbcConnection)Reflects.readField(rs, "conn");
            int columnCount = exprs.length;
            ArrayList<Object> buf = new ArrayList<Object>(columnCount);
            while (rs.next()) {
                buf.clear();
                for (int i = 1; i <= columnCount; ++i) {
                    buf.add(ValueToObjectConverter.valueToDefaultObject((Value)rs.getInternal(i), (JdbcConnection)conn, (boolean)true));
                }
                dt.addRow(buf.toArray());
            }
        }
        return dt;
    }

    static void addColumnName(DataTable dt, Expression expr) {
        if (Extends.tryAs(expr, ExpressionColumn.class, p -> {
            String col = p.getOriginalColumnName();
            if (col == null) {
                col = p.getColumn().getName();
            }
            dt.addColumns(col);
        }) || Extends.tryAs(expr, Aggregate.class, p -> {
            if (p.getAggregateType() == AggregateType.COUNT_ALL || p.getAggregateType() == AggregateType.COUNT) {
                String label = p.toString();
                dt.addColumn(label);
                return;
            }
            Expression subExpr = p.getSubexpression(0);
            DataTable.addColumnName(dt, subExpr);
        }) || Extends.tryAs(expr, Alias.class, p -> {
            Expression subExpr = p.getNonAliasExpression();
            Aggregate aggregate = Extends.as(subExpr, Aggregate.class);
            if (aggregate != null && (aggregate.getAggregateType() == AggregateType.COUNT_ALL || aggregate.getAggregateType() == AggregateType.COUNT)) {
                String label = p.getAlias(null, 0);
                dt.addColumn(label).attr(HS_COUNT_MAP, Tuple.of(subExpr.toString(), label));
                return;
            }
            DataTable.addColumnName(dt, subExpr);
        })) {
            // empty if block
        }
    }

    public List<DataColumn<?>> getColumns() {
        if (this.readOnlyColumns == null) {
            this.readOnlyColumns = Collections.unmodifiableList(this.columns);
        }
        return this.readOnlyColumns;
    }

    public FluentIterable<DataRow> getRows() {
        return new FluentIterable<DataRow>(){
            Iterator<DataRow> cur;
            final Iterator<DataRow> next;
            {
                this.cur = DataTable.this.rows.iterator();
                this.next = DataTable.this.fluentRows;
            }

            @Override
            public boolean hasNext() {
                if (!this.cur.hasNext()) {
                    if (this.cur == this.next || this.next == null) {
                        return false;
                    }
                    this.cur = this.next;
                    return this.hasNext();
                }
                return true;
            }

            @Override
            public DataRow next() {
                return this.cur.next();
            }
        };
    }

    public DataTable(String tableName) {
        this.tableName = tableName;
    }

    public <T> List<T> toList(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        ArrayList list = new ArrayList();
        FluentIterable<DataRow> rows = this.getRows();
        while (rows.hasNext()) {
            JSONObject item = new JSONObject(this.columns.size());
            List<Object> cells = ((DataRow)rows.next()).items;
            for (int i = 0; i < this.columns.size(); ++i) {
                item.put((Object)this.columns.get((int)i).columnName, cells.get(i));
            }
            list.add(Sys.fromJson(item, type));
        }
        return list;
    }

    public DataRow addRow(Object ... items) {
        DataRow row = this.newRow(items);
        this.rows.add(row);
        return row;
    }

    public DataRow addRow(DataRow row) {
        if (row.table != this) {
            row = this.newRow(row.getArray());
        }
        this.rows.add(row);
        return row;
    }

    public DataRow removeRow(DataRow row) {
        this.rows.remove(row);
        return row;
    }

    public DataRow newRow(Object ... items) {
        DataRow row = new DataRow(this);
        if (!Arrays.isEmpty((Object[])items)) {
            row.setArray(items);
        }
        return row;
    }

    public List<DataColumn<?>> addColumns(String ... columnNames) {
        List<DataColumn<?>> columns = Linq.from(columnNames).select(this::addColumn).toList();
        return columns;
    }

    public <T> DataColumn<T> addColumn(String columnName) {
        DataColumn column = new DataColumn(this);
        column.ordinal = this.columns.size();
        column.columnName = columnName;
        this.columns.add(column);
        return column;
    }

    public <T> DataColumn<T> removeColumn(String columnName) {
        int index = this.getColumn((String)columnName).ordinal;
        DataColumn column = this.columns.remove(index);
        for (DataRow row : this.rows) {
            row.items.remove(index);
        }
        return column;
    }

    public <T> DataColumn<T> getColumn(int ordinal) {
        return this.columns.get(ordinal);
    }

    public <T> DataColumn<T> getColumn(String columnName) {
        return Linq.from(this.columns).first(p -> Extends.eq(p.columnName, columnName));
    }

    <T> void setOrdinal(DataColumn<T> column, int ordinal) {
        if (this.fluentRows != null) {
            throw new InvalidException("Not supported", new Object[0]);
        }
        if (column.ordinal == ordinal) {
            return;
        }
        this.columns.remove(ordinal);
        this.columns.add(ordinal, column);
        for (DataRow row : this.rows) {
            row.items.add(ordinal, row.items.remove(ordinal));
        }
        column.ordinal = ordinal;
    }

    <TR> DataColumn<TR> setDataType(DataColumn column, Class<TR> dataType) {
        if (this.fluentRows != null) {
            throw new InvalidException("Not supported", new Object[0]);
        }
        if (Reflects.isAssignable(column.dataType, dataType)) {
            return column;
        }
        for (DataRow row : this.rows) {
            row.items.set(column.ordinal, Reflects.changeType(row.items.get(column.ordinal), dataType));
        }
        column.dataType = dataType;
        return column;
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        for (DataColumn<?> column : this.getColumns()) {
            txt.append(column.getColumnName()).append("\t");
        }
        txt.appendLine();
        FluentIterable<DataRow> rows = this.getRows();
        while (rows.hasNext()) {
            for (Object item : ((DataRow)rows.next()).items) {
                txt.append(item).append("\t");
            }
            txt.appendLine();
        }
        return txt.toString();
    }

    public DataTable() {
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setFluentRows(Iterator<DataRow> fluentRows) {
        this.fluentRows = fluentRows;
    }
}

