/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import java.text.ParseException;
import java.time.DayOfWeek;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import lombok.NonNull;
import org.apache.commons.lang3.time.FastDateFormat;
import org.rx.annotation.ErrorCode;
import org.rx.core.Arrays;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.exception.ApplicationException;

public final class DateTime
extends Date {
    private static final long serialVersionUID = 414744178681347341L;
    public static final DateTime MIN = new DateTime(2000, 1, 1, 0, 0, 0);
    public static final DateTime MAX = new DateTime(9999, 12, 31, 0, 0, 0);
    static final String DATE_FORMAT = "yyy-MM-dd";
    static final String TIME_FORMAT = "HH:mm:ss";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss,SSSZ";
    public static final Linq<String> FORMATS = Linq.from("yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss,SSS", "yyyy-MM-dd HH:mm:ss,SSSZ", "yyyyMMddHHmmssSSS");
    static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private Calendar calendar;

    public static DateTime now() {
        return new DateTime(System.currentTimeMillis());
    }

    public static DateTime now(String format) {
        return DateTime.valueOf(DateTime.now().toString(format), format);
    }

    public static DateTime utcNow() {
        return DateTime.now().asUniversalTime();
    }

    @ErrorCode(cause=ParseException.class)
    public static DateTime valueOf(String dateString) {
        Throwable lastEx = null;
        for (String format : Arrays.toList(DATE_TIME_FORMAT, "yyyy-MM-dd HH:mm:ss,SSS", FULL_FORMAT, "yyyyMMddHHmmssSSS")) {
            try {
                return DateTime.valueOf(dateString, format);
            }
            catch (Throwable ex) {
                lastEx = ex;
            }
        }
        throw new ApplicationException(Extends.values(String.join((CharSequence)",", FORMATS), dateString), lastEx);
    }

    public static DateTime valueOf(String dateString, String format) {
        return new DateTime(FastDateFormat.getInstance((String)format).parse(dateString));
    }

    private Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
            this.calendar.setTimeInMillis(super.getTime());
        }
        return this.calendar;
    }

    public DateTime getDatePart() {
        return DateTime.valueOf(this.toDateString(), DATE_FORMAT);
    }

    public DateTime setDatePart(String date) {
        return DateTime.valueOf(this.toString(date + " HH:mm:ss"), DATE_TIME_FORMAT);
    }

    public DateTime getTimePart() {
        return DateTime.valueOf(this.toTimeString(), TIME_FORMAT);
    }

    public DateTime setTimePart(String time) {
        return DateTime.valueOf(this.toString("yyy-MM-dd " + time), DATE_TIME_FORMAT);
    }

    public boolean isToday() {
        return DateTime.now().toString(DATE_FORMAT).equals(this.toDateString());
    }

    @Override
    public int getYear() {
        return this.getCalendar().get(1);
    }

    @Override
    public int getMonth() {
        return this.getCalendar().get(2) + 1;
    }

    @Override
    public int getDay() {
        return this.getCalendar().get(5);
    }

    @Override
    public int getHours() {
        return this.getCalendar().get(11);
    }

    @Override
    public int getMinutes() {
        return this.getCalendar().get(12);
    }

    @Override
    public int getSeconds() {
        return this.getCalendar().get(13);
    }

    public int getMillisecond() {
        return this.getCalendar().get(14);
    }

    public int getDayOfYear() {
        return this.getCalendar().get(6);
    }

    public DayOfWeek getDayOfWeek() {
        return DayOfWeek.of(this.getCalendar().get(7));
    }

    public double getTotalDays() {
        return (double)super.getTime() / 8.64E7;
    }

    public double getTotalHours() {
        return (double)super.getTime() / 3600000.0;
    }

    public double getTotalMinutes() {
        return (double)super.getTime() / 60000.0;
    }

    public double getTotalSeconds() {
        return (double)super.getTime() / 1000.0;
    }

    public double getTotalMilliseconds() {
        return super.getTime();
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second) {
        Calendar c = this.getCalendar();
        c.set(year, month - 1, day, hour, minute, second);
        super.setTime(c.getTimeInMillis());
    }

    public DateTime(@NonNull Date date) {
        super(date.getTime());
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
    }

    public DateTime(long ticks) {
        super(ticks);
    }

    @Override
    public void setTime(long time) {
        super.setTime(time);
        if (this.calendar != null) {
            this.calendar.setTimeInMillis(time);
        }
    }

    public DateTime addYears(int value) {
        return this.add(1, value);
    }

    public DateTime addMonths(int value) {
        return this.add(2, value);
    }

    public DateTime addDays(int value) {
        return this.add(5, value);
    }

    public DateTime addHours(int value) {
        return this.add(11, value);
    }

    public DateTime addMinutes(int value) {
        return this.add(12, value);
    }

    public DateTime addSeconds(int value) {
        return this.add(13, value);
    }

    public DateTime addMilliseconds(int value) {
        return this.add(14, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateTime add(int field, int value) {
        Calendar c = this.getCalendar();
        long mark = c.getTimeInMillis();
        c.set(field, c.get(field) + value);
        try {
            DateTime newVal = new DateTime(c.getTimeInMillis());
            newVal.getCalendar().setTimeZone(this.getCalendar().getTimeZone());
            DateTime dateTime = newVal;
            return dateTime;
        }
        finally {
            c.setTimeInMillis(mark);
        }
    }

    public DateTime addTicks(long ticks) {
        return new DateTime(super.getTime() + ticks);
    }

    public DateTime add(@NonNull Date value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.addTicks(value.getTime());
    }

    public DateTime subtract(@NonNull Date value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new DateTime(super.getTime() - value.getTime());
    }

    public DateTime asLocalTime() {
        this.getCalendar().setTimeZone(TimeZone.getDefault());
        return this;
    }

    public DateTime asUniversalTime() {
        this.getCalendar().setTimeZone(UTC_ZONE);
        return this;
    }

    public String toDateString() {
        return this.toString(DATE_FORMAT);
    }

    public String toTimeString() {
        return this.toString(TIME_FORMAT);
    }

    public String toDateTimeString() {
        return this.toString(DATE_TIME_FORMAT);
    }

    @Override
    public String toString() {
        return this.toString(FULL_FORMAT);
    }

    public String toString(@NonNull String format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        return FastDateFormat.getInstance((String)format, (TimeZone)this.getCalendar().getTimeZone()).format((Date)this);
    }
}

