/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import lombok.NonNull;
import org.rx.core.Extends;
import org.rx.core.StringBuilder;

@JSONType(serializer=JsonWriter.class, deserializer=JsonReader.class)
public class Decimal
extends Number
implements Comparable<Decimal> {
    private static final long serialVersionUID = 6538774206304848828L;
    static final String PERCENT_SYMBOL = "%";
    static final String PERMILLE_SYMBOL = "\u2030";
    static final BigDecimal PERCENT_DIVISOR = new BigDecimal(100);
    static final BigDecimal PERMILLE_DIVISOR = new BigDecimal(1000);
    static final int DEFAULT_SCALE = 2;
    static final RoundingMode DEFAULT_MODE = RoundingMode.DOWN;
    public static final Decimal ZERO = Decimal.valueOf(BigDecimal.ZERO);
    private final BigDecimal value;
    private int scale;
    private RoundingMode mode;

    public static Decimal fromPermille(Double permille) {
        return Decimal.fromPermille(BigDecimal.valueOf(permille == null ? 0.0 : permille));
    }

    public static Decimal fromPermille(BigDecimal permille) {
        return Decimal.fromPermille(permille, 3);
    }

    public static Decimal fromPermille(BigDecimal permille, int scale) {
        return Decimal.valueOf(permille, scale, DEFAULT_MODE).divide(PERMILLE_DIVISOR);
    }

    public static Decimal fromPercent(Double percent) {
        return Decimal.fromPercent(BigDecimal.valueOf(percent == null ? 0.0 : percent));
    }

    public static Decimal fromPercent(BigDecimal percent) {
        return Decimal.fromPercent(percent, 2);
    }

    public static Decimal fromPercent(BigDecimal percent, int scale) {
        return Decimal.valueOf(percent, scale, DEFAULT_MODE).divide(PERCENT_DIVISOR);
    }

    public static Decimal fromCent(Long cent) {
        return Decimal.valueOf(BigDecimal.valueOf(Extends.ifNull(cent, 0L))).divide(PERCENT_DIVISOR);
    }

    public static Decimal valueOf(String expr) {
        return Decimal.valueOf(expr, 2, DEFAULT_MODE);
    }

    public static Decimal valueOf(String expr, int scale) {
        return Decimal.valueOf(expr, scale, DEFAULT_MODE);
    }

    public static Decimal valueOf(@NonNull String expr, int scale, RoundingMode mode) {
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        BigDecimal d = BigDecimal.ONE;
        if (expr.endsWith(PERCENT_SYMBOL)) {
            d = PERCENT_DIVISOR;
        } else if (expr.endsWith(PERMILLE_SYMBOL)) {
            d = PERMILLE_DIVISOR;
        }
        if (!d.equals(BigDecimal.ONE)) {
            expr = expr.substring(0, expr.length() - 1);
        }
        return Decimal.valueOf(new BigDecimal(expr), scale, mode).divide(d);
    }

    public static Decimal valueOf(Double value) {
        return Decimal.valueOf(BigDecimal.valueOf(value == null ? 0.0 : value));
    }

    public static Decimal valueOf(BigDecimal value) {
        return Decimal.valueOf(value, 2, DEFAULT_MODE);
    }

    public static Decimal valueOf(BigDecimal value, int scale, RoundingMode mode) {
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        return new Decimal(value, scale, mode);
    }

    public boolean isZero() {
        return this.value.compareTo(BigDecimal.ZERO) == 0;
    }

    public Decimal(BigDecimal value) {
        this(value, 2, DEFAULT_MODE);
    }

    public Decimal(@NonNull BigDecimal value, int scale, RoundingMode mode) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.scale = scale;
        this.mode = mode;
        this.value = value.setScale(this.scale, this.mode);
    }

    protected void before(BigDecimal value) {
    }

    protected Decimal after(BigDecimal value) {
        return new Decimal(value, this.scale, this.mode);
    }

    public Decimal add(Decimal decimal) {
        if (decimal == null) {
            decimal = ZERO;
        }
        return this.add(decimal.value);
    }

    public Decimal add(double value) {
        return this.add(BigDecimal.valueOf(value));
    }

    public Decimal add(BigDecimal val) {
        if (val == null) {
            val = BigDecimal.ZERO;
        }
        this.before(val);
        return this.after(this.value.add(val).setScale(this.scale, this.mode));
    }

    public Decimal subtract(Decimal decimal) {
        if (decimal == null) {
            decimal = ZERO;
        }
        return this.subtract(decimal.value);
    }

    public Decimal subtract(double value) {
        return this.subtract(BigDecimal.valueOf(value));
    }

    public Decimal subtract(BigDecimal val) {
        if (val == null) {
            val = BigDecimal.ZERO;
        }
        this.before(val);
        return this.after(this.value.subtract(val).setScale(this.scale, this.mode));
    }

    public Decimal multiply(Decimal decimal) {
        if (decimal == null) {
            decimal = ZERO;
        }
        return this.multiply(decimal.value);
    }

    public Decimal multiply(double value) {
        return this.multiply(BigDecimal.valueOf(value));
    }

    public Decimal multiply(BigDecimal val) {
        if (val == null) {
            return ZERO;
        }
        this.before(val);
        return this.after(this.value.multiply(val).setScale(this.scale, this.mode));
    }

    public Decimal divide(Decimal decimal) {
        if (decimal == null) {
            decimal = ZERO;
        }
        return this.divide(decimal.value);
    }

    public Decimal divide(double value) {
        return this.divide(BigDecimal.valueOf(value));
    }

    public Decimal divide(BigDecimal val) {
        if (val == null) {
            return ZERO;
        }
        this.before(val);
        return this.after(this.value.divide(val, this.scale, this.mode));
    }

    public Decimal max(double value) {
        return this.max(Decimal.valueOf(value));
    }

    public Decimal max(Decimal o) {
        return this.compareTo(o) >= 0 ? this : o;
    }

    public Decimal min(double value) {
        return this.min(Decimal.valueOf(value));
    }

    public Decimal min(Decimal o) {
        return this.compareTo(o) <= 0 ? this : o;
    }

    public boolean gt(double value) {
        return this.gt(Decimal.valueOf(value));
    }

    public boolean gt(Decimal o) {
        return this.compareTo(o) > 0;
    }

    public boolean ge(double value) {
        return this.ge(Decimal.valueOf(value));
    }

    public boolean ge(Decimal o) {
        return this.compareTo(o) >= 0;
    }

    public boolean lt(double value) {
        return this.lt(Decimal.valueOf(value));
    }

    public boolean lt(Decimal o) {
        return this.compareTo(o) < 0;
    }

    public boolean le(double value) {
        return this.le(Decimal.valueOf(value));
    }

    public boolean le(Decimal o) {
        return this.compareTo(o) <= 0;
    }

    public boolean eq(double value) {
        return this.eq(Decimal.valueOf(value));
    }

    public boolean eq(Decimal o) {
        return this.compareTo(o) == 0;
    }

    public Decimal negate() {
        return this.after(this.value.negate());
    }

    public long toCent() {
        return this.multiply((BigDecimal)Decimal.PERCENT_DIVISOR).value.longValue();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean padding) {
        if (padding) {
            return this.value.toString();
        }
        StringBuilder pattern = new StringBuilder("#");
        for (int i = 0; i < this.scale; ++i) {
            if (i == 0) {
                pattern.append(".");
            }
            pattern.append("#");
        }
        return this.toString(pattern.toString());
    }

    public String toString(String format) {
        return new DecimalFormat(format).format(this.value);
    }

    public String toCurrencyString() {
        return this.toCurrencyString(Locale.getDefault());
    }

    public String toCurrencyString(Locale inLocale) {
        return NumberFormat.getCurrencyInstance(inLocale).format(this.value);
    }

    public int toPermilleInt() {
        return this.value.multiply(PERMILLE_DIVISOR).setScale(0, this.mode).intValueExact();
    }

    public String toPermilleString() {
        return this.toPermilleInt() + PERMILLE_SYMBOL;
    }

    public int toPercentInt() {
        return this.value.multiply(PERCENT_DIVISOR).setScale(0, this.mode).intValueExact();
    }

    public String toPercentString() {
        return this.value.multiply(PERCENT_DIVISOR).setScale(1, this.mode).stripTrailingZeros().toPlainString() + PERCENT_SYMBOL;
    }

    @Override
    public int compareTo(double val) {
        return this.compareTo(Decimal.valueOf(val));
    }

    @Override
    public int compareTo(@NonNull Decimal o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return this.value.compareTo(o.value);
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Decimal)) {
            return false;
        }
        Decimal other = (Decimal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.scale != other.scale) {
            return false;
        }
        BigDecimal this$value = this.getValue();
        BigDecimal other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        RoundingMode this$mode = this.mode;
        RoundingMode other$mode = other.mode;
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Decimal;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.scale;
        BigDecimal $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        RoundingMode $mode = this.mode;
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setMode(RoundingMode mode) {
        this.mode = mode;
    }

    public static class JsonWriter
    implements ObjectWriter<Decimal> {
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            jsonWriter.writeDecimal(((Decimal)object).getValue());
        }
    }

    public static class JsonReader
    implements ObjectReader<Decimal> {
        public Decimal readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.nextIfNull()) {
                return null;
            }
            return Decimal.valueOf(jsonReader.readBigDecimal());
        }
    }
}

