/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import java.util.EnumMap;
import java.util.EnumSet;
import lombok.NonNull;
import org.rx.bean.NEnum;
import org.rx.core.Arrays;
import org.rx.core.Linq;
import org.rx.core.Strings;
import org.rx.util.function.BiFunc;

public final class FlagsEnum<T extends Enum<T>>
implements NEnum<T> {
    private static final long serialVersionUID = -8582923090238462905L;
    private final Class<T> type;
    private int flags;

    public static <T extends Enum<T>> FlagsEnum<T> valueOf(@NonNull Class<T> type, int flags) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        FlagsEnum<T> flagsEnum = null;
        for (Enum constant : (Enum[])type.getEnumConstants()) {
            if ((flags & ((NEnum)((Object)constant)).getValue()) != ((NEnum)((Object)constant)).getValue()) continue;
            if (flagsEnum == null) {
                flagsEnum = new FlagsEnum<T>((NEnum)((Object)constant));
                continue;
            }
            flagsEnum.add(new Enum[]{constant});
        }
        return flagsEnum;
    }

    public static <T extends Enum<T>> FlagsEnum<T> valueOf(@NonNull Class<T> type, @NonNull EnumSet<T> enumSet) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("enumSet is marked non-null but is null");
        }
        int flags = 0;
        for (Enum t : enumSet) {
            flags |= ((NEnum)((Object)t)).getValue();
        }
        return FlagsEnum.valueOf(type, flags);
    }

    public static <T extends Enum<T>> FlagsEnum<T> valueOf(@NonNull Class<T> type, @NonNull String names) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (names == null) {
            throw new NullPointerException("names is marked non-null but is null");
        }
        return FlagsEnum.valueOf(type, EnumSet.copyOf(Linq.from(Strings.split(names, ", ")).join(Arrays.toList((Enum[])type.getEnumConstants()), (p1, p2) -> p1.equals(p2.name()), (p1, p2) -> p2).toList()));
    }

    public String name() {
        return String.join((CharSequence)", ", Linq.from(this.toSet()).select(rec$ -> ((Enum)rec$).name()));
    }

    @Override
    public int getValue() {
        return this.flags;
    }

    @Override
    public String description() {
        return String.join((CharSequence)", ", Linq.from(this.toSet()).select(rec$ -> ((NEnum)rec$).description()));
    }

    FlagsEnum(NEnum<T> nEnum) {
        this.type = nEnum.getClass();
        this.flags = nEnum.getValue();
    }

    public FlagsEnum<T> add(FlagsEnum<T> fEnum) {
        if (fEnum != null) {
            this.flags |= fEnum.flags;
        }
        return this;
    }

    public FlagsEnum<T> remove(FlagsEnum<T> fEnum) {
        if (fEnum != null) {
            this.flags &= ~fEnum.flags;
        }
        return this;
    }

    public boolean has(FlagsEnum<T> fEnum) {
        return fEnum != null && (this.flags & fEnum.flags) == fEnum.flags;
    }

    public FlagsEnum<T> add(T ... nEnum) {
        if (!Arrays.isEmpty((Object[])nEnum)) {
            for (T t : nEnum) {
                this.flags |= ((NEnum)t).getValue();
            }
        }
        return this;
    }

    public FlagsEnum<T> remove(T ... nEnum) {
        if (!Arrays.isEmpty((Object[])nEnum)) {
            for (T t : nEnum) {
                this.flags &= ~((NEnum)t).getValue();
            }
        }
        return this;
    }

    public boolean has(T ... nEnum) {
        int val = 0;
        if (!Arrays.isEmpty((Object[])nEnum)) {
            for (T t : nEnum) {
                val |= ((NEnum)t).getValue();
            }
        }
        return (this.flags & val) == val;
    }

    public EnumSet<T> toSet() {
        EnumSet<T> set = EnumSet.noneOf(this.type);
        for (Enum constant : (Enum[])this.type.getEnumConstants()) {
            if (!this.has(new Enum[]{constant})) continue;
            set.add(constant);
        }
        return set;
    }

    public <V> EnumMap<T, V> toMap(@NonNull BiFunc<T, V> compute) {
        if (compute == null) {
            throw new NullPointerException("compute is marked non-null but is null");
        }
        EnumMap<T, V> map = new EnumMap<T, V>(this.type);
        for (Enum constant : (Enum[])this.type.getEnumConstants()) {
            if (!this.has(new Enum[]{constant})) continue;
            map.put((T)constant, compute.invoke(constant));
        }
        return map;
    }
}

