/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.rx.bean.AbstractMap;
import org.rx.util.function.BiFunc;

public class MapView<KS, K, V>
implements AbstractMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1937534858824236935L;
    final Map<KS, V> map;
    final BiFunc<KS, K> keyView;
    transient EntrySetView<KS, K, V> entrySet;

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public V get(Object key) {
        Iterator<Map.Entry<KS, V>> i = this.map.entrySet().iterator();
        if (key == null) {
            while (i.hasNext()) {
                Map.Entry<KS, V> e = i.next();
                if (e.getKey() != null) continue;
                return e.getValue();
            }
        } else {
            while (i.hasNext()) {
                Map.Entry<KS, V> e = i.next();
                if (!key.equals(this.keyView.apply(e.getKey()))) continue;
                return e.getValue();
            }
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        Map.Entry<KS, V> e;
        Iterator<Map.Entry<KS, V>> i = this.map.entrySet().iterator();
        Map.Entry<KS, V> correctEntry = null;
        if (key == null) {
            while (correctEntry == null && i.hasNext()) {
                e = i.next();
                if (e.getKey() != null) continue;
                correctEntry = e;
            }
        } else {
            while (correctEntry == null && i.hasNext()) {
                e = i.next();
                if (!key.equals(e.getKey())) continue;
                correctEntry = e;
            }
        }
        V oldValue = null;
        if (correctEntry != null) {
            oldValue = correctEntry.getValue();
            i.remove();
        }
        return oldValue;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetView<KS, K, V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySetView<KS, K, V>(this.map, this.keyView));
    }

    public MapView(Map<KS, V> map, BiFunc<KS, K> keyView) {
        this.map = map;
        this.keyView = keyView;
    }

    static final class EntrySetView<KS, K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        final Map<KS, V> map;
        final BiFunc<KS, K> keyView;

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator<Map.Entry<KS, V>> iterator = this.map.entrySet().iterator();
            return new Iterator<Map.Entry<K, V>>(){
                Map.Entry<KS, V> entry;
                K key;

                @Override
                public boolean hasNext() {
                    while (iterator.hasNext()) {
                        this.entry = (Map.Entry)iterator.next();
                        this.key = keyView.apply(this.entry.getKey());
                        if (this.key == null) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new AbstractMap.SimpleEntry<K, V>(this.key, this.entry.getValue()){
                        private static final long serialVersionUID = -1039216080459017222L;

                        @Override
                        public V setValue(V value) {
                            Object v = entry.getValue();
                            super.setValue(value);
                            map.put(entry.getKey(), value);
                            return v;
                        }
                    };
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        public EntrySetView(Map<KS, V> map, BiFunc<KS, K> keyView) {
            this.map = map;
            this.keyView = keyView;
        }
    }
}

