/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import java.util.Set;
import lombok.NonNull;
import org.rx.bean.LogStrategy;
import org.rx.core.EventArgs;
import org.rx.util.function.Func;

public class ProceedEventArgs
extends EventArgs {
    private static final long serialVersionUID = -2969747570419733673L;
    private final Class<?> declaringType;
    private final Object[] parameters;
    private final boolean isVoid;
    private Object returnValue;
    private long elapsedNanos = -1L;
    private Throwable error;
    private LogStrategy logStrategy;
    private Set<String> logTypeWhitelist;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T proceed(@NonNull Func<T> proceed) throws Throwable {
        if (proceed == null) {
            throw new NullPointerException("proceed is marked non-null but is null");
        }
        long start = System.nanoTime();
        try {
            T retVal = proceed.invoke();
            this.returnValue = retVal;
            T t = retVal;
            return t;
        }
        finally {
            this.elapsedNanos = System.nanoTime() - start;
        }
    }

    public Class<?> getDeclaringType() {
        return this.declaringType;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public boolean isVoid() {
        return this.isVoid;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public long getElapsedNanos() {
        return this.elapsedNanos;
    }

    public Throwable getError() {
        return this.error;
    }

    public LogStrategy getLogStrategy() {
        return this.logStrategy;
    }

    public Set<String> getLogTypeWhitelist() {
        return this.logTypeWhitelist;
    }

    public ProceedEventArgs(Class<?> declaringType, Object[] parameters, boolean isVoid) {
        this.declaringType = declaringType;
        this.parameters = parameters;
        this.isVoid = isVoid;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public void setLogStrategy(LogStrategy logStrategy) {
        this.logStrategy = logStrategy;
    }

    public void setLogTypeWhitelist(Set<String> logTypeWhitelist) {
        this.logTypeWhitelist = logTypeWhitelist;
    }
}

