/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import io.netty.util.internal.ThreadLocalRandom;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.rx.bean.DataRange;
import org.rx.core.Cache;
import org.rx.core.CachePolicy;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.util.function.BiFunc;

public class RandomList<T>
extends AbstractList<T>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 675332324858046587L;
    public static final int DEFAULT_WEIGHT = 2;
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    final List<WeightElement<T>> elements = new ArrayList<WeightElement<T>>();
    int maxRandomValue;
    CopyOnWriteArrayList<T> temp;
    BiFunc<T, ? extends Comparable> sortFunc;

    public RandomList(Collection<T> elements) {
        this.addAll((Collection<? extends T>)elements);
    }

    public <S> T next(S steeringKey, int ttl) {
        return this.next(steeringKey, ttl, false);
    }

    public <S> T next(S steeringKey, int ttl, boolean isSliding) {
        Cache<Object, Object> cache = Cache.getInstance(Cache.MEMORY_CACHE);
        return (T)cache.get(steeringKey, k -> this.next(), isSliding ? CachePolicy.sliding(ttl) : CachePolicy.absolute(ttl));
    }

    public T next() {
        this.lock.writeLock().lock();
        try {
            if (this.elements.isEmpty()) {
                throw new NoSuchElementException();
            }
            if (this.maxRandomValue == 0) {
                WeightElement<T> holder = null;
                for (int i = 0; i < this.elements.size(); ++i) {
                    WeightElement<T> element = this.elements.get(i);
                    if (i == 0) {
                        ((WeightElement)element).threshold.start = 0;
                        ((WeightElement)element).threshold.end = ((WeightElement)element).weight;
                    } else {
                        ((WeightElement)element).threshold.start = ((WeightElement)holder).threshold.end;
                        ((WeightElement)element).threshold.end = (Integer)((WeightElement)element).threshold.start + ((WeightElement)element).weight;
                    }
                    holder = element;
                }
                this.maxRandomValue = (Integer)((WeightElement)holder).threshold.end;
            }
            int v = ThreadLocalRandom.current().nextInt(this.maxRandomValue);
            int low = 0;
            int high = this.elements.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                WeightElement<T> element = this.elements.get(mid);
                DataRange threshold = ((WeightElement)element).threshold;
                if ((Integer)threshold.end <= v) {
                    low = mid + 1;
                    continue;
                }
                if ((Integer)threshold.start > v) {
                    high = mid - 1;
                    continue;
                }
                Object object = ((WeightElement)element).element;
                return (T)object;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<T> aliveList() {
        this.lock.readLock().lock();
        try {
            List<Object> list = Linq.from(this.elements).where(p -> ((WeightElement)p).weight > 0).select(p -> ((WeightElement)p).element).toList();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getWeight(T element) {
        this.lock.readLock().lock();
        try {
            int n = ((WeightElement)this.findElement(element, true)).weight;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setWeight(T element, int weight) {
        Extends.require(weight, weight >= 0);
        this.lock.writeLock().lock();
        try {
            ((WeightElement)this.findElement(element, true)).weight = weight;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean change(boolean changed) {
        if (changed) {
            if (this.sortFunc != null) {
                this.elements.sort((o1, o2) -> {
                    Comparable c1 = this.sortFunc.apply(((WeightElement)o1).element);
                    Comparable c2 = this.sortFunc.apply(((WeightElement)o2).element);
                    if (c1 == null || c2 == null) {
                        return c1 == null ? (c2 == null ? 0 : 1) : -1;
                    }
                    return c1.compareTo(c2);
                });
            }
            this.temp = null;
            this.maxRandomValue = 0;
        }
        return changed;
    }

    private WeightElement<T> findElement(T element, boolean throwOnEmpty) {
        WeightElement node = Linq.from(this.elements).firstOrDefault(p -> Extends.eq(((WeightElement)p).element, element));
        if (throwOnEmpty && node == null) {
            throw new NoSuchElementException();
        }
        return node;
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.elements.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T get(int index) {
        this.lock.readLock().lock();
        try {
            Object object = ((WeightElement)this.elements.get(index)).element;
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean add(T element) {
        return this.add(element, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T element, int weight) {
        Extends.require(weight, weight >= 0);
        this.lock.writeLock().lock();
        try {
            boolean changed;
            WeightElement<T> node = this.findElement(element, false);
            if (node == null) {
                changed = this.elements.add(new WeightElement<T>(element, weight));
            } else {
                changed = ((WeightElement)node).weight != weight;
                if (changed) {
                    ((WeightElement)node).weight = weight;
                }
            }
            boolean bl = this.change(changed);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void add(int index, T element) {
        this.add(index, element, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int index, T element, int weight) {
        Extends.require(weight, weight >= 0);
        this.lock.writeLock().lock();
        try {
            boolean changed;
            WeightElement<T> node = this.findElement(element, false);
            if (node == null) {
                this.elements.add(index, new WeightElement<T>(element, weight));
                changed = true;
            } else {
                changed = ((WeightElement)node).weight != weight;
                if (changed) {
                    ((WeightElement)node).weight = weight;
                }
            }
            boolean bl = this.change(changed);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public T set(int index, T element) {
        return this.set(index, element, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T set(int index, T element, int weight) {
        Extends.require(weight, weight >= 0);
        this.lock.writeLock().lock();
        try {
            boolean changed;
            WeightElement<T> previously = null;
            WeightElement<T> node = this.findElement(element, false);
            if (node == null) {
                previously = this.elements.set(index, new WeightElement<T>(element, weight));
                changed = true;
            } else {
                changed = ((WeightElement)node).weight != weight;
                if (changed) {
                    ((WeightElement)node).weight = weight;
                }
            }
            this.change(changed);
            Object object = previously == null ? null : ((WeightElement)previously).element;
            return (T)object;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Object element) {
        return this.removeIf((Predicate<? super T>)((Predicate<Object>)p -> Extends.eq(p, element)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        this.lock.writeLock().lock();
        try {
            WeightElement<T> item = this.elements.remove(index);
            if (item == null) {
                T t = null;
                return t;
            }
            this.change(true);
            Object object = ((WeightElement)item).element;
            return (T)object;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.change(this.elements.removeIf((? super E p) -> filter.test(((WeightElement)p).element)));
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean contains(Object element) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.findElement(element, false) != null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        this.lock.readLock().lock();
        try {
            if (this.temp == null) {
                this.temp = new CopyOnWriteArrayList<Object>(Linq.from(this.elements).select(p -> ((WeightElement)p).element).toList());
            }
            Iterator<T> iterator = this.temp.iterator();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.lock.writeLock().lock();
        try {
            boolean changed = false;
            for (T t : c) {
                if (!this.add(t)) continue;
                changed = true;
            }
            boolean bl = this.change(changed);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.change(this.elements.removeAll(Linq.from(this.elements).join(c, (p, x) -> Extends.eq(((WeightElement)p).element, x), (p, x) -> p).toList()));
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            List<WeightElement> items = Linq.from(this.elements).join(c, (p, x) -> Extends.eq(((WeightElement)p).element, x), (p, x) -> p).toList();
            this.elements.clear();
            boolean bl = this.change(this.elements.addAll(items));
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.elements.clear();
            this.change(true);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public RandomList() {
    }

    public void setSortFunc(BiFunc<T, ? extends Comparable> sortFunc) {
        this.sortFunc = sortFunc;
    }

    static class WeightElement<T>
    implements Serializable {
        private static final long serialVersionUID = 7199704019570049544L;
        private final T element;
        private int weight;
        private final DataRange<Integer> threshold = new DataRange();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeightElement that = (WeightElement)o;
            return Objects.equals(this.element, that.element);
        }

        public int hashCode() {
            return Objects.hash(this.element);
        }

        public WeightElement(T element, int weight) {
            this.element = element;
            this.weight = weight;
        }
    }
}

