/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import lombok.NonNull;
import org.rx.codec.CodecUtil;
import org.rx.exception.InvalidException;
import org.rx.io.Bytes;
import org.rx.io.Serializer;

@JSONType(serializer=JsonWriter.class, deserializer=JsonReader.class)
public final class ULID
implements Serializable,
Comparable<ULID> {
    private static final long serialVersionUID = -8408685951892844844L;
    final byte[] buf;
    transient long timestamp = -1L;
    transient String hexString;
    transient String base64String;

    public static ULID randomULID() {
        return new ULID(Bytes.randomBytes(16), System.currentTimeMillis());
    }

    public static ULID nameULID(String name) {
        return new ULID(CodecUtil.md5(name));
    }

    public static ULID newULID(@NonNull Object name, long timestamp) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (name instanceof String) {
            return ULID.newULID(((String)name).getBytes(), timestamp);
        }
        if (name instanceof Long) {
            return ULID.newULID(Bytes.getBytes((Long)name), timestamp);
        }
        return ULID.newULID(Serializer.DEFAULT.serialize(name).toArray(), timestamp);
    }

    public static ULID newULID(byte[] name, long timestamp) {
        return new ULID(CodecUtil.md5(name), timestamp);
    }

    public static ULID valueOf(@NonNull String ulid) {
        if (ulid == null) {
            throw new NullPointerException("ulid is marked non-null but is null");
        }
        byte[] buf = null;
        switch (ulid.length()) {
            case 22: {
                buf = Base64.getUrlDecoder().decode(ulid);
                break;
            }
            case 36: {
                ulid = ulid.replace("-", "");
            }
            case 32: {
                byte[] hexBytes = ulid.getBytes();
                buf = new byte[16];
                CodecUtil.HEX.decode(hexBytes, 0, hexBytes.length, buf, 0);
            }
        }
        if (buf == null) {
            throw new InvalidException("Invalid ULID {}", ulid);
        }
        return new ULID(buf);
    }

    public static ULID valueOf(UUID uuid) {
        byte[] buf = new byte[16];
        Bytes.getBytes(uuid.getMostSignificantBits(), buf, 0);
        Bytes.getBytes(uuid.getLeastSignificantBits(), buf, 8);
        return new ULID(buf);
    }

    public static ULID valueOf(byte[] buf) {
        if (buf == null || buf.length != 16) {
            throw new InvalidException("Invalid ULID", new Object[0]);
        }
        return new ULID(buf);
    }

    private ULID(byte[] buf, long timestamp) {
        buf[0] = (byte)(timestamp >>> 40);
        buf[1] = (byte)(timestamp >>> 32);
        buf[2] = (byte)(timestamp >>> 24);
        buf[3] = (byte)(timestamp >>> 16);
        buf[4] = (byte)(timestamp >>> 8);
        buf[5] = (byte)timestamp;
        this.buf = buf;
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        if (this.timestamp == -1L) {
            this.timestamp = ((long)this.buf[0] & 0xFFL) << 40 | ((long)this.buf[1] & 0xFFL) << 32 | ((long)this.buf[2] & 0xFFL) << 24 | ((long)this.buf[3] & 0xFFL) << 16 | ((long)this.buf[4] & 0xFFL) << 8 | (long)this.buf[5] & 0xFFL;
        }
        return this.timestamp;
    }

    public String toBase64String() {
        if (this.base64String == null) {
            this.base64String = Base64.getUrlEncoder().withoutPadding().encodeToString(this.buf);
        }
        return this.base64String;
    }

    public UUID toUUID() {
        int i;
        byte[] guidBytes = this.buf;
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(guidBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(guidBytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public String toString() {
        if (this.hexString == null) {
            byte[] hexBytes = new byte[32];
            CodecUtil.HEX.encode(this.buf, 0, this.buf.length, hexBytes, 0);
            this.hexString = new String(hexBytes);
        }
        return this.hexString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ULID ulid = (ULID)o;
        return Arrays.equals(this.buf, ulid.buf);
    }

    public int hashCode() {
        return Arrays.hashCode(this.buf);
    }

    @Override
    public int compareTo(ULID val) {
        return Long.compare(this.getTimestamp(), val.getTimestamp());
    }

    private ULID(byte[] buf) {
        this.buf = buf;
    }

    public static class JsonWriter
    implements ObjectWriter<ULID> {
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            jsonWriter.writeString(object.toString());
        }
    }

    public static class JsonReader
    implements ObjectReader<ULID> {
        public ULID readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.nextIfNull()) {
                return null;
            }
            return ULID.valueOf(jsonReader.readString());
        }
    }
}

