/*
 * Decompiled with CFR 0.152.
 */
package org.rx.bean;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.rx.bean.AbstractMap;
import org.rx.bean.MapView;

public class WeakIdentityMap<K, V>
implements AbstractMap<K, V> {
    final Map<WeakReference<K>, V> map;
    final ReferenceQueue<K> refQueue = new ReferenceQueue();
    transient MapView.EntrySetView<WeakReference<K>, K, V> entrySet;

    public WeakIdentityMap() {
        this(16);
    }

    public WeakIdentityMap(int initialCapacity) {
        this.map = new ConcurrentHashMap<WeakReference<K>, V>(initialCapacity);
    }

    @Override
    public int size() {
        this.expunge();
        return this.map.size();
    }

    @Override
    public V get(Object key) {
        this.expunge();
        Objects.requireNonNull(key, "key");
        IdentityWeakReference<Object> keyref = new IdentityWeakReference<Object>(key);
        return this.map.get(keyref);
    }

    @Override
    public V put(K key, V value) {
        this.expunge();
        Objects.requireNonNull(key, "key");
        IdentityWeakReference<K> keyref = new IdentityWeakReference<K>(key, this.refQueue);
        return this.map.put(keyref, value);
    }

    @Override
    public V remove(Object key) {
        this.expunge();
        Objects.requireNonNull(key, "key");
        IdentityWeakReference<Object> keyref = new IdentityWeakReference<Object>(key);
        return this.map.remove(keyref);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expunge();
        MapView.EntrySetView<WeakReference<K>, K, V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new MapView.EntrySetView<WeakReference, Object, V>(this.map, Reference::get));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.expunge();
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        IdentityWeakReference<K> keyref = new IdentityWeakReference<K>(key, this.refQueue);
        return (V)this.map.computeIfAbsent(keyref, p -> mappingFunction.apply((Object)key));
    }

    private void expunge() {
        Reference<K> ref;
        while ((ref = this.refQueue.poll()) != null) {
            this.map.remove(ref);
        }
    }

    private static class IdentityWeakReference<T>
    extends WeakReference<T> {
        final int hashCode;

        IdentityWeakReference(T o) {
            this(o, (ReferenceQueue<T>)null);
        }

        IdentityWeakReference(T o, ReferenceQueue<T> q) {
            super(o, q);
            this.hashCode = o == null ? 0 : System.identityHashCode(o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdentityWeakReference)) {
                return false;
            }
            Object got = this.get();
            return got != null && got == ((IdentityWeakReference)o).get();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

