/*
 * Decompiled with CFR 0.152.
 */
package org.rx.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import lombok.NonNull;
import org.rx.bean.DateTime;
import org.rx.codec.CodecUtil;
import org.rx.core.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtil {
    private static final Logger log = LoggerFactory.getLogger(AESUtil.class);
    static final String AES_ALGORITHM = "AES/ECB/PKCS5Padding";
    static final int KEY_SIZE = 128;
    private static String lastDate;
    private static byte[] dateKey;

    public static byte[] dailyKey() {
        String date = DateTime.utcNow().toDateString();
        if (Strings.hashEquals(lastDate, date)) {
            return dateKey;
        }
        lastDate = date;
        dateKey = AESUtil.dateKey(date);
        return dateKey;
    }

    private static byte[] dateKey(String date) {
        return String.format("\u211e%s", date).getBytes(StandardCharsets.UTF_8);
    }

    public static String encryptToBase64(String data) {
        return AESUtil.encryptToBase64(data, null);
    }

    public static String encryptToBase64(@NonNull String data, String key) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        byte[] k = key == null ? AESUtil.dailyKey() : key.getBytes(StandardCharsets.UTF_8);
        byte[] valueByte = AESUtil.encrypt(data.getBytes(StandardCharsets.UTF_8), k);
        return CodecUtil.convertToBase64(valueByte);
    }

    public static String decryptFromBase64(String data) {
        return AESUtil.decryptFromBase64(data, null);
    }

    public static String decryptFromBase64(@NonNull String data, String key) {
        byte[] valueByte;
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        boolean dk = key == null;
        byte[] k = dk ? AESUtil.dailyKey() : key.getBytes(StandardCharsets.UTF_8);
        byte[] rawBytes = CodecUtil.convertFromBase64(data);
        try {
            valueByte = AESUtil.decrypt(rawBytes, k);
        }
        catch (Exception e) {
            DateTime utcNow;
            if (dk && e instanceof BadPaddingException && (utcNow = DateTime.utcNow()).getHours() == 0 && utcNow.getMinutes() == 0) {
                log.warn("redo decrypt");
                valueByte = AESUtil.decrypt(rawBytes, AESUtil.dateKey(utcNow.addDays(-1).toDateString()));
            }
            throw e;
        }
        return new String(valueByte, StandardCharsets.UTF_8);
    }

    public static SecretKey generateKey(byte[] seed) {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(seed);
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        keygen.init(128, random);
        return keygen.generateKey();
    }

    public static ByteBuf encrypt(@NonNull ByteBuf buf, byte[] key) {
        if (buf == null) {
            throw new NullPointerException("buf is marked non-null but is null");
        }
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(1, AESUtil.generateKey(key));
        ByteBuffer in = buf.nioBuffer();
        int outputSize = cipher.getOutputSize(in.remaining());
        ByteBuffer out = ByteBuffer.allocateDirect(outputSize);
        cipher.doFinal(in, out);
        return Unpooled.wrappedBuffer((ByteBuffer)out.flip());
    }

    public static ByteBuf decrypt(@NonNull ByteBuf buf, byte[] key) {
        if (buf == null) {
            throw new NullPointerException("buf is marked non-null but is null");
        }
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(2, AESUtil.generateKey(key));
        ByteBuffer in = buf.nioBuffer();
        int outputSize = cipher.getOutputSize(in.remaining());
        ByteBuffer out = ByteBuffer.allocateDirect(outputSize);
        cipher.doFinal(in, out);
        return Unpooled.wrappedBuffer((ByteBuffer)out.flip());
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(1, AESUtil.generateKey(key));
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(2, AESUtil.generateKey(key));
        return cipher.doFinal(data);
    }
}

