/*
 * Decompiled with CFR 0.152.
 */
package org.rx.codec;

import io.netty.buffer.ByteBufUtil;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import lombok.NonNull;
import org.bouncycastle.util.encoders.HexTranslator;
import org.rx.io.Bytes;
import org.rx.io.FileStream;
import org.rx.io.MemoryStream;
import org.rx.io.Serializer;
import org.rx.third.open.CrcModel;

public class CodecUtil {
    public static final HexTranslator HEX = new HexTranslator();

    public static String convertToBase64(byte[] data) {
        byte[] ret = Base64.getEncoder().encode(data);
        return new String(ret, StandardCharsets.UTF_8);
    }

    public static byte[] convertFromBase64(@NonNull String base64) {
        if (base64 == null) {
            throw new NullPointerException("base64 is marked non-null but is null");
        }
        byte[] data = base64.getBytes(StandardCharsets.UTF_8);
        return Base64.getDecoder().decode(data);
    }

    public static <T extends Serializable> String serializeToBase64(T obj) {
        byte[] data = Serializer.DEFAULT.serializeToBytes(obj);
        return CodecUtil.convertToBase64(data);
    }

    public static <T extends Serializable> T deserializeFromBase64(String base64) {
        byte[] data = CodecUtil.convertFromBase64(base64);
        return (T)((Serializable)Serializer.DEFAULT.deserialize(new MemoryStream(data, 0, data.length)));
    }

    public static BigInteger hashUnsigned64(Object ... args) {
        return CodecUtil.hashUnsigned64(Serializer.DEFAULT.serializeToBytes(args));
    }

    public static BigInteger hashUnsigned64(byte[] buf) {
        return CodecUtil.hashUnsigned64(buf, 0, buf.length);
    }

    public static BigInteger hashUnsigned64(byte[] buf, int offset, int len) {
        long value = CodecUtil.hash64(buf, offset, len);
        BigInteger bigInt = BigInteger.valueOf(value & Long.MAX_VALUE);
        if (value < 0L) {
            bigInt = bigInt.setBit(63);
        }
        return bigInt;
    }

    public static long hash64(Object ... dataArray) {
        return CodecUtil.hash64(Serializer.DEFAULT.serializeToBytes(dataArray));
    }

    public static long hash64(String data) {
        return CodecUtil.hash64(data.getBytes(StandardCharsets.UTF_8));
    }

    public static long hash64(long data) {
        return CodecUtil.hash64(Bytes.getBytes(data));
    }

    public static long hash64(byte[] buf) {
        return CodecUtil.hash64(buf, 0, buf.length);
    }

    public static long hash64(byte[] buf, int offset, int len) {
        return CrcModel.CRC64_ECMA_182.getCRC(buf, offset, len).getCrc();
    }

    public static byte[] md5(@NonNull File file) {
        byte[] byArray;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (FileStream fs = new FileStream(file);){
            int read;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buf = Bytes.arrayBuffer();
            while ((read = fs.read(buf)) > 0) {
                md.update(buf, 0, read);
            }
            byArray = md.digest();
        }
        return byArray;
    }

    public static byte[] md5(@NonNull String data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return CodecUtil.md5(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] md5(byte[] data) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        return md.digest(data);
    }

    public static String hexMd5(@NonNull String data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return CodecUtil.hexMd5(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String hexMd5(byte[] data) {
        return ByteBufUtil.hexDump((byte[])CodecUtil.md5(data));
    }
}

