/*
 * Decompiled with CFR 0.152.
 */
package org.rx.codec;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import lombok.NonNull;
import org.rx.codec.CodecUtil;

public final class RSAUtil {
    static final String SIGN_ALGORITHMS = "MD5withRSA";
    static final String SIGN_ALGORITHMS2 = "SHA1WithRSA";
    static final String RSA_ALGORITHM = "RSA/ECB/PKCS1Padding";

    public static String[] generateKeyPair() {
        KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
        keygen.initialize(1024, new SecureRandom());
        KeyPair keys = keygen.genKeyPair();
        PublicKey pubkey = keys.getPublic();
        PrivateKey prikey = keys.getPrivate();
        String pubKeyStr = CodecUtil.convertToBase64(pubkey.getEncoded());
        String priKeyStr = CodecUtil.convertToBase64(prikey.getEncoded());
        return new String[]{pubKeyStr, priKeyStr};
    }

    public static String sign(@NonNull TreeMap<String, Object> map, String privateKey) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        StringBuilder content = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            content.append(entry.getValue());
        }
        return RSAUtil.sign(content.toString(), privateKey);
    }

    public static String sign(String content, String privateKey) {
        return RSAUtil.sign(content, privateKey, false);
    }

    public static String sign(@NonNull String content, @NonNull String privateKey, boolean isSHA1) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(CodecUtil.convertFromBase64(privateKey));
        KeyFactory keyf = KeyFactory.getInstance("RSA");
        PrivateKey priKey = keyf.generatePrivate(keySpec);
        Signature signature = Signature.getInstance(isSHA1 ? SIGN_ALGORITHMS2 : SIGN_ALGORITHMS);
        signature.initSign(priKey);
        signature.update(content.getBytes(StandardCharsets.UTF_8));
        return CodecUtil.convertToBase64(signature.sign());
    }

    public static boolean verify(@NonNull TreeMap<String, Object> map, String sign, String publicKey) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        StringBuilder content = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            content.append(entry.getValue());
        }
        return RSAUtil.verify(content.toString(), sign, publicKey);
    }

    public static boolean verify(String content, String sign, String publicKey) {
        return RSAUtil.verify(content, sign, publicKey, false);
    }

    public static boolean verify(@NonNull String content, @NonNull String sign, @NonNull String publicKey, boolean isSHA1) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (sign == null) {
            throw new NullPointerException("sign is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(CodecUtil.convertFromBase64(publicKey)));
        Signature signature = Signature.getInstance(isSHA1 ? SIGN_ALGORITHMS2 : SIGN_ALGORITHMS);
        signature.initVerify(pubKey);
        signature.update(content.getBytes(StandardCharsets.UTF_8));
        return signature.verify(CodecUtil.convertFromBase64(sign));
    }

    public static String encrypt(@NonNull String source, @NonNull String publicKey) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey key = keyFactory.generatePublic(new X509EncodedKeySpec(CodecUtil.convertFromBase64(publicKey)));
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(1, key);
        byte[] b = cipher.doFinal(source.getBytes(StandardCharsets.UTF_8));
        return CodecUtil.convertToBase64(b);
    }

    public static String decrypt(@NonNull String cryptoGraph, @NonNull String privateKey) {
        if (cryptoGraph == null) {
            throw new NullPointerException("cryptoGraph is marked non-null but is null");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey key = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(CodecUtil.convertFromBase64(privateKey)));
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, key);
        byte[] b = CodecUtil.convertFromBase64(cryptoGraph);
        return new String(cipher.doFinal(b));
    }
}

