/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.rx.exception.InvalidException;

public class Arrays
extends ArrayUtils {
    public static <T> List<T> toList(Enumeration<T> enumeration) {
        return EnumerationUtils.toList(enumeration);
    }

    public static <T> List<T> toList(@NonNull T one) {
        if (one == null) {
            throw new NullPointerException("one is marked non-null but is null");
        }
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(one);
        return list;
    }

    @SafeVarargs
    public static <T> List<T> toList(T ... items) {
        if (items == null) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList(items.length);
        Collections.addAll(list, items);
        return list;
    }

    public static int randomNext(int[] array) {
        if (Arrays.isEmpty((int[])array)) {
            throw new InvalidException("Empty array", new Object[0]);
        }
        return array[ThreadLocalRandom.current().nextInt(0, array.length)];
    }

    public static <T> T randomNext(T[] array) {
        if (Arrays.isEmpty((Object[])array)) {
            throw new InvalidException("Empty array", new Object[0]);
        }
        return array[ThreadLocalRandom.current().nextInt(0, array.length)];
    }

    public static boolean equals(byte[] a, byte[] b) {
        return java.util.Arrays.equals(a, b);
    }
}

