/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import lombok.NonNull;
import org.rx.bean.AbstractMap;
import org.rx.core.CachePolicy;
import org.rx.core.IOC;
import org.rx.core.cache.DiskCache;
import org.rx.core.cache.MemoryCache;
import org.rx.util.function.BiFunc;

public interface Cache<TK, TV>
extends AbstractMap<TK, TV> {
    public static final Class<MemoryCache> MEMORY_CACHE = MemoryCache.class;
    public static final Class<DiskCache> DISK_CACHE = DiskCache.class;

    public static <TK, TV> TV getOrSet(TK key, BiFunc<TK, TV> loadingFunc) {
        return Cache.getOrSet(key, loadingFunc, null);
    }

    public static <TK, TV> TV getOrSet(@NonNull TK key, @NonNull BiFunc<TK, TV> loadingFunc, CachePolicy expiration) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (loadingFunc == null) {
            throw new NullPointerException("loadingFunc is marked non-null but is null");
        }
        return Cache.getInstance().get(key, loadingFunc, expiration);
    }

    public static <TK, TV> Cache<TK, TV> getInstance() {
        return IOC.get(Cache.class);
    }

    public static <TK, TV> Cache<TK, TV> getInstance(Class<? extends Cache> cacheType) {
        return IOC.get(cacheType, MemoryCache.class);
    }

    default public TV get(TK key, BiFunc<TK, TV> loadingFunc) {
        return this.get(key, loadingFunc, null);
    }

    default public TV get(TK key, BiFunc<TK, TV> loadingFunc, CachePolicy policy) {
        TV newValue;
        Object v = this.get(key);
        if (v == null && (newValue = loadingFunc.invoke(key)) != null) {
            this.put(key, newValue, policy);
            return newValue;
        }
        return (TV)v;
    }

    @Override
    default public TV put(TK key, TV value) {
        return this.put(key, value, null);
    }

    public TV put(TK var1, TV var2, CachePolicy var3);
}

