/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.io.Serializable;
import org.rx.bean.DateTime;
import org.rx.core.Constants;
import org.rx.core.Tasks;

public class CachePolicy
implements Serializable {
    private static final long serialVersionUID = 4378825072232415879L;
    long expiration = Long.MAX_VALUE;
    int slidingSpan;

    public static CachePolicy today() {
        return CachePolicy.today(86400);
    }

    public static CachePolicy today(int expireSeconds) {
        DateTime max;
        DateTime now = DateTime.now();
        DateTime expire = now.addSeconds(expireSeconds);
        return new CachePolicy((expire.before(max = now.setTimePart("23:59:59")) ? expire : max).getTime(), 0);
    }

    public static CachePolicy absolute(int expireSeconds) {
        return new CachePolicy(DateTime.now().addSeconds(expireSeconds).getTime(), 0);
    }

    public static CachePolicy sliding(int expireSeconds) {
        return new CachePolicy(DateTime.now().addSeconds(expireSeconds).getTime(), expireSeconds * 1000);
    }

    public boolean isExpired() {
        return this.expiration <= System.currentTimeMillis();
    }

    protected CachePolicy(CachePolicy policy) {
        if (policy == null) {
            return;
        }
        this.expiration = policy.expiration;
        this.slidingSpan = policy.slidingSpan;
    }

    public long ttl() {
        return this.ttl(this.slidingSpan > 0);
    }

    public long ttl(boolean slidingRenew) {
        long ttl = Math.max(0L, this.expiration - System.currentTimeMillis());
        if (ttl > 0L && slidingRenew) {
            Tasks.setTimeout(this::slidingRenew, 100L, this, Constants.TIMER_REPLACE_FLAG);
        }
        return ttl;
    }

    public boolean slidingRenew() {
        if (this.slidingSpan <= 0) {
            return false;
        }
        if ((this.expiration += (long)this.slidingSpan) < 0L) {
            this.expiration = Long.MAX_VALUE;
        }
        return true;
    }

    public CachePolicy(long expiration, int slidingSpan) {
        this.expiration = expiration;
        this.slidingSpan = slidingSpan;
    }

    public long getExpiration() {
        return this.expiration;
    }
}

