/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.lang.reflect.Field;
import java.util.EventObject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import lombok.NonNull;
import org.rx.core.EventArgs;
import org.rx.core.EventPublisher;
import org.rx.core.Extends;
import org.rx.core.IOC;
import org.rx.core.Reflects;
import org.rx.exception.InvalidException;
import org.rx.exception.TraceHandler;
import org.rx.util.function.TripleAction;

public class Delegate<TSender extends EventPublisher<TSender>, TArgs extends EventArgs>
implements TripleAction<TSender, TArgs> {
    final Set<TripleAction<TSender, TArgs>> invocations = new CopyOnWriteArraySet<TripleAction<TSender, TArgs>>();
    volatile TripleAction<TSender, TArgs> firstInvocation;
    volatile TripleAction<TSender, TArgs> lastInvocation;

    public static <TSender extends EventPublisher<TSender>, TArgs extends EventArgs> Delegate<TSender, TArgs> create() {
        return Delegate.create(null);
    }

    @SafeVarargs
    public static <TSender extends EventPublisher<TSender>, TArgs extends EventArgs> Delegate<TSender, TArgs> create(TripleAction<TSender, TArgs> ... delegates) {
        return new Delegate<TSender, TArgs>().combine(delegates);
    }

    public static <TSender extends EventPublisher<TSender>, TArgs extends EventArgs> Delegate<TSender, TArgs> wrap(@NonNull EventPublisher<TSender> target, @NonNull String fnName) {
        Delegate d;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (fnName == null) {
            throw new NullPointerException("fnName is marked non-null but is null");
        }
        Field field = Reflects.getFieldMap(target.getClass()).get(fnName);
        if (field != null) {
            d = (Delegate)field.get(target);
            if (d == null) {
                throw new InvalidException("Event {} not defined", fnName);
            }
        } else {
            if (!target.eventFlags().has(new EventPublisher.EventFlags[]{EventPublisher.EventFlags.DYNAMIC_ATTACH})) {
                throw new InvalidException("Event {} not defined", fnName);
            }
            d = IOC.weakMap(target, false).computeIfAbsent(fnName, k -> new Delegate());
        }
        return d;
    }

    public boolean isEmpty() {
        return this.invocations.isEmpty() && this.firstInvocation == null && this.lastInvocation == null;
    }

    public Delegate<TSender, TArgs> first(TripleAction<TSender, TArgs> delegate) {
        this.firstInvocation = delegate;
        return this;
    }

    public Delegate<TSender, TArgs> last(TripleAction<TSender, TArgs> delegate) {
        this.lastInvocation = delegate;
        return this;
    }

    @SafeVarargs
    public final Delegate<TSender, TArgs> replace(TripleAction<TSender, TArgs> ... delegates) {
        this.invocations.clear();
        return this.combine(delegates);
    }

    @SafeVarargs
    public final Delegate<TSender, TArgs> combine(TripleAction<TSender, TArgs> ... delegates) {
        if (delegates == null) {
            return this;
        }
        for (TripleAction<TSender, TArgs> delegate : delegates) {
            if (delegate == null || Extends.tryAs(delegate, Delegate.class, d -> this.invocations.addAll(d.invocations))) continue;
            this.invocations.add(delegate);
        }
        return this;
    }

    @SafeVarargs
    public final Delegate<TSender, TArgs> remove(TripleAction<TSender, TArgs> ... delegates) {
        if (delegates == null) {
            return this;
        }
        for (TripleAction<TSender, TArgs> delegate : delegates) {
            if (delegate == null || Extends.tryAs(delegate, Delegate.class, d -> this.invocations.removeAll(d.invocations))) continue;
            this.invocations.remove(delegate);
        }
        return this;
    }

    public Delegate<TSender, TArgs> close() {
        Extends.tryClose(this.firstInvocation);
        for (TripleAction<TSender, TArgs> invocation : this.invocations) {
            Extends.tryClose(invocation);
        }
        Extends.tryClose(this.lastInvocation);
        return this.purge();
    }

    public Delegate<TSender, TArgs> purge() {
        this.invocations.clear();
        this.lastInvocation = null;
        this.firstInvocation = null;
        return this;
    }

    public <T extends EventObject> void invoke(T event) throws Throwable {
        this.invoke((TSender)((EventPublisher)event.getSource()), (TArgs)((EventArgs)((Object)event)));
    }

    @Override
    public void invoke(@NonNull TSender target, @NonNull TArgs args) throws Throwable {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (!this.innerInvoke(this.firstInvocation, target, args)) {
            return;
        }
        for (TripleAction<TSender, TArgs> delegate : this.invocations) {
            if (!this.innerInvoke(delegate, target, args)) break;
        }
        this.innerInvoke(this.lastInvocation, target, args);
    }

    boolean innerInvoke(TripleAction<TSender, TArgs> delegate, TSender target, TArgs args) throws Throwable {
        if (delegate == null) {
            return true;
        }
        try {
            delegate.invoke(target, args);
            return !((EventArgs)args).isCancel() && !((EventArgs)args).isHandled();
        }
        catch (Throwable e) {
            if (!target.eventFlags().has(new EventPublisher.EventFlags[]{EventPublisher.EventFlags.QUIETLY})) {
                throw e;
            }
            TraceHandler.INSTANCE.log(e);
            return true;
        }
    }

    private Delegate() {
    }
}

