/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import org.rx.annotation.ErrorCode;
import org.rx.core.Extends;
import org.rx.exception.ApplicationException;

public abstract class Disposable
implements AutoCloseable {
    private volatile boolean closed;

    public boolean isClosed() {
        return this.closed;
    }

    protected abstract void freeObjects() throws Throwable;

    @ErrorCode
    protected void checkNotClosed() {
        if (this.closed) {
            throw new ApplicationException(Extends.values(this.getClass().getSimpleName()));
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.freeObjects();
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

