/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import lombok.NonNull;
import org.apache.commons.lang3.ClassUtils;
import org.rx.annotation.Metadata;
import org.rx.annotation.Subscribe;
import org.rx.bean.Tuple;
import org.rx.core.Constants;
import org.rx.core.Delegate;
import org.rx.core.EventPublisher;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.NEventArgs;
import org.rx.core.Reflects;
import org.rx.exception.InvalidException;
import org.rx.exception.TraceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBus
implements EventPublisher<EventBus> {
    private static final Logger log = LoggerFactory.getLogger(EventBus.class);
    public static final EventBus DEFAULT = new EventBus();
    static final int TOPIC_MAP_INITIAL_CAPACITY = 4;
    public final Delegate<EventBus, NEventArgs<?>> onDeadEvent = Delegate.create();
    final Map<Class<?>, Map<Serializable, Set<Tuple<Object, Method>>>> subscribers = new ConcurrentHashMap();

    static <T> Serializable getTopic(T event) {
        Object topic = null;
        Metadata m = event.getClass().getAnnotation(Metadata.class);
        if (m != null) {
            if (m.topicClass() != Object.class) {
                topic = m.topicClass();
            } else if (!m.topic().isEmpty()) {
                topic = m.topic();
            }
        }
        return topic;
    }

    public <T> void register(@NonNull T subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("subscriber is marked non-null but is null");
        }
        for (Map.Entry<Class<?>, Set<Tuple<Object, Method>>> entry : this.findAllSubscribers(subscriber).entrySet()) {
            Class<?> eventType = entry.getKey();
            Set<Tuple<Object, Method>> eventMethods = entry.getValue();
            Map topicMap = this.subscribers.computeIfAbsent(eventType, k -> new ConcurrentHashMap(4));
            for (Map.Entry<Serializable, Set> subEntry : Linq.from(eventMethods).groupByIntoMap(p -> {
                Subscribe m = ((Method)p.right).getAnnotation(Subscribe.class);
                if (m.topicClass() != Object.class) {
                    return m.topicClass();
                }
                if (!m.topic().isEmpty()) {
                    return m.topic();
                }
                return m.value();
            }, (p, x) -> x.toSet()).entrySet()) {
                topicMap.computeIfAbsent(subEntry.getKey(), k -> new CopyOnWriteArraySet()).addAll(subEntry.getValue());
            }
        }
    }

    public <T> void unregister(T subscriber) {
        this.unregister(subscriber, null);
    }

    public <T, TT extends Serializable> void unregister(@NonNull T subscriber, TT topic) {
        if (subscriber == null) {
            throw new NullPointerException("subscriber is marked non-null but is null");
        }
        boolean exist = false;
        for (Map.Entry<Class<?>, Set<Tuple<Object, Method>>> entry : this.findAllSubscribers(subscriber).entrySet()) {
            Class<?> eventType = entry.getKey();
            Collection eventMethods = entry.getValue();
            Map topicMap = this.subscribers.getOrDefault(eventType, Collections.emptyMap());
            if (topic == null) {
                for (Set currentSubscribers : topicMap.values()) {
                    if (!currentSubscribers.removeAll(eventMethods)) continue;
                    exist = true;
                }
                continue;
            }
            Set currentSubscribers = (Set)topicMap.get(topic);
            if (currentSubscribers == null || !currentSubscribers.removeAll(eventMethods)) continue;
            exist = true;
        }
        if (!exist) {
            throw new InvalidException("missing event subscriber for an annotated method. Is {}[{}] registered?", subscriber, topic);
        }
    }

    Map<Class<?>, Set<Tuple<Object, Method>>> findAllSubscribers(Object listener) {
        HashMap methodsInListener = new HashMap();
        for (Method method : Linq.from(Reflects.getMethodMap(listener instanceof Class ? (Class<?>)listener : listener.getClass()).values()).selectMany(p -> p).where(p -> p.isAnnotationPresent(Subscribe.class) && !p.isSynthetic())) {
            if (method.getParameterCount() != 1) {
                throw new InvalidException("Subscriber method %s has @Subscribe annotation must have exactly 1 parameter.", method);
            }
            Class<?> eventType = method.getParameterTypes()[0];
            methodsInListener.computeIfAbsent(eventType, k -> new HashSet()).add(Tuple.of(listener, method));
        }
        return methodsInListener;
    }

    public <T> void publish(T event) {
        this.publish(event, EventBus.getTopic(event));
    }

    public <T, TT extends Serializable> void publish(@NonNull T event, TT topic) {
        Set eventSubscribers;
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.debug("publish[{}] {}", topic, event);
        Class<?> type = event.getClass();
        List eventTypes = ClassUtils.getAllSuperclasses(type);
        eventTypes.add(type);
        Linq<Class> q = Linq.from(eventTypes);
        Set set = eventSubscribers = topic == null ? q.selectMany(p -> this.subscribers.getOrDefault(p, Collections.emptyMap()).values()).selectMany(p -> p).toSet() : q.selectMany(p -> this.subscribers.getOrDefault(p, Collections.emptyMap()).getOrDefault(topic, Collections.emptySet())).toSet();
        if (eventSubscribers.isEmpty()) {
            TraceHandler.INSTANCE.saveMetric(Constants.MetricName.DEAD_EVENT.name(), String.format("The event %s[%s] had no subscribers", event, topic));
            this.raiseEvent(this.onDeadEvent, new NEventArgs<T>(event));
            return;
        }
        Extends.eachQuietly(eventSubscribers, p -> Reflects.invokeMethod((Method)p.right, p.left, event));
    }
}

