/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.util.EventListener;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.rx.bean.FlagsEnum;
import org.rx.bean.NEnum;
import org.rx.core.Delegate;
import org.rx.core.EventArgs;
import org.rx.core.Tasks;
import org.rx.core.ThreadPool;
import org.rx.util.function.TripleAction;

public interface EventPublisher<TSender extends EventPublisher<TSender>>
extends EventListener {
    public static final StaticEventPublisher STATIC_EVENT_INSTANCE = new StaticEventPublisher();

    default public FlagsEnum<EventFlags> eventFlags() {
        return EventFlags.DYNAMIC_ATTACH.flags();
    }

    @NonNull
    default public ThreadPool asyncScheduler() {
        return Tasks.nextPool();
    }

    default public <TArgs extends EventArgs> void attachEvent(String eventName, TripleAction<TSender, TArgs> event) {
        this.attachEvent(eventName, event, true);
    }

    default public <TArgs extends EventArgs> void attachEvent(@NonNull String eventName, TripleAction<TSender, TArgs> event, boolean combine) {
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        Delegate d = Delegate.wrap(this, eventName);
        if (combine) {
            d.combine(event);
            return;
        }
        d.replace(event);
    }

    default public <TArgs extends EventArgs> void detachEvent(@NonNull String eventName, TripleAction<TSender, TArgs> event) {
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        Delegate d = Delegate.wrap(this, eventName);
        d.remove(event);
    }

    default public <TArgs extends EventArgs> void raiseEvent(@NonNull String eventName, TArgs args) {
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        Delegate<EventPublisher, TArgs> d = Delegate.wrap(this, eventName);
        d.invoke(this, args);
    }

    default public <TArgs extends EventArgs> void raiseEvent(Delegate<TSender, TArgs> event, @NonNull TArgs args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (event.isEmpty()) {
            return;
        }
        event.invoke(this, args);
    }

    default public <TArgs extends EventArgs> CompletableFuture<Void> raiseEventAsync(String eventName, TArgs args) {
        return this.asyncScheduler().runAsync(() -> this.raiseEvent(eventName, args));
    }

    default public <TArgs extends EventArgs> CompletableFuture<Void> raiseEventAsync(Delegate<TSender, TArgs> event, TArgs args) {
        if (event.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.asyncScheduler().runAsync(() -> this.raiseEvent(event, args));
    }

    public static enum EventFlags implements NEnum<EventFlags>
    {
        NONE(0),
        DYNAMIC_ATTACH(1),
        QUIETLY(2);

        final int value;

        private EventFlags(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static class StaticEventPublisher
    implements EventPublisher<StaticEventPublisher> {
        private StaticEventPublisher() {
        }
    }
}

