/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.NonNull;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.rx.annotation.ErrorCode;
import org.rx.annotation.Metadata;
import org.rx.core.IOC;
import org.rx.core.Linq;
import org.rx.core.ThreadPool;
import org.rx.exception.ApplicationException;
import org.rx.exception.InvalidException;
import org.rx.exception.TraceHandler;
import org.rx.util.function.Action;
import org.rx.util.function.BiAction;
import org.rx.util.function.Func;

public interface Extends
extends Serializable {
    public static <T> List<T> newConcurrentList(boolean readMore) {
        return readMore ? new CopyOnWriteArrayList() : new Vector();
    }

    public static <T> List<T> newConcurrentList(int initialCapacity) {
        return Extends.newConcurrentList(initialCapacity, false);
    }

    public static <T> List<T> newConcurrentList(int initialCapacity, boolean readMore) {
        return readMore ? new CopyOnWriteArrayList() : new Vector(initialCapacity);
    }

    public static <T> T require(T arg) {
        if (arg == null) {
            throw new IllegalArgumentException("The object requires non null");
        }
        return arg;
    }

    @ErrorCode(value="test")
    public static <T> void require(T arg, boolean testResult) {
        Extends.require(arg);
        if (!testResult) {
            throw new ApplicationException("test", Extends.values(arg));
        }
    }

    public static boolean quietly(Action fn) {
        return Extends.quietly(fn, 1, false);
    }

    public static boolean quietly(Action fn, int retryCount) {
        return Extends.quietly(fn, retryCount, false);
    }

    public static boolean quietly(@NonNull Action fn, int retryCount, boolean throwOnLast) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        Throwable last = null;
        for (int i = 0; i < retryCount; ++i) {
            try {
                fn.invoke();
                return true;
            }
            catch (Throwable e) {
                TraceHandler.INSTANCE.log("quietly retry={}/{}", i, retryCount, e);
                last = e;
                continue;
            }
        }
        if (last != null && throwOnLast) {
            throw InvalidException.sneaky(last);
        }
        return false;
    }

    public static <T> T quietly(Func<T> fn) {
        return Extends.quietly(fn, 1, Func.EMPTY);
    }

    public static <T> T quietly(Func<T> fn, int retryCount) {
        return Extends.quietly(fn, retryCount, null);
    }

    public static <T> T quietly(Func<T> fn, Func<T> defaultValue) {
        return Extends.quietly(fn, 1, defaultValue);
    }

    public static <T> T quietly(@NonNull Func<T> fn, int retryCount, Func<T> defaultValue) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        Throwable last = null;
        for (int i = 0; i < retryCount; ++i) {
            try {
                return fn.invoke();
            }
            catch (Throwable e) {
                TraceHandler.INSTANCE.log("quietly retry={}/{}", i, retryCount, e);
                last = e;
                continue;
            }
        }
        if (last != null && defaultValue == null) {
            throw InvalidException.sneaky(last);
        }
        if (defaultValue != null) {
            return defaultValue.get();
        }
        return null;
    }

    public static <T> void eachQuietly(Object array, BiAction<T> fn) {
        Extends.eachQuietly(Linq.fromIterable(array), fn);
    }

    public static <T> void eachQuietly(Iterable<T> iterable, BiAction<T> fn) {
        Extends.each(iterable, fn, false, -1L);
    }

    public static <T> void eachQuietly(Iterable<T> iterable, BiAction<T> fn, long interruptedFlag) {
        Extends.each(iterable, fn, false, interruptedFlag);
    }

    public static <T> void each(Object array, BiAction<T> fn) {
        Extends.each(Linq.fromIterable(array), fn);
    }

    public static <T> void each(Iterable<T> iterable, BiAction<T> fn) {
        Extends.each(iterable, fn, true, -1L);
    }

    public static <T> void each(Iterable<T> iterable, BiAction<T> fn, boolean throwOnNext, long interruptedFlag) {
        if (iterable == null || fn == null) {
            return;
        }
        for (T t : iterable) {
            try {
                fn.invoke(t);
            }
            catch (Throwable e) {
                if (throwOnNext) {
                    throw InvalidException.sneaky(e);
                }
                TraceHandler.INSTANCE.log("each", e);
            }
            if (!ThreadPool.asyncContinueFlag(true)) break;
            if (interruptedFlag < 0L) {
                if (!Thread.interrupted()) continue;
                break;
            }
            try {
                Thread.sleep(interruptedFlag);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public static void circuitContinue(boolean flag) {
        ThreadPool.ASYNC_CONTINUE.set((Object)flag);
    }

    public static void sleep(long millis) {
        Thread.sleep(millis);
    }

    public static boolean tryClose(Object obj) {
        return Extends.tryAs(obj, AutoCloseable.class, p -> Extends.quietly(p::close));
    }

    public static boolean tryClose(AutoCloseable obj) {
        if (obj == null) {
            return false;
        }
        Extends.quietly(obj::close);
        return true;
    }

    public static <T> boolean tryAs(Object obj, Class<T> type) {
        return Extends.tryAs(obj, type, null);
    }

    public static <T> boolean tryAs(Object obj, Class<T> type, BiAction<T> fn) {
        T t = Extends.as(obj, type);
        if (t == null) {
            return false;
        }
        if (fn != null) {
            fn.invoke(t);
        }
        return true;
    }

    public static String metadata(@NonNull AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            throw new NullPointerException("annotatedElement is marked non-null but is null");
        }
        Metadata m = annotatedElement.getAnnotation(Metadata.class);
        if (m == null) {
            return null;
        }
        return m.value();
    }

    public static Object[] values(Object ... args) {
        return args;
    }

    public static <T> T ifNull(T value, T defaultVal) {
        return value != null ? value : defaultVal;
    }

    public static <T> T ifNull(T value, Func<T> fn) {
        if (value == null && fn != null) {
            value = fn.invoke();
        }
        return value;
    }

    public static <T> T as(Object obj, Class<T> type) {
        if (!TypeUtils.isInstance((Object)obj, type)) {
            return null;
        }
        return (T)obj;
    }

    public static <T> boolean eq(T a, T b) {
        return a == b || a != null && a.equals(b);
    }

    default public <TK, TV> TV attr(TK key) {
        return (TV)IOC.weakMap(this, false).get(key);
    }

    default public <TK, TV> void attr(TK key, TV value) {
        Map<TK, TV> map = IOC.weakMap(this, false);
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }
}

