/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.rx.core.Arrays;
import org.rx.core.Extends;
import org.rx.core.WaitHandle;
import org.rx.exception.InvalidException;
import org.rx.util.function.BiAction;
import org.rx.util.function.BiFunc;
import org.rx.util.function.PredicateFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentWait
implements WaitHandle {
    private static final Logger log = LoggerFactory.getLogger(FluentWait.class);
    final long timeout;
    final long interval;
    private BiFunc<FluentWait, Object> resultFunc;
    private List<Class<? extends Throwable>> ignoredExceptions;
    private String message;
    private long retryMillis = -1L;
    private BiAction<FluentWait> retryFunc;
    private boolean retryOnStart;
    private int evaluatedCount;
    volatile boolean doBreak;

    public static FluentWait polling(long timeoutMillis) {
        return FluentWait.polling(timeoutMillis, 500L);
    }

    public static FluentWait polling(long timeoutMillis, long intervalMillis) {
        return FluentWait.polling(timeoutMillis, intervalMillis, null);
    }

    public static <T> FluentWait polling(long timeoutMillis, long intervalMillis, BiFunc<FluentWait, T> resultFunc) {
        Extends.require(timeoutMillis, timeoutMillis > -1L);
        Extends.require(intervalMillis, intervalMillis > -1L);
        FluentWait wait = new FluentWait(timeoutMillis, intervalMillis);
        wait.resultFunc = resultFunc;
        return wait;
    }

    @SafeVarargs
    public final synchronized FluentWait ignoreExceptions(Class<? extends Throwable> ... exceptions) {
        if (this.ignoredExceptions == null) {
            this.ignoredExceptions = new ArrayList<Class<? extends Throwable>>();
        }
        this.ignoredExceptions.addAll(Arrays.toList(exceptions));
        return this;
    }

    public synchronized FluentWait withMessage(String message) {
        this.message = message;
        return this;
    }

    public FluentWait retryEvery(long interval, BiAction<FluentWait> retryFunc) {
        return this.retryEvery(interval, retryFunc, false);
    }

    public synchronized FluentWait retryEvery(long interval, BiAction<FluentWait> retryFunc, boolean retryOnStart) {
        Extends.require(interval, interval >= -1L);
        this.retryMillis = interval;
        this.retryFunc = retryFunc;
        this.retryOnStart = retryOnStart;
        return this;
    }

    private Throwable propagateIfNotIgnored(Throwable e) {
        if (this.ignoredExceptions != null) {
            for (Class<? extends Throwable> ignoredException : this.ignoredExceptions) {
                if (!ignoredException.isInstance(e)) continue;
                return e;
            }
        }
        throw InvalidException.sneaky(e);
    }

    public boolean awaitTrue(PredicateFunc<FluentWait> isTrue) {
        try {
            return Extends.ifNull(this.await(w -> isTrue.invoke((FluentWait)w) ? Boolean.TRUE : null), Boolean.FALSE);
        }
        catch (TimeoutException timeoutException) {
            return false;
        }
    }

    public <T> T await() throws TimeoutException {
        return (T)this.await(this.resultFunc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized <T> T await(@NonNull BiFunc<FluentWait, T> resultFunc) throws TimeoutException {
        if (resultFunc == null) {
            throw new NullPointerException("resultFunc is marked non-null but is null");
        }
        this.doBreak = false;
        long deadline = System.nanoTime() + this.timeout * 1000000L;
        try {
            Throwable cause;
            int retryCount = -1;
            if (this.retryFunc != null) {
                if (this.retryOnStart) {
                    this.retryFunc.accept(this);
                }
                if (this.retryMillis > -1L) {
                    retryCount = this.interval > 0L ? (int)Math.floor((double)this.retryMillis / (double)this.interval) : 0;
                }
            }
            boolean doRetry = retryCount > -1;
            FluentWait result = null;
            do {
                try {
                    result = resultFunc.invoke(this);
                    if (result != null) {
                        FluentWait fluentWait = result;
                        return (T)fluentWait;
                    }
                    cause = null;
                }
                catch (Throwable e) {
                    cause = this.propagateIfNotIgnored(e);
                }
                finally {
                    ++this.evaluatedCount;
                }
                if (doRetry && (retryCount == 0 || this.evaluatedCount % retryCount == 0)) {
                    this.retryFunc.accept(this);
                }
                if (this.doBreak) {
                    FluentWait e = result;
                    return (T)e;
                }
                Extends.sleep(this.interval);
            } while (System.nanoTime() < deadline);
            String timeoutMessage = String.format("Expected condition failed: %s (tried for %d millisecond(s) with %d milliseconds interval)", this.message == null ? "waiting for " + resultFunc : this.message, this.timeout, this.interval);
            throw WaitHandle.newTimeoutException(timeoutMessage, cause);
        }
        finally {
            this.evaluatedCount = 0;
        }
    }

    @Override
    public boolean await(long timeoutMillis) {
        try {
            FluentWait.polling(timeoutMillis, this.interval, this.resultFunc).await();
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public void signalAll() {
        this.doBreak = true;
    }

    private FluentWait(long timeout, long interval) {
        this.timeout = timeout;
        this.interval = interval;
    }

    public int getEvaluatedCount() {
        return this.evaluatedCount;
    }
}

