/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.rx.core.Linq;
import org.rx.core.Sys;
import org.rx.core.ThreadPool;
import org.rx.exception.InvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkJoinPoolWrapper
extends ForkJoinPool {
    private static final Logger log = LoggerFactory.getLogger(ForkJoinPoolWrapper.class);
    public static final Function<Object, Object> ADVICE_FN = task -> {
        if (task instanceof ForkJoinTask) {
            return ForkJoinPoolWrapper.wrap((ForkJoinTask)task);
        }
        if (task instanceof Runnable) {
            return ForkJoinPoolWrapper.wrap((Runnable)task);
        }
        if (task instanceof Callable) {
            return ForkJoinPoolWrapper.wrap((Callable)task);
        }
        throw new InvalidException("Error task type {}", task);
    };
    final ForkJoinPool delegate = ForkJoinPool.commonPool();

    public static synchronized void transform() {
        int flag = 2;
        if ((Sys.transformedFlags & 2) == 2) {
            return;
        }
        Sys.transformedFlags = (byte)(Sys.transformedFlags | 2);
        Sys.checkAdviceShare(true);
        ByteBuddyAgent.install();
        new ByteBuddy().redefine(ForkJoinPool.class).visit((AsmVisitorWrapper)Advice.to(TaskAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"externalPush"))).make().load(ClassLoader.getSystemClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
    }

    static Runnable wrap(Runnable task) {
        String traceId = ThreadPool.CTX_TRACE_ID.get();
        return () -> {
            ThreadPool.startTrace(traceId);
            try {
                task.run();
            }
            finally {
                ThreadPool.endTrace();
            }
        };
    }

    static <T> Callable<T> wrap(Callable<T> task) {
        String traceId = ThreadPool.CTX_TRACE_ID.get();
        return () -> {
            ThreadPool.startTrace(traceId);
            try {
                Object v = task.call();
                return v;
            }
            finally {
                ThreadPool.endTrace();
            }
        };
    }

    static <T> ForkJoinTask<T> wrap(ForkJoinTask<T> task) {
        String traceId = ThreadPool.CTX_TRACE_ID.get();
        return ForkJoinTask.adapt(() -> {
            ThreadPool.startTrace(traceId);
            try {
                Object v = task.invoke();
                return v;
            }
            finally {
                ThreadPool.endTrace();
            }
        });
    }

    ForkJoinPoolWrapper() {
    }

    @Override
    public <T> T invoke(ForkJoinTask<T> task) {
        return this.delegate.invoke(ForkJoinPoolWrapper.wrap(task));
    }

    @Override
    public void execute(ForkJoinTask<?> task) {
        this.delegate.execute(ForkJoinPoolWrapper.wrap(task));
    }

    @Override
    public void execute(Runnable task) {
        this.delegate.execute(ForkJoinPoolWrapper.wrap(task));
    }

    @Override
    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        return this.delegate.submit(ForkJoinPoolWrapper.wrap(task));
    }

    @Override
    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        return this.delegate.submit((Callable)ForkJoinPoolWrapper.wrap(task));
    }

    @Override
    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        return this.delegate.submit(ForkJoinPoolWrapper.wrap(task), (Object)result);
    }

    @Override
    public ForkJoinTask<?> submit(Runnable task) {
        return this.delegate.submit(ForkJoinPoolWrapper.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        return this.delegate.invokeAll(Linq.from(tasks).select(p -> ForkJoinPoolWrapper.wrap(p)).toList());
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(Linq.from(tasks).select(p -> ForkJoinPoolWrapper.wrap(p)).toList());
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(Linq.from(tasks).select(p -> ForkJoinPoolWrapper.wrap(p)).toList(), timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(Linq.from(tasks).select(p -> ForkJoinPoolWrapper.wrap(p)).toList(), timeout, unit);
    }

    @Override
    public ForkJoinPool.ForkJoinWorkerThreadFactory getFactory() {
        return this.delegate.getFactory();
    }

    @Override
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.delegate.getUncaughtExceptionHandler();
    }

    @Override
    public int getParallelism() {
        return this.delegate.getParallelism();
    }

    @Override
    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    @Override
    public boolean getAsyncMode() {
        return this.delegate.getAsyncMode();
    }

    @Override
    public int getRunningThreadCount() {
        return this.delegate.getRunningThreadCount();
    }

    @Override
    public int getActiveThreadCount() {
        return this.delegate.getActiveThreadCount();
    }

    @Override
    public boolean isQuiescent() {
        return this.delegate.isQuiescent();
    }

    @Override
    public long getStealCount() {
        return this.delegate.getStealCount();
    }

    @Override
    public long getQueuedTaskCount() {
        return this.delegate.getQueuedTaskCount();
    }

    @Override
    public int getQueuedSubmissionCount() {
        return this.delegate.getQueuedSubmissionCount();
    }

    @Override
    public boolean hasQueuedSubmissions() {
        return this.delegate.hasQueuedSubmissions();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean isTerminating() {
        return this.delegate.isTerminating();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public boolean awaitQuiescence(long timeout, TimeUnit unit) {
        return this.delegate.awaitQuiescence(timeout, unit);
    }

    static class TaskAdvice {
        TaskAdvice() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodEnter
        public static void enter(@Advice.AllArguments(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object[] arguments) throws Throwable {
            Function fn;
            String sk = "";
            int sl = 2;
            boolean idx = true;
            Properties props = System.getProperties();
            Object v = props.get("");
            Object[] share = null;
            if (!(v instanceof Object[]) || (share = (Object[])v).length != 2 || (fn = (Function)share[1]) == null) {
                System.err.println("TaskAdvice empty fn");
                Properties properties = props;
                synchronized (properties) {
                    v = props.get("");
                    if (!(v instanceof Object[]) || (share = (Object[])v).length != 2 || (fn = (Function)share[1]) == null) {
                        try {
                            boolean changed;
                            String t = "org.rx.core.ForkJoinPoolWrapper";
                            String f = "ADVICE_FN";
                            fn = (Function)ClassLoader.getSystemClassLoader().loadClass("org.rx.core.ForkJoinPoolWrapper").getDeclaredField("ADVICE_FN").get(null);
                            boolean bl = changed = share == null;
                            if (changed) {
                                share = new Object[2];
                            }
                            share[1] = fn;
                            if (changed) {
                                props.put("", share);
                            }
                            System.out.println("TaskAdvice get fn");
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                }
            }
            Object task = arguments[0];
            Object[] newArgs = new Object[]{fn.apply(task)};
            arguments = newArgs;
        }
    }
}

