/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.apache.commons.lang3.ClassUtils;
import org.rx.bean.WeakIdentityMap;
import org.rx.exception.InvalidException;

public final class IOC {
    static final Map<Class<?>, Object> container = new ConcurrentHashMap(8);
    static final Map WEAK_MAP = Collections.synchronizedMap(new WeakHashMap());
    static final Map WEAK_IDENTITY_MAP = new WeakIdentityMap();

    public static <T> boolean isInit(Class<T> type) {
        return container.containsKey(type);
    }

    public static <T> T get(Class<T> type, Class<? extends T> defType) {
        T bean = IOC.innerGet(type);
        if (bean == null) {
            return IOC.get(defType);
        }
        return bean;
    }

    public static <T> T get(Class<T> type) {
        T bean = IOC.innerGet(type);
        if (bean == null) {
            throw new InvalidException("Bean {} not registered", type.getName());
        }
        return bean;
    }

    static synchronized <T> T innerGet(Class<T> type) {
        Object bean = container.get(type);
        if (bean == null) {
            Class.forName(type.getName());
            bean = container.get(type);
        }
        return (T)bean;
    }

    public static <T> void register(@NonNull Class<T> type, @NonNull T bean) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        List types = ClassUtils.getAllSuperclasses(type);
        types.remove(Object.class);
        for (Class t : types) {
            container.putIfAbsent(t, bean);
        }
        container.put(type, bean);
    }

    public static <T> void unregister(Class<T> type) {
        container.remove(type);
    }

    public static <K, V> Map<K, V> weakMap(boolean identity) {
        return identity ? WEAK_IDENTITY_MAP : WEAK_MAP;
    }

    static <K, V> Map<K, V> weakMap(Object ref, boolean identity) {
        return (Map)(identity ? WEAK_IDENTITY_MAP : WEAK_MAP).computeIfAbsent(ref, k -> new ConcurrentHashMap(4));
    }
}

