/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import io.netty.util.internal.ThreadLocalRandom;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.rx.annotation.ErrorCode;
import org.rx.bean.$;
import org.rx.bean.Decimal;
import org.rx.core.Arrays;
import org.rx.core.Extends;
import org.rx.core.Reflects;
import org.rx.exception.ApplicationException;
import org.rx.util.function.BiFunc;
import org.rx.util.function.BiFuncWithIndex;
import org.rx.util.function.Func;
import org.rx.util.function.PredicateFunc;
import org.rx.util.function.PredicateFuncWithIndex;
import org.rx.util.function.TripleFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Linq<T>
implements Iterable<T>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(Linq.class);
    private static final long serialVersionUID = -7167070585936243198L;
    static final Linq EMPTY = new Linq(Collections.emptyList(), false);
    private final Iterable<T> data;
    private final boolean parallel;

    public static boolean tryAsIterableType(Class<?> type) {
        return Iterable.class.isAssignableFrom(type) || type.isArray() || Iterator.class.isAssignableFrom(type);
    }

    @ErrorCode
    public static <T> Iterable<T> asIterable(@NonNull Object collection, boolean throwOnFail) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (collection instanceof Iterable) {
            return (Iterable)collection;
        }
        Class<?> type = collection.getClass();
        if (type.isArray()) {
            int length = Array.getLength(collection);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(collection, i));
            }
            return list;
        }
        if (collection instanceof Iterator) {
            return IteratorUtils.asIterable((Iterator)((Iterator)collection));
        }
        if (throwOnFail) {
            throw new ApplicationException(Extends.values(type.getSimpleName()));
        }
        return null;
    }

    public static <T> Linq<T> fromIterable(Object iterable) {
        return Linq.from(Linq.asIterable(iterable, true));
    }

    public static <T> Linq<T> from(T one) {
        if (one == null) {
            return EMPTY;
        }
        return Linq.from(Arrays.toList(one));
    }

    @SafeVarargs
    public static <T> Linq<T> from(T ... array) {
        return Linq.from(Arrays.toList(array));
    }

    public static <T> Linq<T> from(Stream<T> stream) {
        if (stream == null) {
            return EMPTY;
        }
        return Linq.from(stream::iterator, stream.isParallel());
    }

    public static <T> Linq<T> from(Iterable<T> iterable) {
        return Linq.from(iterable, false);
    }

    public static <T> Linq<T> from(Iterable<T> iterable, boolean isParallel) {
        return iterable == null ? EMPTY : new Linq<T>(iterable, isParallel);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.data.spliterator(), this.parallel);
    }

    private <TR> List<TR> newList() {
        Collection<T> ts = this.asCollection();
        int count = ts != null ? ts.size() : 0;
        return this.parallel ? Extends.newConcurrentList(count, false) : new ArrayList(count);
    }

    private <TR> Set<TR> newSet() {
        Collection<T> ts = this.asCollection();
        int count = ts != null ? ts.size() : 16;
        return this.parallel ? Collections.synchronizedSet(new LinkedHashSet(count)) : new LinkedHashSet(count);
    }

    private <TK, TR> Map<TK, TR> newMap() {
        Collection<T> ts = this.asCollection();
        int count = ts != null ? ts.size() : 16;
        return this.parallel ? Collections.synchronizedMap(new LinkedHashMap(count)) : new LinkedHashMap(count);
    }

    private Collection<T> asCollection() {
        return this.data instanceof Collection ? (Collection)this.data : null;
    }

    private <TR> Stream<TR> newStream(Iterable<TR> iterable) {
        return StreamSupport.stream(iterable.spliterator(), this.parallel);
    }

    private <TR> Linq<TR> me(Iterable<TR> set) {
        return Linq.from(set, this.parallel);
    }

    private <TR> Linq<TR> me(Stream<TR> stream) {
        return this.me(stream.collect(Collectors.toList()));
    }

    private Linq<T> me(final EachFunc<T> func, String prevMethod) {
        if (this.parallel) {
            log.warn("Not support parallel {}", (Object)prevMethod);
        }
        final Spliterator<T> spliterator = this.data.spliterator();
        Stream r = StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(spliterator.estimateSize(), spliterator.characteristics()){
            final AtomicBoolean breaker;
            final AtomicInteger counter;
            {
                super(est, additionalCharacteristics);
                this.breaker = new AtomicBoolean();
                this.counter = new AtomicInteger();
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                return spliterator.tryAdvance(p -> {
                    int flags = func.each(p, this.counter.getAndIncrement());
                    if ((flags & 1) == 1) {
                        action.accept(p);
                    }
                    if ((flags & 2) == 2) {
                        this.breaker.set(true);
                    }
                }) && !this.breaker.get();
            }
        }, this.parallel);
        return this.me(r);
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.stream().forEach(action);
    }

    public void forEachOrdered(Consumer<? super T> action) {
        this.stream().forEachOrdered(action);
    }

    public <TR> Linq<TR> select(BiFunc<T, TR> selector) {
        return this.me(this.stream().map(selector));
    }

    public <TR> Linq<TR> select(BiFuncWithIndex<T, TR> selector) {
        AtomicInteger counter = new AtomicInteger();
        return this.me(this.stream().map(p -> selector.apply(p, counter.getAndIncrement())));
    }

    public <TR> Linq<TR> selectMany(BiFunc<T, Iterable<TR>> selector) {
        return this.me(this.stream().flatMap(p -> this.newStream((Iterable)selector.apply(p))));
    }

    public <TR> Linq<TR> selectMany(BiFuncWithIndex<T, Iterable<TR>> selector) {
        AtomicInteger counter = new AtomicInteger();
        return this.me(this.stream().flatMap(p -> this.newStream((Iterable)selector.apply(p, counter.getAndIncrement()))));
    }

    public Linq<T> where(PredicateFunc<T> predicate) {
        return this.me(this.stream().filter(predicate));
    }

    public Linq<T> where(PredicateFuncWithIndex<T> predicate) {
        AtomicInteger counter = new AtomicInteger();
        return this.me(this.stream().filter(p -> predicate.test(p, counter.getAndIncrement())));
    }

    public <TI, TR> Linq<TR> join(Iterable<TI> inner, BiPredicate<T, TI> keySelector, TripleFunc<T, TI, TR> resultSelector) {
        return this.me(this.stream().flatMap(p -> this.newStream(inner).filter(p2 -> keySelector.test(p, p2)).map(p3 -> resultSelector.apply((Object)p, (Object)p3))));
    }

    public <TI, TR> Linq<TR> join(BiFunc<T, TI> innerSelector, BiPredicate<T, TI> keySelector, TripleFunc<T, TI, TR> resultSelector) {
        return this.join(this.stream().map(innerSelector).collect(Collectors.toList()), keySelector, resultSelector);
    }

    public <TI, TR> Linq<TR> joinMany(BiFunc<T, Iterable<TI>> innerSelector, BiPredicate<T, TI> keySelector, TripleFunc<T, TI, TR> resultSelector) {
        return this.join(this.stream().flatMap(p -> this.newStream((Iterable)innerSelector.apply(p))).collect(Collectors.toList()), keySelector, resultSelector);
    }

    public <TI, TR> Linq<TR> leftJoin(Iterable<TI> inner, BiPredicate<T, TI> keySelector, TripleFunc<T, TI, TR> resultSelector) {
        return this.me(this.stream().flatMap(p -> {
            if (!this.newStream(inner).anyMatch(p2 -> keySelector.test(p, p2))) {
                return Stream.of(resultSelector.apply((T)p, (Object)null));
            }
            return this.newStream(inner).filter(p2 -> keySelector.test(p, p2)).map(p3 -> resultSelector.apply((Object)p, (Object)p3));
        }));
    }

    public <TI, TR> Linq<TR> leftJoin(BiFunc<T, TI> innerSelector, BiPredicate<T, TI> keySelector, TripleFunc<T, TI, TR> resultSelector) {
        return this.leftJoin(this.stream().map(innerSelector).collect(Collectors.toList()), keySelector, resultSelector);
    }

    public <TI, TR> Linq<TR> leftJoinMany(BiFunc<T, Iterable<TI>> innerSelector, BiPredicate<T, TI> keySelector, TripleFunc<T, TI, TR> resultSelector) {
        return this.leftJoin(this.stream().flatMap(p -> this.newStream((Iterable)innerSelector.apply(p))).collect(Collectors.toList()), keySelector, resultSelector);
    }

    public boolean all(PredicateFunc<T> predicate) {
        return this.stream().allMatch(predicate);
    }

    public boolean any() {
        return this.stream().findAny().isPresent();
    }

    public boolean any(PredicateFunc<T> predicate) {
        return this.stream().anyMatch(predicate);
    }

    public boolean contains(T item) {
        return this.stream().anyMatch(p -> p.equals(item));
    }

    public Linq<T> concat(Iterable<T> set) {
        return this.me(Stream.concat(this.stream(), this.newStream(set)));
    }

    public Linq<T> distinct() {
        return this.me(this.stream().distinct());
    }

    public Linq<T> except(Iterable<T> set) {
        return this.me(this.stream().filter(p -> !this.newStream(set).anyMatch(p2 -> p2.equals(p))));
    }

    public Linq<T> intersection(Iterable<T> set) {
        return this.me(this.stream().filter(p -> this.newStream(set).anyMatch(p2 -> p2.equals(p))));
    }

    public Linq<T> difference(Iterable<T> set) {
        return Linq.from(CollectionUtils.disjunction((Iterable)this, set));
    }

    public Linq<T> union(Iterable<T> set) {
        return Linq.from(CollectionUtils.union((Iterable)this, set));
    }

    public Linq<T> orderByRand() {
        return this.me(this.stream().sorted(Linq.getComparator(p -> ThreadLocalRandom.current().nextInt(0, 100), false)));
    }

    public <TK> Linq<T> orderBy(BiFunc<T, TK> keySelector) {
        return this.me(this.stream().sorted(Linq.getComparator(keySelector, false)));
    }

    public static <T, TK> Comparator<T> getComparator(BiFunc<T, TK> keySelector, boolean descending) {
        return (p1, p2) -> {
            Comparable a = Extends.as(keySelector.apply(p1), Comparable.class);
            Comparable b = Extends.as(keySelector.apply(p2), Comparable.class);
            boolean nullFirst = false;
            if (a == null) {
                return b == null ? 0 : (nullFirst ? -1 : 1);
            }
            if (b == null) {
                return nullFirst ? 1 : -1;
            }
            return descending ? b.compareTo(a) : a.compareTo(b);
        };
    }

    public <TK> Linq<T> orderByDescending(BiFunc<T, TK> keySelector) {
        return this.me(this.stream().sorted(Linq.getComparator(keySelector, true)));
    }

    public Linq<T> orderByMany(BiFunc<T, List<Object>> keySelector) {
        return this.me(this.stream().sorted(Linq.getComparatorMany(keySelector, false)));
    }

    public static <T> Comparator<T> getComparatorMany(BiFunc<T, List<Object>> keySelector, boolean descending) {
        return (p1, p2) -> {
            List k1s = (List)keySelector.apply(p1);
            List k2s = (List)keySelector.apply(p2);
            for (int i = 0; i < k1s.size(); ++i) {
                int r;
                Comparable a = Extends.as(k1s.get(i), Comparable.class);
                Comparable b = Extends.as(k2s.get(i), Comparable.class);
                boolean nullFirst = false;
                if (a == null) {
                    return b == null ? 0 : (nullFirst ? -1 : 1);
                }
                if (b == null) {
                    return nullFirst ? 1 : -1;
                }
                int n = r = descending ? b.compareTo(a) : a.compareTo(b);
                if (r == 0) continue;
                return r;
            }
            return 0;
        };
    }

    public Linq<T> orderByDescendingMany(BiFunc<T, List<Object>> keySelector) {
        return this.me(this.stream().sorted(Linq.getComparatorMany(keySelector, true)));
    }

    public Linq<T> reverse() {
        try {
            return this.me(this.stream().sorted(Comparator.reverseOrder()));
        }
        catch (Exception e) {
            log.warn("Try reverse fail, {}", (Object)e.getMessage());
            List<T> list = this.toList();
            Collections.reverse(list);
            return this.me(list);
        }
    }

    public <TK, TR> Linq<TR> groupBy(BiFunc<T, TK> keySelector, TripleFunc<TK, Linq<T>, TR> resultSelector) {
        Map map = this.stream().collect(Collectors.groupingBy(keySelector, this::newMap, Collectors.toList()));
        List<TR> result = this.newList();
        for (Map.Entry entry : map.entrySet()) {
            result.add(resultSelector.apply(entry.getKey(), Linq.from((Iterable)entry.getValue())));
        }
        return this.me(result);
    }

    public <TK, TR> Map<TK, TR> groupByIntoMap(BiFunc<T, TK> keySelector, TripleFunc<TK, Linq<T>, TR> resultSelector) {
        Map map = this.stream().collect(Collectors.groupingBy(keySelector, this::newMap, Collectors.toList()));
        Map<TK, TR> result = this.newMap();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), resultSelector.apply(entry.getKey(), Linq.from((Iterable)entry.getValue())));
        }
        return result;
    }

    public <TR> Linq<TR> groupByMany(BiFunc<T, List<Object>> keySelector, TripleFunc<List<Object>, Linq<T>, TR> resultSelector) {
        Map map = this.stream().collect(Collectors.groupingBy(keySelector, this::newMap, Collectors.toList()));
        List<TR> result = this.newList();
        for (Map.Entry entry : map.entrySet()) {
            result.add(resultSelector.apply((List)entry.getKey(), Linq.from((Iterable)entry.getValue())));
        }
        return this.me(result);
    }

    public Double average(ToDoubleFunction<T> selector) {
        OptionalDouble q = this.stream().mapToDouble(selector).average();
        return q.isPresent() ? Double.valueOf(q.getAsDouble()) : null;
    }

    public int count() {
        Collection<T> ts = this.asCollection();
        return ts != null ? ts.size() : (int)this.stream().count();
    }

    public int count(PredicateFunc<T> predicate) {
        return (int)this.stream().filter(predicate).count();
    }

    public T max() {
        return this.max(this.stream());
    }

    private <TR> TR max(Stream<TR> stream) {
        return stream.max(Comparator.naturalOrder()).orElse(null);
    }

    public <TR> TR max(BiFunc<T, TR> selector) {
        return this.max(this.stream().map(selector));
    }

    public T min() {
        return this.min(this.stream());
    }

    private <TR> TR min(Stream<TR> stream) {
        return stream.min(Comparator.naturalOrder()).orElse(null);
    }

    public <TR> TR min(BiFunc<T, TR> selector) {
        return this.min(this.stream().map(selector));
    }

    public double sum(ToDoubleFunction<T> selector) {
        return this.stream().mapToDouble(selector).sum();
    }

    public Decimal sumDecimal(BiFunc<T, Decimal> selector) {
        $<Decimal> sumValue = $.$(Decimal.ZERO);
        this.stream().forEach(p -> {
            sumValue.v = ((Decimal)sumValue.v).add((Decimal)selector.apply(p));
        });
        return (Decimal)sumValue.v;
    }

    public <TR> Linq<TR> cast() {
        return this;
    }

    public <TR> Linq<TR> ofType(Class<TR> type) {
        return this.where((T p) -> p != null && Reflects.isInstance(p, type)).select((T p) -> p);
    }

    public T first() {
        return this.stream().findFirst().get();
    }

    public T first(PredicateFunc<T> predicate) {
        return this.stream().filter(predicate).findFirst().get();
    }

    public T firstOrDefault() {
        return this.firstOrDefault((T)null);
    }

    public T firstOrDefault(T defaultValue) {
        return this.stream().findFirst().orElse(defaultValue);
    }

    public T firstOrDefault(Func<T> defaultValue) {
        return this.stream().findFirst().orElseGet(defaultValue);
    }

    public T firstOrDefault(PredicateFunc<T> predicate) {
        return this.stream().filter(predicate).findFirst().orElse(null);
    }

    public T last() {
        T value = this.lastOrDefault();
        if (value == null) {
            throw new NoSuchElementException("No value present");
        }
        return value;
    }

    public T last(PredicateFunc<T> predicate) {
        return this.where(predicate).last();
    }

    public T lastOrDefault() {
        T value = null;
        if (this.data instanceof List) {
            List list = (List)this.data;
            value = !list.isEmpty() ? (T)list.get(list.size() - 1) : null;
        } else {
            for (T datum : this.data) {
                value = datum;
            }
        }
        return value;
    }

    public T lastOrDefault(T defaultValue) {
        return Extends.ifNull(this.lastOrDefault(), defaultValue);
    }

    public T lastOrDefault(PredicateFunc<T> predicate) {
        return this.where(predicate).lastOrDefault();
    }

    public T single() {
        return this.single(null);
    }

    @ErrorCode
    public T single(PredicateFunc<T> predicate) {
        List list;
        Stream<T> stream = this.stream();
        if (predicate != null) {
            stream = stream.filter(predicate);
        }
        if ((list = stream.limit(2L).collect(Collectors.toList())).size() != 1) {
            throw new ApplicationException(Extends.values(list.size()));
        }
        return list.get(0);
    }

    public T singleOrDefault() {
        return this.singleOrDefault(null);
    }

    @ErrorCode
    public T singleOrDefault(PredicateFunc<T> predicate) {
        List list;
        Stream<T> stream = this.stream();
        if (predicate != null) {
            stream = stream.filter(predicate);
        }
        if ((list = stream.limit(2L).collect(Collectors.toList())).size() > 1) {
            throw new ApplicationException(Extends.values(list.size()));
        }
        return list.isEmpty() ? null : (T)list.get(0);
    }

    public Linq<T> skip(int count) {
        return this.me(this.stream().skip(count));
    }

    public Linq<T> skipWhile(PredicateFunc<T> predicate) {
        return this.skipWhile((T p, int i) -> predicate.invoke(p));
    }

    public Linq<T> skipWhile(PredicateFuncWithIndex<T> predicate) {
        AtomicBoolean doAccept = new AtomicBoolean();
        return this.me((p, i) -> {
            int flags = 0;
            if (doAccept.get()) {
                return flags |= 1;
            }
            if (!predicate.test(p, i)) {
                doAccept.set(true);
                flags |= 1;
            }
            return flags;
        }, "skipWhile");
    }

    public Linq<T> take(int count) {
        return this.me(this.stream().limit(count));
    }

    public Linq<T> takeWhile(PredicateFunc<T> predicate) {
        return this.takeWhile((T p, int i) -> predicate.invoke(p));
    }

    public Linq<T> takeWhile(PredicateFuncWithIndex<T> predicate) {
        return this.me((p, i) -> {
            int flags = 0;
            if (!predicate.test(p, i)) {
                return flags |= 2;
            }
            return flags |= 1;
        }, "takeWhile");
    }

    public String toJoinString(String delimiter) {
        return String.join((CharSequence)delimiter, this.cast());
    }

    public String toJoinString(String delimiter, BiFunc<T, String> selector) {
        return String.join((CharSequence)delimiter, this.select(selector));
    }

    public T[] toArray() {
        List<Object> result = this.toList();
        Class type = null;
        for (T t : result) {
            if (t == null) continue;
            type = t.getClass();
            break;
        }
        if (type == null) {
            type = Object.class;
        }
        Object[] array = (Object[])Array.newInstance(type, result.size());
        result.toArray(array);
        return array;
    }

    public T[] toArray(Class<T> type) {
        List<Object> result = this.toList();
        Object[] array = (Object[])Array.newInstance(type, result.size());
        result.toArray(array);
        return array;
    }

    public List<T> toList() {
        if (!this.parallel && this.data instanceof List) {
            return (List)this.data;
        }
        List result = this.newList();
        for (T item : this.data) {
            result.add(item);
        }
        return result;
    }

    public Set<T> toSet() {
        if (!this.parallel && this.data instanceof Set) {
            return (Set)this.data;
        }
        Set result = this.newSet();
        for (T item : this.data) {
            result.add(item);
        }
        return result;
    }

    public <TK, TR> Map<TK, TR> toMap() {
        Map<TK, TR> result = this.newMap();
        for (Map.Entry entry : this.cast()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public <TK> Map<TK, T> toMap(BiFunc<T, TK> keySelector) {
        return this.toMap(keySelector, p -> p);
    }

    public <TK, TR> Map<TK, TR> toMap(BiFunc<T, TK> keySelector, BiFunc<T, TR> resultSelector) {
        Map result = this.newMap();
        this.stream().forEach(item -> result.put(keySelector.apply(item), resultSelector.apply(item)));
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Linq linq = (Linq)o;
        return this.parallel == linq.parallel && Objects.equals(this.data, linq.data);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.parallel);
    }

    private Linq(Iterable<T> data, boolean parallel) {
        this.data = data;
        this.parallel = parallel;
    }

    @FunctionalInterface
    static interface EachFunc<T> {
        public static final int NONE = 0;
        public static final int ACCEPT = 1;
        public static final int BREAK = 2;

        public int each(T var1, int var2);
    }
}

