/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.io.Serializable;
import java.net.InetAddress;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Properties;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.StubMethod;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.rx.bean.FlagsEnum;
import org.rx.core.Extends;
import org.rx.core.Reflects;
import org.rx.core.RxConfig;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.core.TimeoutFlag;
import org.rx.io.Files;
import org.rx.third.apache.ntp.NTPUDPClient;
import org.rx.third.apache.ntp.TimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtpClock
extends Clock
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(NtpClock.class);
    private static final long serialVersionUID = -242102888494125L;
    public static final NtpClock UTC = new NtpClock(ZoneOffset.UTC);
    static long offset;
    static boolean injected;
    final ZoneId zone;

    public static synchronized void transform() {
        boolean flag = true;
        if ((Sys.transformedFlags & 1) == 1) {
            return;
        }
        Sys.transformedFlags = (byte)(Sys.transformedFlags | 1);
        Sys.checkAdviceShare(true);
        String djar = "rxdaemon-1.0.jar";
        Files.saveFile(djar, Reflects.getResource(djar));
        new AgentBuilder.Default().enableNativeMethodPrefix("wmsnative").with(new ByteBuddy().with((Implementation.Context.Factory)Implementation.Context.Disabled.Factory.INSTANCE)).with((AgentBuilder.InitializationStrategy)AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(AgentBuilder.RedefinitionStrategy.REDEFINITION).with((AgentBuilder.TypeStrategy)AgentBuilder.TypeStrategy.Default.REDEFINE).ignore((ElementMatcher)ElementMatchers.none()).type((ElementMatcher)ElementMatchers.named((String)"java.lang.System")).transform((builder, typeDescription, classLoader, javaModule, protectionDomain) -> builder.method((ElementMatcher)ElementMatchers.named((String)"currentTimeMillis")).intercept(Advice.to(TimeAdvice.class).wrap((Implementation)StubMethod.INSTANCE))).installOn(ByteBuddyAgent.install());
    }

    public static void scheduleTask() {
        Tasks.timer.setTimeout(NtpClock::sync, d -> RxConfig.INSTANCE.net.ntp.syncPeriod, NtpClock.class, (FlagsEnum<TimeoutFlag>)TimeoutFlag.SINGLE.flags(new TimeoutFlag[]{TimeoutFlag.PERIOD}));
    }

    public static void sync() {
        NTPUDPClient client = new NTPUDPClient();
        RxConfig.NtpConfig conf = RxConfig.INSTANCE.net.ntp;
        client.setDefaultTimeout((int)conf.timeoutMillis);
        client.open();
        Extends.eachQuietly(conf.servers, p -> {
            TimeInfo info = client.getTime(InetAddress.getByName(p));
            info.computeDetails();
            offset = Extends.ifNull(info.getOffset(), 0L);
            log.debug("ntp sync with {} -> {}", p, (Object)offset);
            long[] tsAgent = Sys.getAdviceShareTime();
            injected = tsAgent != null;
            if (injected) {
                tsAgent[1] = tsAgent[1] + offset;
                log.debug("ntp inject offset {}", (Object)offset);
            }
            Extends.circuitContinue(false);
        });
        client.close();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        if (zone.equals(this.zone)) {
            return this;
        }
        return new NtpClock(zone);
    }

    @Override
    public long millis() {
        long b = System.currentTimeMillis();
        return injected ? b : b + offset;
    }

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(this.millis());
    }

    private NtpClock(ZoneId zone) {
        this.zone = zone;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NtpClock)) {
            return false;
        }
        NtpClock other = (NtpClock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ZoneId this$zone = this.getZone();
        ZoneId other$zone = other.getZone();
        return !(this$zone == null ? other$zone != null : !((Object)this$zone).equals(other$zone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NtpClock;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZoneId $zone = this.getZone();
        result = result * 59 + ($zone == null ? 43 : ((Object)$zone).hashCode());
        return result;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    static class TimeAdvice {
        TimeAdvice() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit
        static void exit(@Advice.Return(readOnly=false) long r) throws Throwable {
            long y;
            long x;
            long[] time;
            String sk = "";
            int sl = 2;
            boolean idx = false;
            Properties props = System.getProperties();
            Object v = props.get("");
            Object[] share = null;
            if (!(v instanceof Object[]) || (share = (Object[])v).length != 2 || (time = (long[])share[0]) == null) {
                System.err.println("TimeAdvice empty time");
                Properties properties = props;
                synchronized (properties) {
                    v = props.get("");
                    if (!(v instanceof Object[]) || (share = (Object[])v).length != 2 || (time = (long[])share[0]) == null) {
                        time = new long[2];
                        try {
                            boolean changed;
                            Process proc = Runtime.getRuntime().exec("java -cp rxdaemon-1.0.jar org.rx.daemon.Application");
                            byte[] buf = new byte[128];
                            int len = proc.getInputStream().read(buf);
                            String[] pair = new String(buf, 0, len).split(",");
                            time[1] = Long.parseLong(pair[0]);
                            time[0] = Long.parseLong(pair[1]);
                            boolean bl = changed = share == null;
                            if (changed) {
                                share = new Object[2];
                            }
                            share[0] = time;
                            if (changed) {
                                props.put("", share);
                            }
                            System.out.println("TimeAdvice new timestamp: " + pair[0]);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if ((x = System.nanoTime() - time[0]) <= (y = 1000000L)) {
                r = time[1];
                return;
            }
            r = x / y + time[1];
        }
    }
}

