/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.NonNull;
import org.rx.annotation.Metadata;
import org.rx.bean.WeakIdentityMap;
import org.rx.core.Constants;
import org.rx.core.EventBus;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.ObjectChangedEvent;
import org.rx.core.Reflects;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.exception.InvalidException;
import org.rx.exception.TraceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.Enhancer;

public class ObjectChangeTracker {
    private static final Logger log = LoggerFactory.getLogger(ObjectChangeTracker.class);
    public static final ObjectChangeTracker DEFAULT = new ObjectChangeTracker();
    final Map<Object, Map<String, Object>> sources = new WeakIdentityMap<Object, Map<String, Object>>();
    final EventBus bus = EventBus.DEFAULT;

    public static TreeMap<String, ChangedValue> compareSnapshotMap(@NonNull Map<String, Object> oldValueMap, @NonNull Map<String, Object> newValueMap) {
        if (oldValueMap == null) {
            throw new NullPointerException("oldValueMap is marked non-null but is null");
        }
        if (newValueMap == null) {
            throw new NullPointerException("newValueMap is marked non-null but is null");
        }
        TreeMap<String, ChangedValue> root = new TreeMap<String, ChangedValue>();
        HashSet<String> allKeys = new HashSet<String>(oldValueMap.keySet());
        allKeys.addAll(newValueMap.keySet());
        for (String name : allKeys) {
            Object oldVal = oldValueMap.get(name);
            Object newVal = newValueMap.get(name);
            ObjectChangeTracker.compareObj(root, null, name, oldVal, newVal);
        }
        return root;
    }

    static void compareObj(Map<String, ChangedValue> root, String parentName, String name, Object oldObj, Object newObj) {
        String n = ObjectChangeTracker.concatName(parentName, true, name);
        if (oldObj == null || newObj == null) {
            if (oldObj == newObj) {
                return;
            }
            root.put(n, new ChangedValue(oldObj, newObj));
            return;
        }
        Class<?> oldType = oldObj.getClass();
        Class<?> newType = newObj.getClass();
        Class<List> listClass = List.class;
        if (listClass.isAssignableFrom(oldType) && listClass.isAssignableFrom(newType)) {
            List olds = (List)oldObj;
            List news = (List)newObj;
            int oldSize = olds.size();
            int newSize = news.size();
            int allSize = Math.max(oldSize, newSize);
            for (int i = 0; i < allSize; ++i) {
                Object oldVal = i < oldSize ? olds.get(i) : null;
                Object newVal = i < newSize ? news.get(i) : null;
                ObjectChangeTracker.compareObj(root, n, String.format("[%s]", i), oldVal, newVal);
            }
            return;
        }
        Class<Map> mapClass = Map.class;
        if (mapClass.isAssignableFrom(oldType) && mapClass.isAssignableFrom(newType)) {
            Map olds = (Map)oldObj;
            Map news = (Map)newObj;
            HashSet allKeys = new HashSet(olds.keySet());
            allKeys.addAll(news.keySet());
            for (String k : allKeys) {
                Object oldVal = olds.get(k);
                Object newVal = news.get(k);
                ObjectChangeTracker.compareObj(root, n, k, oldVal, newVal);
            }
            return;
        }
        if (!Extends.eq(oldObj, newObj)) {
            root.put(n, new ChangedValue(oldObj, newObj));
        }
    }

    public static <T> Map<String, Object> getSnapshotMap(@NonNull T sourceObj, boolean concatName) {
        if (sourceObj == null) {
            throw new NullPointerException("sourceObj is marked non-null but is null");
        }
        Object target = ObjectChangeTracker.getTarget(sourceObj);
        if (target == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        for (Field field : ObjectChangeTracker.getFieldMap(target.getClass())) {
            ObjectChangeTracker.resolve(root, null, concatName, target, field, 0);
        }
        return root;
    }

    static void resolve(Map<String, Object> parent, String parentName, boolean concatName, Object obj, Field field, int recursionDepth) {
        Object val;
        Metadata m = field.getAnnotation(Metadata.class);
        if (m != null && m.ignore() || (val = field.get(obj)) == null) {
            return;
        }
        String name = ObjectChangeTracker.concatName(parentName, concatName, field.getName());
        Class<?> type = val.getClass();
        if (Linq.tryAsIterableType(type)) {
            parent.put(name, Linq.fromIterable(val).select(p -> ObjectChangeTracker.resolveValue(name, concatName, p, recursionDepth)).toList());
            return;
        }
        if (Map.class.isAssignableFrom(type)) {
            Map x = (Map)val;
            parent.put(name, Linq.from(x.entrySet()).select(p -> new AbstractMap.SimpleEntry<Object, Object>(ObjectChangeTracker.resolveValue(name, concatName, p.getKey(), recursionDepth), ObjectChangeTracker.resolveValue(name, concatName, p.getValue(), recursionDepth))).toMap());
            return;
        }
        parent.put(name, ObjectChangeTracker.resolveValue(name, concatName, val, recursionDepth));
    }

    static Object resolveValue(String name, boolean concatName, Object val, int recursionDepth) {
        if (val == null) {
            return null;
        }
        Class<?> type = val.getClass();
        if (!Reflects.isBasicType(type)) {
            if (++recursionDepth > 128) {
                TraceHandler.INSTANCE.saveMetric(Constants.MetricName.OBJECT_TRACK_OVERFLOW.name(), String.format("%s recursion overflow", type));
                return val;
            }
            log.debug("recursion {} -> {}", type, (Object)recursionDepth);
            HashMap<String, Object> children = new HashMap<String, Object>();
            for (Field childField : ObjectChangeTracker.getFieldMap(type)) {
                ObjectChangeTracker.resolve(children, name, concatName, val, childField, recursionDepth);
            }
            return children;
        }
        return val;
    }

    static String concatName(String parentName, boolean concatName, String name) {
        if (parentName == null || !concatName) {
            return name;
        }
        if (name.startsWith("[")) {
            return parentName + name;
        }
        return String.format("%s.%s", parentName, name);
    }

    static Linq<Field> getFieldMap(Class<?> type) {
        return Linq.from(Reflects.getFieldMap(type).values()).where(p -> !Modifier.isStatic(p.getModifiers()));
    }

    static Object getTarget(Object sourceObj) {
        Class<?> type = sourceObj.getClass();
        if (Proxy.isProxyClass(type) || Enhancer.isEnhanced(type)) {
            return Sys.targetObject(sourceObj);
        }
        return sourceObj;
    }

    public ObjectChangeTracker() {
        this(30000L);
    }

    public ObjectChangeTracker(long publishPeriod) {
        Tasks.schedulePeriod(this::publishAll, publishPeriod);
    }

    public void publishAll() {
        Extends.eachQuietly(this.sources.entrySet(), p -> this.publish(p.getKey(), (Map)p.getValue(), false));
    }

    public <T> ObjectChangeTracker publish(@NonNull T source, boolean forcePublish) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        Object target = ObjectChangeTracker.getTarget(source);
        if (target == null) {
            throw new InvalidException("Proxy object can not be tracked, plz use source object instead", new Object[0]);
        }
        Map<String, Object> oldMap = this.sources.get(target);
        if (oldMap == null) {
            throw new InvalidException("Object {} not watched", target);
        }
        this.publish(target, oldMap, forcePublish);
        return this;
    }

    void publish(Object target, Map<String, Object> oldMap, boolean forcePub) {
        Map<String, Object> newMap = ObjectChangeTracker.getSnapshotMap(target, false);
        TreeMap<String, ChangedValue> changedValues = ObjectChangeTracker.compareSnapshotMap(oldMap, newMap);
        if (changedValues.isEmpty() && !forcePub) {
            return;
        }
        log.info("Tracker {} ->\n\t{}\n\t{}\n-> {}", new Object[]{target, oldMap, newMap, Sys.toJsonString(changedValues)});
        this.sources.put(target, newMap);
        this.bus.publish(new ObjectChangedEvent(target, changedValues), EventBus.getTopic(target));
    }

    public <T> ObjectChangeTracker watch(T source) {
        return this.watch(source, false);
    }

    public <T> ObjectChangeTracker watch(@NonNull T source, boolean emptySnapshotMap) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        Object target = ObjectChangeTracker.getTarget(source);
        if (target == null) {
            throw new InvalidException("Proxy object can not be tracked, plz use source object instead", new Object[0]);
        }
        this.sources.put(target, emptySnapshotMap ? Collections.emptyMap() : ObjectChangeTracker.getSnapshotMap(target, false));
        return this;
    }

    public <T> ObjectChangeTracker unwatch(@NonNull T source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        Object target = ObjectChangeTracker.getTarget(source);
        if (target == null) {
            return this;
        }
        this.sources.remove(target);
        return this;
    }

    public <T> ObjectChangeTracker register(@NonNull T subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("subscriber is marked non-null but is null");
        }
        this.bus.register(subscriber);
        return this;
    }

    public <T> ObjectChangeTracker unregister(@NonNull T subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("subscriber is marked non-null but is null");
        }
        this.bus.unregister(subscriber);
        return this;
    }

    public static class ChangedValue {
        final Object oldValue;
        final Object newValue;

        public <T> T oldValue() {
            return (T)this.oldValue;
        }

        public <T> T newValue() {
            return (T)this.newValue;
        }

        public ChangedValue(Object oldValue, Object newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public String toString() {
            return "ObjectChangeTracker.ChangedValue(oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ")";
        }
    }
}

