/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.util.EventObject;
import java.util.Map;
import org.rx.core.ObjectChangeTracker;
import org.rx.core.Sys;

public class ObjectChangedEvent
extends EventObject {
    private static final long serialVersionUID = -2993269004798534124L;
    final Map<String, ObjectChangeTracker.ChangedValue> changedMap;

    public ObjectChangedEvent(Object source, Map<String, ObjectChangeTracker.ChangedValue> changedMap) {
        super(source);
        this.changedMap = changedMap;
    }

    public <T> T source() {
        return (T)this.getSource();
    }

    public <T> T readValue(String path) {
        return this.readValue(path, false);
    }

    public <T> T readValue(String path, boolean throwOnEmptyChild) {
        return Sys.readJsonValue(this.changedMap, path, p -> {
            if (p instanceof ObjectChangeTracker.ChangedValue) {
                return ((ObjectChangeTracker.ChangedValue)p).newValue();
            }
            return p;
        }, throwOnEmptyChild);
    }

    public Map<String, ObjectChangeTracker.ChangedValue> getChangedMap() {
        return this.changedMap;
    }
}

