/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.NonNull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.rx.annotation.ErrorCode;
import org.rx.bean.DateTime;
import org.rx.bean.Decimal;
import org.rx.bean.NEnum;
import org.rx.bean.Tuple;
import org.rx.bean.ULID;
import org.rx.core.Arrays;
import org.rx.core.Cache;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.StringBuilder;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.core.cache.MemoryCache;
import org.rx.exception.ApplicationException;
import org.rx.exception.InvalidException;
import org.rx.util.Lazy;
import org.rx.util.function.BiFunc;
import org.rx.util.function.TripleFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class Reflects
extends ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(Reflects.class);
    public static final Linq<String> COLLECTION_WRITE_METHOD_NAMES = Linq.from("add", "remove", "addAll", "removeAll", "removeIf", "retainAll", "clear");
    public static final Linq<String> List_WRITE_METHOD_NAMES = COLLECTION_WRITE_METHOD_NAMES.union(Arrays.toList("replaceAll", "set"));
    public static final Set<Method> OBJECT_METHODS = Collections.unmodifiableSet(new HashSet<Method>(Arrays.toList(Object.class.getMethods())));
    static final String M_0 = "close";
    static final String CHANGE_TYPE_METHOD = "valueOf";
    static final String GET_PROPERTY = "get";
    static final String GET_BOOL_PROPERTY = "is";
    static final String SET_PROPERTY = "set";
    static final int LOOKUP_FLAGS = 15;
    static final Lazy<Cache<Class<?>, Map<String, Linq<Method>>>> methodCache = new Lazy<Cache>(MemoryCache::new);
    static final Lazy<Cache<Class<?>, Map<String, Field>>> fieldCache = new Lazy<Cache>(MemoryCache::new);
    static final Constructor<MethodHandles.Lookup> lookupConstructor;
    static final List<ConvertBean<?, ?>> convertBeans;

    public static String getStackTrace(Thread t) {
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement traceElement : t.getStackTrace()) {
            buf.append("\tat ").appendLine(traceElement);
        }
        return buf.toString();
    }

    public static Linq<StackTraceElement> stackTrace(int takeCount) {
        return Linq.from(new Throwable().getStackTrace()).skip(2).take(takeCount);
    }

    public static Class<?> stackClass(int depth) {
        return SecurityManagerEx.INSTANCE.stackClass(2 + depth);
    }

    public static InputStream getResource(String namePattern) {
        InputStream in = Reflects.getClassLoader().getResourceAsStream(namePattern);
        if (in != null) {
            return in;
        }
        in = Reflects.getResources(namePattern).firstOrDefault();
        if (in == null) {
            throw new InvalidException("Resource {} not found", namePattern);
        }
        return in;
    }

    public static Linq<InputStream> getResources(String namePattern) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        return Linq.from(resolver.getResources("classpath*:" + namePattern)).select(InputStreamSource::getInputStream);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader != null ? loader : Reflects.class.getClassLoader();
    }

    public static <T> Class<T> loadClass(String className, boolean initialize) {
        return Reflects.loadClass(className, initialize, true);
    }

    public static <T> Class<T> loadClass(String className, boolean initialize, boolean throwOnEmpty) {
        try {
            return Class.forName(className, initialize, Reflects.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (!throwOnEmpty) {
                return null;
            }
            throw InvalidException.sneaky(e);
        }
    }

    public static boolean isInstance(Object val, Type type) {
        return TypeUtils.isInstance((Object)val, (Type)type);
    }

    public static <TP, TR> String resolveProperty(BiFunc<TP, TR> func) {
        SerializedLambda lambda = Reflects.getLambda(func);
        return Reflects.propertyName(lambda.getImplMethodName());
    }

    public static <TP, TR> Tuple<String, String> resolveImpl(BiFunc<TP, TR> func) {
        SerializedLambda lambda = Reflects.getLambda(func);
        String declaredClass = lambda.getImplClass().replace("/", ".");
        return Tuple.of(declaredClass, Reflects.propertyName(lambda.getImplMethodName()));
    }

    public static <TP, TR> Field resolve(BiFunc<TP, TR> func) {
        SerializedLambda lambda = Reflects.getLambda(func);
        String declaredClass = lambda.getImplClass().replace("/", ".");
        return Reflects.getFieldMap(Class.forName(declaredClass)).get(Reflects.propertyName(lambda.getImplMethodName()));
    }

    static <TP, TR> SerializedLambda getLambda(BiFunc<TP, TR> func) {
        SerializedLambda lambda = (SerializedLambda)Reflects.invokeMethod(func, "writeReplace", new Object[0]);
        String implMethodName = lambda.getImplMethodName();
        if (implMethodName.startsWith("lambda$")) {
            throw new IllegalArgumentException("BiFunc can not be LAMBDA EXPR, but only METHOD REFERENCE");
        }
        if (!implMethodName.startsWith(GET_PROPERTY) && !implMethodName.startsWith(GET_BOOL_PROPERTY)) {
            throw new IllegalArgumentException(implMethodName + " is not a GETTER");
        }
        return lambda;
    }

    public static String getTypeDescriptor(@NonNull Type type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return Sys.toJsonString(type);
    }

    public static Type fromTypeDescriptor(@NonNull String descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked non-null but is null");
        }
        if (descriptor.startsWith("{")) {
            Map typeJson = (Map)Sys.fromJson(descriptor, Map.class);
            return Reflects.fromParameterizedType(typeJson);
        }
        return ClassUtils.getClass((String)descriptor);
    }

    static ParameterizedType fromParameterizedType(Map<String, Object> typeJson) {
        String ownerType = (String)typeJson.get("ownerType");
        String rawType = (String)typeJson.get("rawType");
        List actualTypeArguments = (List)typeJson.get("actualTypeArguments");
        return TypeUtils.parameterizeWithOwner((Type)(ownerType == null ? null : ClassUtils.getClass((String)ownerType)), (Class)ClassUtils.getClass((String)rawType), (Type[])Reflects.fromTypeArguments(actualTypeArguments));
    }

    static Type[] fromTypeArguments(List<Object> typeArguments) {
        return Linq.from(typeArguments).select(p -> {
            if (p instanceof Map) {
                Map typeArg = (Map)p;
                List lowerBounds = (List)typeArg.get("lowerBounds");
                List upperBounds = (List)typeArg.get("upperBounds");
                if (lowerBounds != null && upperBounds != null) {
                    return TypeUtils.wildcardType().withLowerBounds(Reflects.fromTypeArguments(lowerBounds)).withUpperBounds(Reflects.fromTypeArguments(upperBounds)).build();
                }
                return Reflects.fromParameterizedType(typeArg);
            }
            return ClassUtils.getClass((String)((String)p));
        }).toArray(Type.class);
    }

    public static <T> T newInstance(Class<?> type) {
        return Reflects.newInstance(type, Arrays.EMPTY_OBJECT_ARRAY);
    }

    @ErrorCode
    public static <T> T newInstance(Class<?> type, Object ... args) {
        if (args == null) {
            args = Arrays.EMPTY_OBJECT_ARRAY;
        }
        try {
            return (T)ConstructorUtils.invokeConstructor(type, (Object[])args);
        }
        catch (Exception e) {
            log.warn("Not match any accessible constructors. {}", (Object)e.getMessage());
            Constructor ctor = (Constructor)Reflects.findMatchingExecutable(type, null, args);
            if (ctor != null) {
                Reflects.setAccess(ctor);
                return ctor.newInstance(args);
            }
            throw new ApplicationException(Extends.values(type.getName()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Executable> T findMatchingExecutable(Class<?> type, String name, Object[] args) {
        Executable executable;
        block3: {
            void var6_10;
            block4: {
                executable = null;
                if (name == null) break block4;
                Linq<Method> methods = Reflects.getMethodMap(type).get(name);
                if (methods == null) break block3;
                for (Executable executable2 : methods) {
                    if (!Reflects.match(executable2, args)) continue;
                    executable = executable2;
                    break block3;
                }
                break block3;
            }
            Constructor<?>[] constructorArray = type.getDeclaredConstructors();
            int n = constructorArray.length;
            boolean bl = false;
            while (var6_10 < n) {
                Constructor<?> p = constructorArray[var6_10];
                if (Reflects.match(p, args)) {
                    executable = p;
                    break;
                }
                ++var6_10;
            }
        }
        return (T)executable;
    }

    static boolean match(Executable p, Object[] args) {
        if (p.getParameterCount() != args.length) {
            return false;
        }
        Class<?>[] parameterTypes = p.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Object arg = args[i];
            if (!(arg == null ? parameterType.isPrimitive() : !Reflects.primitiveToWrapper(parameterType).isInstance(arg))) continue;
            return false;
        }
        return true;
    }

    public static <T> T invokeDefaultMethod(Method method, Object instance, Object ... args) {
        Extends.require(method, method.isDefault());
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandle methodHandle = lookupConstructor.newInstance(declaringClass, 15).unreflectSpecial(method, declaringClass);
        return (T)methodHandle.bindTo(instance).invokeWithArguments(args);
    }

    public static boolean invokeCloseMethod(Method method, Object instance) {
        if (!Reflects.isCloseMethod(method)) {
            return false;
        }
        return Extends.tryClose(instance);
    }

    public static boolean isCloseMethod(Method method) {
        return Strings.hashEquals(method.getName(), M_0) && method.getParameterCount() == 0;
    }

    public static <T, TT> T invokeStaticMethod(Class<? extends TT> type, String name, Object ... args) {
        return Reflects.invokeMethod(type, null, name, args);
    }

    public static <T, TT> T invokeMethod(TT instance, String name, Object ... args) {
        return Reflects.invokeMethod(null, instance, name, args);
    }

    @ErrorCode
    public static <T, TT> T invokeMethod(Class<? extends TT> type, TT instance, String name, Object ... args) {
        boolean isStatic = type != null;
        Class<Object> searchType = isStatic ? type : instance.getClass();
        Method method = (Method)Reflects.findMatchingExecutable(searchType, name, args);
        if (method != null) {
            return (T)method.invoke(instance, args);
        }
        try {
            if (isStatic) {
                Class[] parameterTypes = Reflects.toClass((Object[])args);
                method = MethodUtils.getMatchingMethod(searchType, (String)name, (Class[])parameterTypes);
                return Reflects.invokeMethod(method, args, new Object[0]);
            }
            return (T)MethodUtils.invokeMethod(instance, (boolean)true, (String)name, (Object[])args);
        }
        catch (Exception e) {
            throw new ApplicationException(Extends.values(searchType.getName(), name), e);
        }
    }

    public static <T, TT> T invokeMethod(Method method, TT instance, Object ... args) {
        Reflects.setAccess(method);
        return (T)method.invoke(instance, args);
    }

    public static Map<String, Linq<Method>> getMethodMap(Class<?> type) {
        return methodCache.getValue().get(type, k -> {
            ArrayList<Method> all = new ArrayList<Method>();
            for (Class current = type; current != null; current = current.getSuperclass()) {
                Method[] declared;
                for (Method method : declared = type.getDeclaredMethods()) {
                    Reflects.setAccess(method);
                }
                Collections.addAll(all, declared);
            }
            Linq<Method> defMethods = Linq.from(type.getInterfaces()).selectMany(p -> Linq.from(p.getMethods())).where(p -> {
                boolean d = p.isDefault();
                if (d) {
                    Reflects.setAccess(p);
                }
                return d;
            });
            all.addAll(defMethods.toList());
            return Collections.unmodifiableMap(Linq.from(all).groupByIntoMap(Method::getName, (p, x) -> x));
        });
    }

    public static Linq<PropertyNode> getProperties(Class<?> to) {
        Cache<String, Linq> cache = Cache.getInstance(Cache.MEMORY_CACHE);
        return cache.get(Sys.fastCacheKey("prop", to), k -> {
            Method getClass = Object.class.getDeclaredMethod("getClass", new Class[0]);
            Linq<Method> q = Linq.from(to.getMethods());
            Linq<Tuple> setters = q.where(p -> p.getParameterCount() == 1 && p.getName().startsWith(SET_PROPERTY)).select(p -> Tuple.of(Reflects.propertyName(p.getName()), p));
            Linq<Tuple> getters = q.where(p -> p.getParameterCount() == 0 && p != getClass && (p.getName().startsWith(GET_PROPERTY) || p.getName().startsWith(GET_BOOL_PROPERTY))).select(p -> Tuple.of(Reflects.propertyName(p.getName()), p));
            return setters.join(getters.toList(), (p, x) -> Strings.hashEquals((String)p.left, (String)x.left), (p, x) -> new PropertyNode((String)p.left, (Method)p.right, (Method)x.right));
        });
    }

    public static String propertyName(String getterOrSetter) {
        String name = getterOrSetter.startsWith(GET_PROPERTY) ? getterOrSetter.substring(GET_PROPERTY.length()) : (getterOrSetter.startsWith(GET_BOOL_PROPERTY) ? getterOrSetter.substring(GET_BOOL_PROPERTY.length()) : (getterOrSetter.startsWith(SET_PROPERTY) ? getterOrSetter.substring(SET_PROPERTY.length()) : getterOrSetter));
        if (name.isEmpty()) {
            throw new InvalidException("Invalid name {}", getterOrSetter);
        }
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static <T> void copyPublicFields(T from, T to) {
        for (Field field : Reflects.getFieldMap(to.getClass()).values()) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            field.set(to, field.get(from));
        }
    }

    public static <T, TT> T readStaticField(Class<? extends TT> type, String name) {
        return Reflects.readField(type, null, name);
    }

    public static <T, TT> T readField(TT instance, String name) {
        return Reflects.readField(instance.getClass(), instance, name);
    }

    public static <T, TT> T readField(Class<? extends TT> type, TT instance, String name) {
        Field field = Reflects.getFieldMap(type).get(name);
        if (field == null) {
            throw new NoSuchFieldException(name);
        }
        return (T)field.get(instance);
    }

    public static <T, TT> void writeStaticField(Class<? extends TT> type, String name, T value) {
        Reflects.writeField(type, null, name, value);
    }

    public static <T, TT> void writeField(TT instance, String name, T value) {
        Reflects.writeField(instance.getClass(), instance, name, value);
    }

    public static <T, TT> void writeField(Class<? extends TT> type, TT instance, String name, T value) {
        Field field = Reflects.getFieldMap(type).get(name);
        if (field == null) {
            throw new NoSuchFieldException(name);
        }
        field.set(instance, Reflects.changeType(value, field.getType()));
    }

    public static Map<String, Field> getFieldMap(Class<?> type) {
        return fieldCache.getValue().get(type, k -> {
            List all = FieldUtils.getAllFieldsList((Class)type);
            for (Field field : all) {
                Reflects.setAccess(field);
            }
            return Collections.unmodifiableMap(Linq.from(all).toMap(Field::getName, p -> p));
        });
    }

    public static void setAccess(AccessibleObject member) {
        if (member.isAccessible()) {
            return;
        }
        try {
            if (member instanceof Field) {
                Field field = (Field)member;
                FieldUtils.removeFinalModifier((Field)field);
            }
            if (System.getSecurityManager() == null) {
                member.setAccessible(true);
            } else {
                AccessController.doPrivileged(() -> {
                    member.setAccessible(true);
                    return null;
                });
            }
        }
        catch (Exception e) {
            log.warn("setAccess", (Throwable)e);
        }
    }

    public static <T> T convertQuietly(Object val, Class<T> toType) {
        return Reflects.convertQuietly(val, toType, null);
    }

    public static <T> T convertQuietly(Object val, @NonNull Class<T> toType, T defaultVal) {
        if (toType == null) {
            throw new NullPointerException("toType is marked non-null but is null");
        }
        try {
            return Extends.ifNull(Reflects.changeType(val, toType), defaultVal);
        }
        catch (Throwable e) {
            return defaultVal;
        }
    }

    public static <TS, TT> void registerConvert(@NonNull Class<TS> baseFromType, @NonNull Class<TT> toType, @NonNull TripleFunc<TS, Class<TT>, TT> converter) {
        if (baseFromType == null) {
            throw new NullPointerException("baseFromType is marked non-null but is null");
        }
        if (toType == null) {
            throw new NullPointerException("toType is marked non-null but is null");
        }
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        convertBeans.add(0, new ConvertBean<TS, TT>(baseFromType, toType, converter));
    }

    public static <T> T defaultValue(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Reflects.changeType(null, type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ErrorCode.ErrorCodes(value={@ErrorCode(value="enumError"), @ErrorCode(cause=NoSuchMethodException.class), @ErrorCode(cause=ReflectiveOperationException.class)})
    public static <T> T changeType(Object value, Class<T> toType) {
        if (value == null) {
            if (!toType.isPrimitive()) {
                if (toType == List.class) {
                    return (T)Collections.emptyList();
                }
                if (toType != Map.class) return null;
                return (T)Collections.emptyMap();
            }
            if (toType == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            value = 0;
        }
        Object fValue = value;
        if (toType == String.class) {
            value = value.toString();
            return (T)value;
        }
        if (toType.isEnum()) {
            boolean failBack = true;
            if (NEnum.class.isAssignableFrom(toType)) {
                if (value instanceof String) {
                    try {
                        value = Integer.valueOf((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (value instanceof Number) {
                    int val = ((Number)value).intValue();
                    value = NEnum.valueOf(toType, val);
                    failBack = false;
                }
            }
            if (failBack) {
                String val = value.toString();
                value = Linq.from(toType.getEnumConstants()).singleOrDefault(p -> ((Enum)p).name().equals(val));
            }
            if (value != null) return (T)value;
            throw new ApplicationException("enumError", Extends.values(fValue, toType.getSimpleName()));
        }
        if (!toType.isPrimitive() && TypeUtils.isInstance((Object)value, (Type)toType)) return (T)value;
        Class<?> fromType = value.getClass();
        try {
            toType = Reflects.primitiveToWrapper((Class)toType);
            if (toType == Boolean.class && value instanceof Number) {
                byte val = ((Number)value).byteValue();
                if (val == 0) {
                    value = Boolean.FALSE;
                    return (T)value;
                } else {
                    if (val != 1) throw new InvalidException("Value should be 0 or 1", new Object[0]);
                    value = Boolean.TRUE;
                }
                return (T)value;
            } else {
                Linq<Method> methods = Reflects.getMethodMap(toType).get(CHANGE_TYPE_METHOD);
                if (methods == null || fromType.isEnum()) {
                    Class fType = toType;
                    ConvertBean convertBean = Linq.from(convertBeans).firstOrDefault(p -> TypeUtils.isInstance((Object)fValue, p.baseFromType) && p.toType.isAssignableFrom(fType));
                    if (convertBean == null) throw new NoSuchMethodException(CHANGE_TYPE_METHOD);
                    return (T)convertBean.converter.apply(value, convertBean.toType);
                }
                if (Number.class.isAssignableFrom(toType)) {
                    if (value instanceof Boolean) {
                        value = !((Boolean)value).booleanValue() ? "0" : "1";
                    } else if (value instanceof Number) {
                        Number num = (Number)value;
                        if (toType == Integer.class) {
                            value = num.intValue();
                        } else if (toType == Long.class) {
                            value = num.longValue();
                        } else if (toType == Byte.class) {
                            value = num.byteValue();
                        } else if (toType == Short.class) {
                            value = num.shortValue();
                        }
                    }
                }
                Method m = null;
                for (Method p2 : methods) {
                    if (p2.getParameterCount() != 1 || p2.getParameterTypes()[0] != String.class) continue;
                    m = p2;
                    break;
                }
                if (m == null) {
                    m = toType.getDeclaredMethod(CHANGE_TYPE_METHOD, String.class);
                }
                value = m.invoke(null, value.toString());
            }
            return (T)value;
        }
        catch (NoSuchMethodException e) {
            throw new ApplicationException(Extends.values(toType), e);
        }
        catch (ReflectiveOperationException e) {
            throw new ApplicationException(Extends.values(fromType, toType, value), e);
        }
    }

    public static boolean isBasicType(@NonNull Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return type.isPrimitive() || type == String.class || Number.class.isAssignableFrom(type) || type == Boolean.class || type.isEnum() || Date.class.isAssignableFrom(type) || type == ULID.class || type == Class.class || type == UUID.class;
    }

    static {
        convertBeans = new CopyOnWriteArrayList();
        try {
            lookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            Reflects.setAccess(lookupConstructor);
        }
        catch (NoSuchMethodException e) {
            throw InvalidException.sneaky(e);
        }
        Reflects.registerConvert(Number.class, Decimal.class, (sv, tt) -> Decimal.valueOf(sv.doubleValue()));
        Reflects.registerConvert(NEnum.class, Integer.class, (sv, tt) -> sv.getValue());
        Reflects.registerConvert(Long.class, Date.class, (sv, tt) -> new Date((long)sv));
        Reflects.registerConvert(Long.class, DateTime.class, (sv, tt) -> new DateTime((long)sv));
        Reflects.registerConvert(Date.class, Long.class, (sv, tt) -> sv.getTime());
        Reflects.registerConvert(Date.class, DateTime.class, (sv, tt) -> new DateTime((Date)sv));
        Reflects.registerConvert(String.class, BigDecimal.class, (sv, tt) -> new BigDecimal((String)sv));
        Reflects.registerConvert(String.class, UUID.class, (sv, tt) -> UUID.fromString(sv));
    }

    static class SecurityManagerEx
    extends SecurityManager {
        static final SecurityManagerEx INSTANCE = new SecurityManagerEx();

        SecurityManagerEx() {
        }

        Class<?> stackClass(int depth) {
            return this.getClassContext()[depth];
        }
    }

    static class ConvertBean<TS, TT> {
        final Class<TS> baseFromType;
        final Class<TT> toType;
        final TripleFunc<TS, Class<TT>, TT> converter;

        public ConvertBean(Class<TS> baseFromType, Class<TT> toType, TripleFunc<TS, Class<TT>, TT> converter) {
            this.baseFromType = baseFromType;
            this.toType = toType;
            this.converter = converter;
        }
    }

    public static class PropertyNode
    implements Serializable {
        private static final long serialVersionUID = 3680733077204898075L;
        public final String propertyName;
        public final Method setter;
        public final Method getter;

        public PropertyNode(String propertyName, Method setter, Method getter) {
            this.propertyName = propertyName;
            this.setter = setter;
            this.getter = getter;
        }
    }
}

