/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import org.rx.core.WaitHandle;
import org.rx.exception.InvalidException;

public class ResetEventWait
implements WaitHandle {
    private volatile boolean open;
    private volatile int holdCount;

    public ResetEventWait() {
        this(false);
    }

    public ResetEventWait(boolean initialState) {
        this.open = initialState;
    }

    public boolean waitOne() {
        return this.waitOne(-1L);
    }

    public synchronized boolean waitOne(long timeoutMillis) {
        long l = timeoutMillis = timeoutMillis == -1L ? 0L : timeoutMillis;
        while (!this.open) {
            try {
                ++this.holdCount;
                this.wait(timeoutMillis);
            }
            catch (InterruptedException e) {
                throw InvalidException.sneaky(e);
            }
            finally {
                --this.holdCount;
            }
            if (timeoutMillis <= 0L) continue;
            if (this.open) break;
            return false;
        }
        return true;
    }

    public synchronized void set() {
        this.open = true;
        this.notifyAll();
    }

    public synchronized void reset() {
        this.open = false;
    }

    @Override
    public boolean await(long timeoutMillis) {
        return this.waitOne(timeoutMillis);
    }

    @Override
    public void signalAll() {
        this.set();
    }

    public int getHoldCount() {
        return this.holdCount;
    }
}

