/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import com.alibaba.fastjson2.JSONFactory;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.rx.annotation.Metadata;
import org.rx.bean.LogStrategy;
import org.rx.core.Cache;
import org.rx.core.Constants;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Strings;
import org.rx.core.YamlConfiguration;
import org.rx.net.Sockets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(topicClass=RxConfig.class)
public final class RxConfig {
    private static final Logger log;
    public static final RxConfig INSTANCE;
    String id;
    String omega;
    String aesKey;
    String mxpwd;
    long mxSamplingPeriod;
    final Set<Class<?>> jsonSkipTypes = ConcurrentHashMap.newKeySet();
    LogStrategy logStrategy;
    final Set<String> logTypeWhitelist = ConcurrentHashMap.newKeySet();
    int traceKeepDays;
    int traceErrorMessageSize;
    long traceSlowElapsedMicros;
    ThreadPoolConfig threadPool = new ThreadPoolConfig();
    CacheConfig cache = new CacheConfig();
    DiskConfig disk = new DiskConfig();
    NetConfig net = new NetConfig();
    Map<Class<?>, Map<String, String>> httpForwards = new ConcurrentHashMap(8);

    public int getIntId() {
        Integer v = Integer.getInteger(this.id);
        if (v != null) {
            return v;
        }
        return this.id.hashCode();
    }

    private RxConfig() {
    }

    public void refreshFromSystemProperty() {
        this.threadPool.initSize = SystemPropertyUtil.getInt((String)"app.threadPool.initSize", (int)this.threadPool.initSize);
        this.threadPool.keepAliveSeconds = SystemPropertyUtil.getInt((String)"app.threadPool.keepAliveSeconds", (int)this.threadPool.keepAliveSeconds);
        this.threadPool.queueCapacity = SystemPropertyUtil.getInt((String)"app.threadPool.queueCapacity", (int)this.threadPool.queueCapacity);
        this.threadPool.lowCpuWaterMark = SystemPropertyUtil.getInt((String)"app.threadPool.lowCpuWaterMark", (int)this.threadPool.lowCpuWaterMark);
        this.threadPool.highCpuWaterMark = SystemPropertyUtil.getInt((String)"app.threadPool.highCpuWaterMark", (int)this.threadPool.highCpuWaterMark);
        this.threadPool.replicas = Math.max(1, SystemPropertyUtil.getInt((String)"app.threadPool.replicas", (int)this.threadPool.replicas));
        this.threadPool.traceName = SystemPropertyUtil.get((String)"app.threadPool.traceName");
        this.threadPool.maxTraceDepth = SystemPropertyUtil.getInt((String)"app.threadPool.maxTraceDepth", (int)this.threadPool.maxTraceDepth);
        this.threadPool.cpuLoadWarningThreshold = SystemPropertyUtil.getInt((String)"app.threadPool.cpuLoadWarningThreshold", (int)this.threadPool.cpuLoadWarningThreshold);
        this.threadPool.samplingPeriod = SystemPropertyUtil.getLong((String)"app.threadPool.samplingPeriod", (long)this.threadPool.samplingPeriod);
        this.threadPool.samplingTimes = SystemPropertyUtil.getInt((String)"app.threadPool.samplingTimes", (int)this.threadPool.samplingTimes);
        this.threadPool.minDynamicSize = SystemPropertyUtil.getInt((String)"app.threadPool.minDynamicSize", (int)this.threadPool.minDynamicSize);
        this.threadPool.maxDynamicSize = SystemPropertyUtil.getInt((String)"app.threadPool.maxDynamicSize", (int)this.threadPool.maxDynamicSize);
        this.threadPool.resizeQuantity = SystemPropertyUtil.getInt((String)"app.threadPool.resizeQuantity", (int)this.threadPool.resizeQuantity);
        this.cache.physicalMemoryUsageWarningThreshold = SystemPropertyUtil.getInt((String)"app.cache.physicalMemoryUsageWarningThreshold", (int)this.cache.physicalMemoryUsageWarningThreshold);
        String mc = SystemPropertyUtil.get((String)"app.cache.mainInstance");
        if (mc != null) {
            this.cache.mainCache = Class.forName(mc);
        }
        this.cache.slidingSeconds = SystemPropertyUtil.getInt((String)"app.cache.slidingSeconds", (int)this.cache.slidingSeconds);
        this.cache.maxItemSize = SystemPropertyUtil.getInt((String)"app.cache.maxItemSize", (int)this.cache.maxItemSize);
        this.disk.diskUsageWarningThreshold = SystemPropertyUtil.getInt((String)"app.disk.diskUsageWarningThreshold", (int)this.disk.diskUsageWarningThreshold);
        this.disk.entityDatabaseRollPeriod = SystemPropertyUtil.getInt((String)"app.disk.entityDatabaseRollPeriod", (int)this.disk.entityDatabaseRollPeriod);
        this.net.reactorThreadAmount = SystemPropertyUtil.getInt((String)"app.net.reactorThreadAmount", (int)this.net.reactorThreadAmount);
        this.net.enableLog = SystemPropertyUtil.getBoolean((String)"app.net.enableLog", (boolean)this.net.enableLog);
        this.net.connectTimeoutMillis = SystemPropertyUtil.getInt((String)"app.net.connectTimeoutMillis", (int)this.net.connectTimeoutMillis);
        this.net.poolMaxSize = SystemPropertyUtil.getInt((String)"app.net.poolMaxSize", (int)this.net.poolMaxSize);
        if (this.net.poolMaxSize <= 0) {
            this.net.poolMaxSize = Constants.CPU_THREADS * 2;
        }
        this.net.poolKeepAliveSeconds = SystemPropertyUtil.getInt((String)"app.net.poolKeepAliveSeconds", (int)this.net.poolKeepAliveSeconds);
        this.net.userAgent = SystemPropertyUtil.get((String)"app.net.userAgent", (String)this.net.userAgent);
        this.reset(this.net.lanIps, "app.net.lanIps");
        this.net.ntp.enableFlags = SystemPropertyUtil.getInt((String)"app.net.ntp.enableFlags", (int)this.net.ntp.enableFlags);
        this.net.ntp.syncPeriod = SystemPropertyUtil.getLong((String)"app.net.ntp.syncPeriod", (long)this.net.ntp.syncPeriod);
        this.net.ntp.timeoutMillis = SystemPropertyUtil.getLong((String)"app.net.ntp.timeoutMillis", (long)this.net.ntp.timeoutMillis);
        this.reset(this.net.ntp.servers, "app.net.ntp.servers");
        this.reset(this.net.dns.inlandServers, "app.net.dns.inlandServers");
        this.reset(this.net.dns.outlandServers, "app.net.dns.outlandServers");
        this.id = SystemPropertyUtil.get((String)"app.id", (String)this.id);
        if (this.id == null) {
            this.id = Sockets.getLocalAddress().getHostAddress() + "-" + Strings.randomValue(99);
        }
        this.omega = SystemPropertyUtil.get((String)"app.omega", (String)this.omega);
        this.aesKey = SystemPropertyUtil.get((String)"app.aesKey", (String)this.aesKey);
        this.mxpwd = SystemPropertyUtil.get((String)"app.mxpwd", (String)this.mxpwd);
        this.mxSamplingPeriod = SystemPropertyUtil.getLong((String)"app.mxSamplingPeriod", (long)this.mxSamplingPeriod);
        String v = SystemPropertyUtil.get((String)"app.jsonSkipTypes");
        if (v != null) {
            this.jsonSkipTypes.clear();
            this.jsonSkipTypes.addAll(Linq.from(Strings.split(v, ",")).select(p -> Class.forName(p)).toSet());
        }
        if ((v = SystemPropertyUtil.get((String)"app.logStrategy")) != null) {
            this.logStrategy = LogStrategy.valueOf(v);
        }
        this.traceKeepDays = SystemPropertyUtil.getInt((String)"app.traceKeepDays", (int)this.traceKeepDays);
        this.traceErrorMessageSize = SystemPropertyUtil.getInt((String)"app.traceErrorMessageSize", (int)this.traceErrorMessageSize);
        this.traceSlowElapsedMicros = SystemPropertyUtil.getLong((String)"app.traceSlowElapsedMicros", (long)this.traceSlowElapsedMicros);
    }

    void reset(Collection<String> conf, String propName) {
        String v = SystemPropertyUtil.get((String)propName);
        if (v == null) {
            return;
        }
        conf.clear();
        conf.addAll(Linq.from(Strings.split(v, ",")).toSet());
    }

    public String getId() {
        return this.id;
    }

    public String getOmega() {
        return this.omega;
    }

    public String getAesKey() {
        return this.aesKey;
    }

    public String getMxpwd() {
        return this.mxpwd;
    }

    public long getMxSamplingPeriod() {
        return this.mxSamplingPeriod;
    }

    public Set<Class<?>> getJsonSkipTypes() {
        return this.jsonSkipTypes;
    }

    public LogStrategy getLogStrategy() {
        return this.logStrategy;
    }

    public Set<String> getLogTypeWhitelist() {
        return this.logTypeWhitelist;
    }

    public int getTraceKeepDays() {
        return this.traceKeepDays;
    }

    public int getTraceErrorMessageSize() {
        return this.traceErrorMessageSize;
    }

    public long getTraceSlowElapsedMicros() {
        return this.traceSlowElapsedMicros;
    }

    public ThreadPoolConfig getThreadPool() {
        return this.threadPool;
    }

    public CacheConfig getCache() {
        return this.cache;
    }

    public DiskConfig getDisk() {
        return this.disk;
    }

    public NetConfig getNet() {
        return this.net;
    }

    public Map<Class<?>, Map<String, String>> getHttpForwards() {
        return this.httpForwards;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOmega(String omega) {
        this.omega = omega;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    public void setMxpwd(String mxpwd) {
        this.mxpwd = mxpwd;
    }

    public void setMxSamplingPeriod(long mxSamplingPeriod) {
        this.mxSamplingPeriod = mxSamplingPeriod;
    }

    public void setLogStrategy(LogStrategy logStrategy) {
        this.logStrategy = logStrategy;
    }

    public void setTraceKeepDays(int traceKeepDays) {
        this.traceKeepDays = traceKeepDays;
    }

    public void setTraceErrorMessageSize(int traceErrorMessageSize) {
        this.traceErrorMessageSize = traceErrorMessageSize;
    }

    public void setTraceSlowElapsedMicros(long traceSlowElapsedMicros) {
        this.traceSlowElapsedMicros = traceSlowElapsedMicros;
    }

    public void setThreadPool(ThreadPoolConfig threadPool) {
        this.threadPool = threadPool;
    }

    public void setCache(CacheConfig cache) {
        this.cache = cache;
    }

    public void setDisk(DiskConfig disk) {
        this.disk = disk;
    }

    public void setNet(NetConfig net) {
        this.net = net;
    }

    public void setHttpForwards(Map<Class<?>, Map<String, String>> httpForwards) {
        this.httpForwards = httpForwards;
    }

    public String toString() {
        return "RxConfig(id=" + this.getId() + ", omega=" + this.getOmega() + ", aesKey=" + this.getAesKey() + ", mxpwd=" + this.getMxpwd() + ", mxSamplingPeriod=" + this.getMxSamplingPeriod() + ", jsonSkipTypes=" + this.getJsonSkipTypes() + ", logStrategy=" + (Object)((Object)this.getLogStrategy()) + ", logTypeWhitelist=" + this.getLogTypeWhitelist() + ", traceKeepDays=" + this.getTraceKeepDays() + ", traceErrorMessageSize=" + this.getTraceErrorMessageSize() + ", traceSlowElapsedMicros=" + this.getTraceSlowElapsedMicros() + ", threadPool=" + this.getThreadPool() + ", cache=" + this.getCache() + ", disk=" + this.getDisk() + ", net=" + this.getNet() + ", httpForwards=" + this.getHttpForwards() + ")";
    }

    static {
        RxConfig temp;
        log = LoggerFactory.getLogger(RxConfig.class);
        JSONFactory.getDefaultObjectReaderProvider().addAutoTypeAccept("org.springframework");
        try {
            temp = YamlConfiguration.RX_CONF.readAs("app", RxConfig.class);
        }
        catch (Throwable e) {
            log.error("RxMeta init error", e);
            temp = new RxConfig();
        }
        temp.refreshFromSystemProperty();
        INSTANCE = temp;
    }

    public static class DnsConfig {
        final List<String> inlandServers = Extends.newConcurrentList(true);
        final List<String> outlandServers = Extends.newConcurrentList(true);

        public List<String> getInlandServers() {
            return this.inlandServers;
        }

        public List<String> getOutlandServers() {
            return this.outlandServers;
        }

        public String toString() {
            return "RxConfig.DnsConfig(inlandServers=" + this.getInlandServers() + ", outlandServers=" + this.getOutlandServers() + ")";
        }
    }

    public static class NtpConfig {
        int enableFlags;
        long syncPeriod;
        long timeoutMillis;
        final List<String> servers = Extends.newConcurrentList(true);

        public int getEnableFlags() {
            return this.enableFlags;
        }

        public long getSyncPeriod() {
            return this.syncPeriod;
        }

        public long getTimeoutMillis() {
            return this.timeoutMillis;
        }

        public List<String> getServers() {
            return this.servers;
        }

        public void setEnableFlags(int enableFlags) {
            this.enableFlags = enableFlags;
        }

        public void setSyncPeriod(long syncPeriod) {
            this.syncPeriod = syncPeriod;
        }

        public void setTimeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
        }

        public String toString() {
            return "RxConfig.NtpConfig(enableFlags=" + this.getEnableFlags() + ", syncPeriod=" + this.getSyncPeriod() + ", timeoutMillis=" + this.getTimeoutMillis() + ", servers=" + this.getServers() + ")";
        }
    }

    public static class NetConfig {
        int reactorThreadAmount;
        boolean enableLog;
        int connectTimeoutMillis;
        int poolMaxSize;
        int poolKeepAliveSeconds;
        String userAgent;
        final List<String> lanIps = Extends.newConcurrentList(true);
        NtpConfig ntp = new NtpConfig();
        DnsConfig dns = new DnsConfig();

        public int getReactorThreadAmount() {
            return this.reactorThreadAmount;
        }

        public boolean isEnableLog() {
            return this.enableLog;
        }

        public int getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public int getPoolMaxSize() {
            return this.poolMaxSize;
        }

        public int getPoolKeepAliveSeconds() {
            return this.poolKeepAliveSeconds;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public List<String> getLanIps() {
            return this.lanIps;
        }

        public NtpConfig getNtp() {
            return this.ntp;
        }

        public DnsConfig getDns() {
            return this.dns;
        }

        public void setReactorThreadAmount(int reactorThreadAmount) {
            this.reactorThreadAmount = reactorThreadAmount;
        }

        public void setEnableLog(boolean enableLog) {
            this.enableLog = enableLog;
        }

        public void setConnectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
        }

        public void setPoolMaxSize(int poolMaxSize) {
            this.poolMaxSize = poolMaxSize;
        }

        public void setPoolKeepAliveSeconds(int poolKeepAliveSeconds) {
            this.poolKeepAliveSeconds = poolKeepAliveSeconds;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public void setNtp(NtpConfig ntp) {
            this.ntp = ntp;
        }

        public void setDns(DnsConfig dns) {
            this.dns = dns;
        }

        public String toString() {
            return "RxConfig.NetConfig(reactorThreadAmount=" + this.getReactorThreadAmount() + ", enableLog=" + this.isEnableLog() + ", connectTimeoutMillis=" + this.getConnectTimeoutMillis() + ", poolMaxSize=" + this.getPoolMaxSize() + ", poolKeepAliveSeconds=" + this.getPoolKeepAliveSeconds() + ", userAgent=" + this.getUserAgent() + ", lanIps=" + this.getLanIps() + ", ntp=" + this.getNtp() + ", dns=" + this.getDns() + ")";
        }
    }

    public static class DiskConfig {
        int diskUsageWarningThreshold;
        int entityDatabaseRollPeriod;

        public int getDiskUsageWarningThreshold() {
            return this.diskUsageWarningThreshold;
        }

        public int getEntityDatabaseRollPeriod() {
            return this.entityDatabaseRollPeriod;
        }

        public void setDiskUsageWarningThreshold(int diskUsageWarningThreshold) {
            this.diskUsageWarningThreshold = diskUsageWarningThreshold;
        }

        public void setEntityDatabaseRollPeriod(int entityDatabaseRollPeriod) {
            this.entityDatabaseRollPeriod = entityDatabaseRollPeriod;
        }

        public String toString() {
            return "RxConfig.DiskConfig(diskUsageWarningThreshold=" + this.getDiskUsageWarningThreshold() + ", entityDatabaseRollPeriod=" + this.getEntityDatabaseRollPeriod() + ")";
        }
    }

    public static class CacheConfig {
        int physicalMemoryUsageWarningThreshold;
        Class<? extends Cache> mainCache;
        int slidingSeconds;
        int maxItemSize;

        public int getPhysicalMemoryUsageWarningThreshold() {
            return this.physicalMemoryUsageWarningThreshold;
        }

        public Class<? extends Cache> getMainCache() {
            return this.mainCache;
        }

        public int getSlidingSeconds() {
            return this.slidingSeconds;
        }

        public int getMaxItemSize() {
            return this.maxItemSize;
        }

        public void setPhysicalMemoryUsageWarningThreshold(int physicalMemoryUsageWarningThreshold) {
            this.physicalMemoryUsageWarningThreshold = physicalMemoryUsageWarningThreshold;
        }

        public void setMainCache(Class<? extends Cache> mainCache) {
            this.mainCache = mainCache;
        }

        public void setSlidingSeconds(int slidingSeconds) {
            this.slidingSeconds = slidingSeconds;
        }

        public void setMaxItemSize(int maxItemSize) {
            this.maxItemSize = maxItemSize;
        }

        public String toString() {
            return "RxConfig.CacheConfig(physicalMemoryUsageWarningThreshold=" + this.getPhysicalMemoryUsageWarningThreshold() + ", mainCache=" + this.getMainCache() + ", slidingSeconds=" + this.getSlidingSeconds() + ", maxItemSize=" + this.getMaxItemSize() + ")";
        }
    }

    public static class ThreadPoolConfig {
        int initSize;
        int keepAliveSeconds;
        int queueCapacity;
        int lowCpuWaterMark;
        int highCpuWaterMark;
        int replicas;
        String traceName;
        int maxTraceDepth;
        int cpuLoadWarningThreshold;
        long samplingPeriod;
        int samplingTimes;
        int minDynamicSize;
        int maxDynamicSize;
        int resizeQuantity;

        public int getInitSize() {
            return this.initSize;
        }

        public int getKeepAliveSeconds() {
            return this.keepAliveSeconds;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public int getLowCpuWaterMark() {
            return this.lowCpuWaterMark;
        }

        public int getHighCpuWaterMark() {
            return this.highCpuWaterMark;
        }

        public int getReplicas() {
            return this.replicas;
        }

        public String getTraceName() {
            return this.traceName;
        }

        public int getMaxTraceDepth() {
            return this.maxTraceDepth;
        }

        public int getCpuLoadWarningThreshold() {
            return this.cpuLoadWarningThreshold;
        }

        public long getSamplingPeriod() {
            return this.samplingPeriod;
        }

        public int getSamplingTimes() {
            return this.samplingTimes;
        }

        public int getMinDynamicSize() {
            return this.minDynamicSize;
        }

        public int getMaxDynamicSize() {
            return this.maxDynamicSize;
        }

        public int getResizeQuantity() {
            return this.resizeQuantity;
        }

        public void setInitSize(int initSize) {
            this.initSize = initSize;
        }

        public void setKeepAliveSeconds(int keepAliveSeconds) {
            this.keepAliveSeconds = keepAliveSeconds;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public void setLowCpuWaterMark(int lowCpuWaterMark) {
            this.lowCpuWaterMark = lowCpuWaterMark;
        }

        public void setHighCpuWaterMark(int highCpuWaterMark) {
            this.highCpuWaterMark = highCpuWaterMark;
        }

        public void setReplicas(int replicas) {
            this.replicas = replicas;
        }

        public void setTraceName(String traceName) {
            this.traceName = traceName;
        }

        public void setMaxTraceDepth(int maxTraceDepth) {
            this.maxTraceDepth = maxTraceDepth;
        }

        public void setCpuLoadWarningThreshold(int cpuLoadWarningThreshold) {
            this.cpuLoadWarningThreshold = cpuLoadWarningThreshold;
        }

        public void setSamplingPeriod(long samplingPeriod) {
            this.samplingPeriod = samplingPeriod;
        }

        public void setSamplingTimes(int samplingTimes) {
            this.samplingTimes = samplingTimes;
        }

        public void setMinDynamicSize(int minDynamicSize) {
            this.minDynamicSize = minDynamicSize;
        }

        public void setMaxDynamicSize(int maxDynamicSize) {
            this.maxDynamicSize = maxDynamicSize;
        }

        public void setResizeQuantity(int resizeQuantity) {
            this.resizeQuantity = resizeQuantity;
        }

        public String toString() {
            return "RxConfig.ThreadPoolConfig(initSize=" + this.getInitSize() + ", keepAliveSeconds=" + this.getKeepAliveSeconds() + ", queueCapacity=" + this.getQueueCapacity() + ", lowCpuWaterMark=" + this.getLowCpuWaterMark() + ", highCpuWaterMark=" + this.getHighCpuWaterMark() + ", replicas=" + this.getReplicas() + ", traceName=" + this.getTraceName() + ", maxTraceDepth=" + this.getMaxTraceDepth() + ", cpuLoadWarningThreshold=" + this.getCpuLoadWarningThreshold() + ", samplingPeriod=" + this.getSamplingPeriod() + ", samplingTimes=" + this.getSamplingTimes() + ", minDynamicSize=" + this.getMinDynamicSize() + ", maxDynamicSize=" + this.getMaxDynamicSize() + ", resizeQuantity=" + this.getResizeQuantity() + ")";
        }
    }

    public static interface ConfigNames {
        public static final String THREAD_POOL_CPU_LOAD_WARNING = "app.threadPool.cpuLoadWarningThreshold";
        public static final String THREAD_POOL_INIT_SIZE = "app.threadPool.initSize";
        public static final String THREAD_POOL_KEEP_ALIVE_SECONDS = "app.threadPool.keepAliveSeconds";
        public static final String THREAD_POOL_QUEUE_CAPACITY = "app.threadPool.queueCapacity";
        public static final String THREAD_POOL_LOW_CPU_WATER_MARK = "app.threadPool.lowCpuWaterMark";
        public static final String THREAD_POOL_HIGH_CPU_WATER_MARK = "app.threadPool.highCpuWaterMark";
        public static final String THREAD_POOL_REPLICAS = "app.threadPool.replicas";
        public static final String THREAD_POOL_TRACE_NAME = "app.threadPool.traceName";
        public static final String THREAD_POOL_MAX_TRACE_DEPTH = "app.threadPool.maxTraceDepth";
        public static final String THREAD_POOL_SAMPLING_PERIOD = "app.threadPool.samplingPeriod";
        public static final String THREAD_POOL_SAMPLING_TIMES = "app.threadPool.samplingTimes";
        public static final String THREAD_POOL_MIN_DYNAMIC_SIZE = "app.threadPool.minDynamicSize";
        public static final String THREAD_POOL_MAX_DYNAMIC_SIZE = "app.threadPool.maxDynamicSize";
        public static final String THREAD_POOL_RESIZE_QUANTITY = "app.threadPool.resizeQuantity";
        public static final String PHYSICAL_MEMORY_USAGE_WARNING = "app.cache.physicalMemoryUsageWarningThreshold";
        public static final String CACHE_MAIN_INSTANCE = "app.cache.mainInstance";
        public static final String CACHE_SLIDING_SECONDS = "app.cache.slidingSeconds";
        public static final String CACHE_MAX_ITEM_SIZE = "app.cache.maxItemSize";
        public static final String DISK_USAGE_WARNING = "app.disk.diskUsageWarningThreshold";
        public static final String DISK_ENTITY_DATABASE_ROLL_PERIOD = "app.disk.entityDatabaseRollPeriod";
        public static final String NET_REACTOR_THREAD_AMOUNT = "app.net.reactorThreadAmount";
        public static final String NET_ENABLE_LOG = "app.net.enableLog";
        public static final String NET_CONNECT_TIMEOUT_MILLIS = "app.net.connectTimeoutMillis";
        public static final String NET_POOL_MAX_SIZE = "app.net.poolMaxSize";
        public static final String NET_POOL_KEEP_ALIVE_SECONDS = "app.net.poolKeepAliveSeconds";
        public static final String NET_USER_AGENT = "app.net.userAgent";
        public static final String NET_LAN_IPS = "app.net.lanIps";
        public static final String NTP_ENABLE_FLAGS = "app.net.ntp.enableFlags";
        public static final String NTP_SYNC_PERIOD = "app.net.ntp.syncPeriod";
        public static final String NTP_TIMEOUT_MILLIS = "app.net.ntp.timeoutMillis";
        public static final String NTP_SERVERS = "app.net.ntp.servers";
        public static final String DNS_INLAND_SERVERS = "app.net.dns.inlandServers";
        public static final String DNS_OUTLAND_SERVERS = "app.net.dns.outlandServers";
        public static final String APP_ID = "app.id";
        public static final String MX_SAMPLING_PERIOD = "app.mxSamplingPeriod";
        public static final String TRACE_KEEP_DAYS = "app.traceKeepDays";
        public static final String TRACE_ERROR_MESSAGE_SIZE = "app.traceErrorMessageSize";
        public static final String TRACE_SLOW_ELAPSED_MICROS = "app.traceSlowElapsedMicros";
        public static final String LOG_STRATEGY = "app.logStrategy";
        public static final String JSON_SKIP_TYPES = "app.jsonSkipTypes";
        public static final String AES_KEY = "app.aesKey";
        public static final String OMEGA = "app.omega";
        public static final String MXPWD = "app.mxpwd";

        public static String getWithoutPrefix(String name) {
            return name.substring(4);
        }
    }
}

