/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.rx.core.Delegate;
import org.rx.core.Disposable;
import org.rx.core.EventArgs;
import org.rx.core.EventPublisher;
import org.rx.core.Extends;
import org.rx.core.StringBuilder;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.exception.InvalidException;
import org.rx.exception.TraceHandler;
import org.rx.io.Bytes;
import org.rx.io.FileStream;
import org.rx.io.Files;
import org.rx.util.function.TripleAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellCommand
extends Disposable
implements EventPublisher<ShellCommand> {
    private static final Logger log = LoggerFactory.getLogger(ShellCommand.class);
    public static final TripleAction<ShellCommand, PrintOutEventArgs> CONSOLE_OUT_HANDLER = (s, e) -> System.out.print(e.toString());
    static final String LINUX_BASH = "bash -c ";
    static final String WIN_CMD = "cmd /c ";
    static final List<ShellCommand> KILL_LIST = Extends.newConcurrentList(true);
    public final Delegate<ShellCommand, PrintOutEventArgs> onPrintOut = Delegate.create();
    public final Delegate<ShellCommand, ExitedEventArgs> onExited = Delegate.create();
    final long daemonPeriod;
    String shell;
    File workspace;
    Process process;
    Future<Void> daemonFuture;

    public static int exec(String shell, String workspace) {
        return ShellCommand.exec(shell, workspace, -1L);
    }

    public static int exec(String shell, String workspace, long timeoutMillis) {
        return ShellCommand.exec(shell, workspace, timeoutMillis, CONSOLE_OUT_HANDLER);
    }

    public static int exec(String shell, String workspace, long timeoutMillis, TripleAction<ShellCommand, PrintOutEventArgs> outHandler) {
        try (ShellCommand cmd = new ShellCommand(shell, workspace);){
            cmd.onPrintOut.combine(outHandler);
            cmd.start();
            if (timeoutMillis == -1L) {
                int n = cmd.waitFor();
                return n;
            }
            if (!cmd.waitFor(timeoutMillis)) {
                cmd.kill();
            }
            int n = cmd.exitValue();
            return n;
        }
    }

    static List<String> translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.isEmpty()) {
            return Collections.emptyList();
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    list.add(current.toString());
                    current = new StringBuilder();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + toProcess);
        }
        return list;
    }

    public synchronized boolean isRunning() {
        return this.process != null && this.process.isAlive();
    }

    public synchronized ShellCommand withCloseFlag() {
        this.shell = (Sys.IS_OS_WINDOWS ? WIN_CMD : LINUX_BASH) + this.shell;
        return this;
    }

    public synchronized ShellCommand withAutoRestart() {
        this.onExited.last((s, e) -> this.restart());
        return this;
    }

    public ShellCommand(String shell) {
        this(shell, null);
    }

    public ShellCommand(String shell, String workspace) {
        this(shell, workspace, 500L, true);
    }

    public ShellCommand(@NonNull String shell, String workspace, long daemonPeriod, boolean killOnExited) {
        if (shell == null) {
            throw new NullPointerException("shell is marked non-null but is null");
        }
        this.shell = shell.trim();
        this.workspace = workspace == null ? null : new File(workspace);
        this.daemonPeriod = Math.max(1L, daemonPeriod);
        if (killOnExited) {
            KILL_LIST.add(this);
        }
    }

    @Override
    protected void freeObjects() {
        this.onPrintOut.close();
        this.kill();
        KILL_LIST.remove(this);
    }

    public synchronized ShellCommand start() {
        if (this.isRunning()) {
            throw new InvalidException("Already started", new Object[0]);
        }
        log.debug("start {}", (Object)this.shell);
        List<String> command = ShellCommand.translateCommandline(this.shell);
        if (!command.isEmpty() && Files.isPath(command.get(0))) {
            this.workspace = new File(Files.getFullPathNoEndSeparator((String)command.get(0)));
        }
        Process tmp = this.process = new ProcessBuilder(command).directory(this.workspace).redirectErrorStream(true).start();
        if (this.daemonFuture != null) {
            this.daemonFuture.cancel(true);
        }
        this.daemonFuture = Tasks.run(() -> {
            LineNumberReader reader = null;
            try {
                if (!this.onPrintOut.isEmpty()) {
                    reader = new LineNumberReader(new InputStreamReader(tmp.getInputStream(), StandardCharsets.UTF_8));
                }
                while (tmp.isAlive()) {
                    try {
                        if (reader != null) {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                this.raiseEvent(this.onPrintOut, new PrintOutEventArgs(reader.getLineNumber(), line));
                            }
                        }
                    }
                    catch (Throwable e) {
                        TraceHandler.INSTANCE.log("onPrintOut", e);
                    }
                    if (!tmp.isAlive()) {
                        break;
                    }
                    Thread.sleep(this.daemonPeriod);
                }
            }
            finally {
                Extends.tryClose(reader);
                ShellCommand shellCommand = this;
                synchronized (shellCommand) {
                    int exitValue = tmp.exitValue();
                    log.debug("exit={} {}", (Object)exitValue, (Object)this.shell);
                    this.raiseEvent(this.onExited, new ExitedEventArgs(exitValue));
                }
            }
        });
        return this;
    }

    public synchronized int exitValue() {
        if (this.process == null) {
            throw new InvalidException("Not start", new Object[0]);
        }
        return this.process.exitValue();
    }

    public synchronized int waitFor() {
        if (!this.isRunning()) {
            return this.exitValue();
        }
        return this.process.waitFor();
    }

    public synchronized boolean waitFor(long timeoutMillis) {
        if (!this.isRunning()) {
            return true;
        }
        return this.process.waitFor(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public synchronized void inputKeys(String keys) {
        if (!this.isRunning()) {
            throw new InvalidException("Not start", new Object[0]);
        }
        OutputStream out = this.process.getOutputStream();
        out.write(keys.getBytes(StandardCharsets.UTF_8));
        out.flush();
    }

    public synchronized void kill() {
        if (!this.isRunning()) {
            return;
        }
        log.debug("kill {}", (Object)this.shell);
        this.process.destroyForcibly();
        this.daemonFuture.cancel(true);
        this.raiseEvent(this.onExited, new ExitedEventArgs(this.process.exitValue()));
    }

    public synchronized void restart() {
        this.kill();
        this.start();
    }

    public String getShell() {
        return this.shell;
    }

    static {
        Tasks.addShutdownHook(() -> {
            for (ShellCommand executor : KILL_LIST) {
                executor.kill();
            }
        });
    }

    public static class ExitedEventArgs
    extends EventArgs {
        private static final long serialVersionUID = 6563058539741657972L;
        final int exitValue;

        public ExitedEventArgs(int exitValue) {
            this.exitValue = exitValue;
        }

        public int getExitValue() {
            return this.exitValue;
        }
    }

    public static class FileOutHandler
    extends Disposable
    implements TripleAction<ShellCommand, PrintOutEventArgs> {
        final FileStream fileStream;

        public FileOutHandler(String filePath) {
            Files.createDirectory(filePath);
            this.fileStream = new FileStream(filePath);
        }

        @Override
        protected void freeObjects() {
            this.fileStream.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(ShellCommand s, PrintOutEventArgs e) throws Throwable {
            ByteBuf buf = Bytes.directBuffer();
            buf.writeInt(e.lineNumber);
            buf.writeCharSequence((CharSequence)".\t", StandardCharsets.UTF_8);
            buf.writeCharSequence((CharSequence)e.line, StandardCharsets.UTF_8);
            buf.writeCharSequence((CharSequence)"\n", StandardCharsets.UTF_8);
            try {
                this.fileStream.write(buf);
            }
            finally {
                buf.release();
            }
        }
    }

    public static class PrintOutEventArgs
    extends EventArgs {
        private static final long serialVersionUID = 4598104225029493537L;
        final int lineNumber;
        final String line;

        public String toString() {
            return String.format("%s.\t%s\n", this.lineNumber, this.line);
        }

        public PrintOutEventArgs(int lineNumber, String line) {
            this.lineNumber = lineNumber;
            this.line = line;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getLine() {
            return this.line;
        }
    }
}

