/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import java.io.IOException;
import java.io.Serializable;
import org.rx.util.function.TripleAction;

public final class StringBuilder
implements Appendable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -5807000410250350182L;
    final java.lang.StringBuilder buffer;
    TripleAction<StringBuilder, Object> preAppend;

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    public StringBuilder() {
        this.buffer = new java.lang.StringBuilder();
    }

    public StringBuilder(int capacity) {
        this.buffer = new java.lang.StringBuilder(capacity);
    }

    public StringBuilder(CharSequence seq) {
        this.buffer = new java.lang.StringBuilder(seq);
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    public StringBuilder setLength(int length) {
        this.buffer.setLength(length);
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.buffer.charAt(index);
    }

    public StringBuilder setCharAt(int index, char ch) {
        this.buffer.setCharAt(index, ch);
        return this;
    }

    public int indexOf(String str) {
        return this.buffer.indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this.buffer.indexOf(str, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.buffer.lastIndexOf(str);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.buffer.lastIndexOf(str, fromIndex);
    }

    public StringBuilder insert(int offset, Object obj) {
        this.buffer.insert(offset, obj);
        return this;
    }

    public StringBuilder insert(int offset, String str) {
        this.buffer.insert(offset, str);
        return this;
    }

    public StringBuilder insert(int offset, String format, Object ... args) {
        return this.insert(offset, String.format(format, args));
    }

    public StringBuilder insert(int dstOffset, CharSequence s) {
        this.buffer.insert(dstOffset, s);
        return this;
    }

    public StringBuilder insert(int dstOffset, CharSequence s, int start, int end) {
        this.buffer.insert(dstOffset, s, start, end);
        return this;
    }

    public StringBuilder insert(int offset, boolean p) {
        this.buffer.insert(offset, p);
        return this;
    }

    public StringBuilder insert(int offset, char p) {
        this.buffer.insert(offset, p);
        return this;
    }

    public StringBuilder insert(int offset, int p) {
        this.buffer.insert(offset, p);
        return this;
    }

    public StringBuilder insert(int offset, long p) {
        this.buffer.insert(offset, p);
        return this;
    }

    public StringBuilder insert(int offset, float p) {
        this.buffer.insert(offset, p);
        return this;
    }

    public StringBuilder insert(int offset, double p) {
        this.buffer.insert(offset, p);
        return this;
    }

    public StringBuilder replace(String target, String replacement) {
        int index = 0;
        while ((index = this.buffer.indexOf(target, index)) != -1) {
            this.buffer.replace(index, index + target.length(), replacement);
            index += replacement.length();
        }
        return this;
    }

    public StringBuilder replace(int start, int end, String str) {
        this.buffer.replace(start, end, str);
        return this;
    }

    public StringBuilder delete(int offset, int length) {
        this.buffer.delete(offset, offset + length);
        return this;
    }

    public StringBuilder deleteCharAt(int index) {
        this.buffer.deleteCharAt(index);
        return this;
    }

    void preAppend(Object obj) {
        if (this.preAppend == null) {
            return;
        }
        this.preAppend.invoke(this, obj);
    }

    @Override
    public StringBuilder append(CharSequence csq) throws IOException {
        this.preAppend(csq);
        this.buffer.append(csq);
        return this;
    }

    public StringBuilder append(Object obj) {
        this.preAppend(obj);
        this.buffer.append(obj);
        return this;
    }

    public StringBuilder append(String str) {
        this.preAppend(str);
        this.buffer.append(str);
        return this;
    }

    public StringBuilder append(String format, Object ... args) {
        return this.append(String.format(format, args));
    }

    @Override
    public StringBuilder append(CharSequence csq, int start, int end) throws IOException {
        this.buffer.append(csq, start, end);
        return this;
    }

    @Override
    public StringBuilder append(char p) {
        this.buffer.append(p);
        return this;
    }

    public StringBuilder append(boolean p) {
        this.buffer.append(p);
        return this;
    }

    public StringBuilder append(int p) {
        this.buffer.append(p);
        return this;
    }

    public StringBuilder append(long p) {
        this.buffer.append(p);
        return this;
    }

    public StringBuilder append(float p) {
        this.buffer.append(p);
        return this;
    }

    public StringBuilder append(double p) {
        this.buffer.append(p);
        return this;
    }

    public StringBuilder appendLine() {
        this.buffer.append(System.lineSeparator());
        return this;
    }

    public StringBuilder appendLine(Object obj) {
        this.preAppend(obj);
        this.buffer.append(obj);
        return this.appendLine();
    }

    public StringBuilder appendLine(String format, Object ... args) {
        return this.appendLine(String.format(format, args));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.buffer.subSequence(start, end);
    }

    public String substring(int start) {
        return this.buffer.substring(start);
    }

    public String substring(int start, int end) {
        return this.buffer.substring(start, end);
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }

    public String toString(int offset, int length) {
        return this.buffer.substring(offset, offset + length);
    }

    public java.lang.StringBuilder getBuffer() {
        return this.buffer;
    }

    public TripleAction<StringBuilder, Object> getPreAppend() {
        return this.preAppend;
    }

    public void setPreAppend(TripleAction<StringBuilder, Object> preAppend) {
        this.preAppend = preAppend;
    }
}

