/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.rx.annotation.ErrorCode;
import org.rx.core.Arrays;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.StringBuilder;
import org.rx.exception.ApplicationException;
import org.rx.exception.InvalidException;

public class Strings
extends StringUtils {
    public static String trimVarExpressionName(String exprName) {
        if (exprName == null) {
            return null;
        }
        int s = 0;
        int e = exprName.length();
        if (exprName.startsWith("${")) {
            s = 2;
        }
        if (exprName.endsWith("}")) {
            e = exprName.length() - 1;
        }
        return exprName.substring(s, e);
    }

    public static List<String> getVarExpressionNames(@NonNull String expr, boolean onlyName) {
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        ArrayList<String> list = new ArrayList<String>();
        int s = 0;
        while ((s = expr.indexOf("${", s)) != -1) {
            int e = expr.indexOf("}", s += 2);
            if (e == -1) {
                throw new InvalidException("Invalid expression", new Object[0]);
            }
            list.add(onlyName ? expr.substring(s, e) : expr.substring(s - 2, e + 1));
        }
        return list;
    }

    public static String resolveVarExpression(String expr, Map<String, Object> vars) {
        return Strings.resolveVarExpression(new StringBuilder(expr), vars);
    }

    public static String resolveVarExpression(@NonNull StringBuilder expr, @NonNull Map<String, Object> vars) {
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        for (Map.Entry<String, Object> var : vars.entrySet()) {
            expr.replace(var.getKey(), Extends.ifNull(var.getValue(), "").toString());
        }
        return expr.toString();
    }

    public static double simpleEval(final @NonNull String expression) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return new Object(){
            int pos = -1;
            int ch;

            void nextChar() {
                this.ch = ++this.pos < expression.length() ? (int)expression.charAt(this.pos) : -1;
            }

            boolean eat(int charToEat) {
                while (this.ch == 32) {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < expression.length()) {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                return x;
            }

            double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat(43)) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (!this.eat(45)) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            double parseTerm() {
                double x = this.parseFactor();
                while (true) {
                    if (this.eat(42)) {
                        x *= this.parseFactor();
                        continue;
                    }
                    if (!this.eat(47)) break;
                    x /= this.parseFactor();
                }
                return x;
            }

            double parseFactor() {
                double x;
                if (this.eat(43)) {
                    return this.parseFactor();
                }
                if (this.eat(45)) {
                    return -this.parseFactor();
                }
                int startPos = this.pos;
                if (this.eat(40)) {
                    x = this.parseExpression();
                    this.eat(41);
                } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                    while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                        this.nextChar();
                    }
                    x = Double.parseDouble(expression.substring(startPos, this.pos));
                } else {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                if (this.eat(94)) {
                    x = Math.pow(x, this.parseFactor());
                }
                return x;
            }
        }.parse();
    }

    public static int compareVersion(@NonNull String version1, @NonNull String version2) {
        if (version1 == null) {
            throw new NullPointerException("version1 is marked non-null but is null");
        }
        if (version2 == null) {
            throw new NullPointerException("version2 is marked non-null but is null");
        }
        int len1 = version1.length();
        int len2 = version2.length();
        int p1 = 0;
        for (int p2 = 0; p1 < len1 || p2 < len2; ++p2) {
            int num1 = 0;
            int num2 = 0;
            while (p1 < len1 && version1.charAt(p1) != '.') {
                num1 = num1 * 10 + version1.charAt(p1++) - 48;
            }
            ++p1;
            while (p2 < len2 && version2.charAt(p2) != '.') {
                num2 = num2 * 10 + version2.charAt(p2++) - 48;
            }
            if (num1 == num2) continue;
            return num1 > num2 ? 1 : -1;
        }
        return 0;
    }

    public static String maskPrivacy(String str) {
        int right;
        int left;
        if (Strings.isEmpty((CharSequence)str)) {
            return "";
        }
        str = str.trim();
        int len = str.length();
        switch (len) {
            case 11: {
                left = 3;
                right = 4;
                break;
            }
            case 18: {
                left = 4;
                right = 6;
                break;
            }
            default: {
                if (len < 3) {
                    left = 1;
                    right = 0;
                    break;
                }
                left = right = len / 3;
            }
        }
        String x = Strings.repeat((String)"*", (int)(len - left - right));
        return str.substring(0, left) + x + str.substring(left + x.length());
    }

    public static String randomValue(int maxValue) {
        return String.format("%0" + String.valueOf(maxValue).length() + "d", ThreadLocalRandom.current().nextInt(maxValue));
    }

    public static String toNumeric(String str) {
        if (Strings.isEmpty((CharSequence)str)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!Character.isDigit(c) && c != '.') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static boolean hashEquals(String a, String b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.hashCode() != b.hashCode()) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean equalsTrim(String a, String b) {
        return Strings.equals((CharSequence)Strings.trim((String)a), (CharSequence)Strings.trim((String)b));
    }

    public static boolean equalsTrimIgnoreCase(String a, String b) {
        return Strings.equalsIgnoreCase((CharSequence)Strings.trim((String)a), (CharSequence)Strings.trim((String)b));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsAll(String str, CharSequence ... searches) {
        if (str == null) return false;
        if (!Linq.from(searches).all(str::contains)) return false;
        return true;
    }

    public static String replaceLast(String text, String regex, String replacement) {
        if (text == null || regex == null) {
            return text;
        }
        return text.replaceFirst("(?s)" + regex + "(?!.*?" + regex + ")", replacement);
    }

    public static String[] split(String str, String delimiter) {
        return Strings.split(str, delimiter, -1);
    }

    @ErrorCode(value="lengthError")
    public static String[] split(String str, String delimiter, int fixedLength) {
        String[] result = str == null ? Arrays.EMPTY_STRING_ARRAY : str.split(Pattern.quote(delimiter));
        if (fixedLength > -1 && fixedLength != result.length) {
            throw new ApplicationException("lengthError", Extends.values(fixedLength));
        }
        return result;
    }

    public static String subStringByByteLen(String text, int length) {
        if (Strings.isEmpty((CharSequence)text)) {
            return "";
        }
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            int offset = text.charAt(i) > '\u0100' ? 2 : 1;
            if ((count += offset) < length) continue;
            int end = i + (offset == 2 ? 0 : 1);
            if (i == 0) break;
            return text.substring(0, end);
        }
        return text;
    }

    public static boolean isMatch(CharSequence input, String regularExp) {
        return input != null && regularExp != null && Pattern.matches(regularExp, input);
    }

    public static interface RegularExp {
        public static final String Email = "^[\\w-]+(\\.[\\w-]+)*@[\\w-]+(\\.[\\w-]+)+$";
        public static final String CitizenId = "^(\\d{15}$|^\\d{18}$|^\\d{17}(\\d|X|x))$";
        public static final String Mobile = "^0{0,1}1[3|5|7|8]\\d{9}$";
        public static final String Telephone = "(\\d+-)?(\\d{4}-?\\d{7}|\\d{3}-?\\d{8}|^\\d{7,8})(-\\d+)?";
        public static final String Date = "^((((1[6-9]|[2-9]\\d)\\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\\d|3[01]))|(((1[6-9]|[2-9]\\d)\\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\\d|30))|(((1[6-9]|[2-9]\\d)\\d{2})-0?2-(0?[1-9]|1\\d|2[0-8]))|(((1[6-9]|[2-9]\\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-))$";
        public static final String DateTime = "^((((1[6-9]|[2-9]\\d)\\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\\d|3[01]))|(((1[6-9]|[2-9]\\d)\\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\\d|30))|(((1[6-9]|[2-9]\\d)\\d{2})-0?2-(0?[1-9]|1\\d|2[0-8]))|(((1[6-9]|[2-9]\\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-)) (20|21|22|23|[0-1]?\\d):[0-5]?\\d:[0-5]?\\d$";
        public static final String IP = "^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])$";
        public static final String Url = "^((http|https|ftp):\\/\\/)?(\\w(\\:\\w)?@)?([0-9a-z_-]+\\.)*?([a-z0-9-]+\\.[a-z]{2,6}(\\.[a-z]{2})?(\\:[0-9]{2,6})?)((\\/[^?#<>\\/\\\\*\":]*)+(\\?[^#]*)?(#.*)?)?$";
        public static final String Float = "^(-?\\d+)(\\.\\d+)?$";
        public static final String Integer = "^-?\\d+$";
        public static final String PlusFloat = "^(([0-9]+\\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\\.[0-9]+)|([0-9]*[1-9][0-9]*))$";
        public static final String PlusInteger = "^[0-9]*[1-9][0-9]*$";
        public static final String MinusFloat = "^(-(([0-9]+\\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\\.[0-9]+)|([0-9]*[1-9][0-9]*)))$";
        public static final String MinusInteger = "^-[0-9]*[1-9][0-9]*$";
        public static final String UnMinusFloat = "^\\d+(\\.\\d+)?$";
        public static final String UnMinusInteger = "^\\d+$";
        public static final String UnPlusFloat = "^((-\\d+(\\.\\d+)?)|(0+(\\.0+)?))$";
        public static final String UnPlusInteger = "^((-\\d+)|(0+))$";
        public static final String Numeric = "^[0-9]+$";
        public static final String NumericOrLetter = "^[A-Za-z0-9]+$";
        public static final String NumericOrLetterOrUnderline = "^\\w+$";
        public static final String NumericOrLetterOrChinese = "^[A-Za-z0-9\\u4E00-\\u9FA5\\uF900-\\uFA2D]+$";
        public static final String Letter = "^[A-Za-z]+$";
        public static final String LowerLetter = "^[a-z]+$";
        public static final String UpperLetter = "^[A-Z]+$";
        public static final String Chinese = "^[\\u4E00-\\u9FA5\\uF900-\\uFA2D]+$";
        public static final String PostCode = "^\\d{6}$";
        public static final String Color = "^#[a-fA-F0-9]{6}";
        public static final String ImageFormat = "\\.(?i:jpg|bmp|gif|ico|pcx|jpeg|tif|png|raw|tga)$";
        public static final String PWD_STRENGTH = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,40}$";
    }
}

