/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import ch.qos.logback.classic.util.LogbackMDCAdapter;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.ThreadMXBean;
import io.netty.util.Timeout;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SystemUtils;
import org.rx.annotation.Subscribe;
import org.rx.bean.DynamicProxyBean;
import org.rx.bean.LogStrategy;
import org.rx.bean.ProceedEventArgs;
import org.rx.codec.CodecUtil;
import org.rx.core.Arrays;
import org.rx.core.Cache;
import org.rx.core.Extends;
import org.rx.core.ForkJoinPoolWrapper;
import org.rx.core.IOC;
import org.rx.core.Linq;
import org.rx.core.NtpClock;
import org.rx.core.Numbers;
import org.rx.core.ObjectChangeTracker;
import org.rx.core.ObjectChangedEvent;
import org.rx.core.Reflects;
import org.rx.core.RxConfig;
import org.rx.core.StringBuilder;
import org.rx.core.Strings;
import org.rx.core.Tasks;
import org.rx.core.ThreadPool;
import org.rx.exception.InvalidException;
import org.rx.exception.TraceHandler;
import org.rx.io.Serializer;
import org.rx.net.Sockets;
import org.rx.util.function.BiAction;
import org.rx.util.function.BiFunc;
import org.rx.util.function.TripleFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;

public final class Sys
extends SystemUtils {
    private static final Logger log = LoggerFactory.getLogger(Sys.class);
    public static final HotSpotDiagnosticMXBean diagnosticMx = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
    public static final ThreadMXBean threadMx = (ThreadMXBean)ManagementFactory.getThreadMXBean();
    static final OperatingSystemMXBean osMx = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    static final String DPT = "_DPT";
    static final Pattern PATTERN_TO_FIND_OPTIONS = Pattern.compile("(?<=-).*?(?==)");
    static final JSONReader.Feature[] JSON_READ_FLAGS = new JSONReader.Feature[]{JSONReader.Feature.SupportClassForName, JSONReader.Feature.AllowUnQuotedFieldNames};
    static final JSONWriter.Feature[] JSON_WRITE_FLAGS = new JSONWriter.Feature[]{JSONWriter.Feature.NotWriteDefaultValue};
    public static final ValueFilter JSON_WRITE_SKIP_TYPES = (o, k, v) -> {
        if (v == null) {
            return null;
        }
        Iterable iter = Linq.asIterable(v, false);
        if (iter != null) {
            return Linq.from(iter).select(iv -> Sys.jsonValueFilter(o, k, iv)).toList();
        }
        return Sys.jsonValueFilter(o, k, v);
    };
    static final String[] seconds = new String[]{"ns", "\u00b5s", "ms", "s"};
    static Timeout samplingTimeout;
    static byte transformedFlags;

    static void checkAdviceShare(boolean isInit) {
        Object[] share;
        Properties props = System.getProperties();
        Object v = props.get("");
        boolean changed = false;
        if (!(v instanceof Object[]) || (share = (Object[])v).length != 2) {
            share = new Object[2];
            changed = true;
        }
        if (!((v = share[0]) instanceof long[]) || ((long[])v).length != 2) {
            if (isInit) {
                long[] time = new long[2];
                time[1] = System.currentTimeMillis();
                time[0] = System.nanoTime();
                share[0] = time;
            } else {
                share[0] = null;
            }
        }
        if (!((v = share[1]) instanceof Function)) {
            share[1] = ForkJoinPoolWrapper.ADVICE_FN;
        }
        if (changed) {
            props.put("", share);
        }
    }

    /*
     * WARNING - void declaration
     */
    static long[] getAdviceShareTime() {
        void var3_3;
        long[] time;
        Object[] share;
        Properties props = System.getProperties();
        Object v = props.get("");
        if (!(v instanceof Object[]) || (share = (Object[])v).length != 2) {
            return null;
        }
        v = share[0];
        return (long[])(!(v instanceof long[]) || (time = (long[])v).length != 2 ? null : var3_3);
    }

    @Subscribe(topicClass=RxConfig.class)
    static void onChanged(ObjectChangedEvent event) {
        Map<String, ObjectChangeTracker.ChangedValue> changedMap = event.getChangedMap();
        Integer enableFlags = (Integer)event.readValue(RxConfig.ConfigNames.getWithoutPrefix("app.net.ntp.enableFlags"));
        if (enableFlags == null) {
            return;
        }
        log.info("RxMeta {} changed {}", (Object)"app.net.ntp.enableFlags", (Object)enableFlags);
        if ((enableFlags & 1) == 1) {
            NtpClock.scheduleTask();
        }
        if ((enableFlags & 2) == 2) {
            Tasks.setTimeout(() -> {
                log.info("TimeAdvice inject..");
                NtpClock.transform();
            }, 60000L);
        }
    }

    public static Map<String, String> mainOptions(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String arg : args) {
            Matcher matcher;
            if (!arg.startsWith("-") || !(matcher = PATTERN_TO_FIND_OPTIONS.matcher(arg)).find()) continue;
            result.put(matcher.group(), arg.replaceFirst("-.*?=", ""));
        }
        return result;
    }

    public static List<String> mainOperations(String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) break;
            result.add(arg);
        }
        return result;
    }

    public static File getJarFile(Object obj) {
        return Sys.getJarFile(obj.getClass());
    }

    public static File getJarFile(Class<?> klass) {
        String url = klass.getClassLoader().getResource(klass.getPackage().getName().replace(".", "/")).toString().replace(" ", "%20");
        URI uri = new URI(url);
        if (uri.getPath() != null) {
            return new File(uri);
        }
        String path = uri.toString();
        if (!path.startsWith("jar:file:")) {
            return null;
        }
        path = path.substring(path.indexOf("file:/"));
        if ((path = path.substring(0, path.toLowerCase().indexOf(".jar") + 4)).startsWith("file://")) {
            path = "C:/" + path.substring(path.indexOf("file:/") + 7);
            path = "/" + new URI(path).getPath();
        } else {
            path = new URI(path).getPath();
        }
        return new File(path);
    }

    public static <T> T targetObject(Object proxyObject) {
        return (T)IOC.weakMap(proxyObject, false).get(DPT);
    }

    public static <T> T proxy(Class<?> type, TripleFunc<Method, DynamicProxyBean, Object> func) {
        return Sys.proxy(type, func, false);
    }

    public static <T> T proxy(Class<?> type, TripleFunc<Method, DynamicProxyBean, Object> func, boolean jdkProxy) {
        return Sys.proxy(type, func, null, jdkProxy);
    }

    public static <T> T proxy(Class<?> type, TripleFunc<Method, DynamicProxyBean, Object> func, T rawObject, boolean jdkProxy) {
        Object proxyObj = jdkProxy ? Proxy.newProxyInstance(Reflects.getClassLoader(), new Class[]{type}, (InvocationHandler)new DynamicProxyBean(func)) : Enhancer.create(type, (Callback)new DynamicProxyBean(func));
        if (rawObject != null) {
            IOC.weakMap(proxyObj, false).put(DPT, rawObject);
        }
        return (T)proxyObj;
    }

    public static <T> ArrayList<T> proxyList(ArrayList<T> source, BiAction<ArrayList<T>> onSet) {
        return (ArrayList)Sys.proxy(ArrayList.class, (m, p) -> {
            Object val = p.fastInvoke(source);
            if (onSet != null && Reflects.List_WRITE_METHOD_NAMES.contains(m.getName())) {
                onSet.invoke(source);
            }
            return val;
        });
    }

    public static <T> T logCtx(String name) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        if (mdc == null) {
            return null;
        }
        return (T)mdc.get(name);
    }

    public static void logCtxIfAbsent(String name, Object value) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        if (mdc == null) {
            return;
        }
        String v = mdc.get(name);
        if (v != null) {
            return;
        }
        Sys.logCtx(name, value);
    }

    public static void logCtx(String name, Object value) {
        MDCAdapter mdc = MDC.getMDCAdapter();
        if (mdc == null) {
            return;
        }
        if (value == null) {
            mdc.remove(name);
            return;
        }
        mdc.put(name, Sys.toJsonString(value));
    }

    public static void clearLogCtx() {
        MDCAdapter mdc = MDC.getMDCAdapter();
        if (mdc == null) {
            return;
        }
        mdc.clear();
    }

    public static void logHttp(@NonNull ProceedEventArgs eventArgs, String url) {
        if (eventArgs == null) {
            throw new NullPointerException("eventArgs is marked non-null but is null");
        }
        RxConfig conf = RxConfig.INSTANCE;
        eventArgs.setLogStrategy(conf.logStrategy);
        eventArgs.setLogTypeWhitelist(conf.logTypeWhitelist);
        Sys.log(eventArgs, msg -> {
            msg.appendLine("Url:\t%s", url).appendLine("Request:\t%s", Sys.toJsonString(eventArgs.getParameters())).appendLine("Response:\t%s\tElapsed=%s", Sys.toJsonString(eventArgs.getReturnValue()), Sys.formatNanosElapsed(eventArgs.getElapsedNanos()));
            if (eventArgs.getError() != null) {
                msg.appendLine("Error:\t%s", eventArgs.getError());
            }
        });
    }

    public static void log(@NonNull ProceedEventArgs eventArgs, @NonNull BiAction<StringBuilder> formatMessage) {
        Set<String> whitelist;
        boolean doWrite;
        if (eventArgs == null) {
            throw new NullPointerException("eventArgs is marked non-null but is null");
        }
        if (formatMessage == null) {
            throw new NullPointerException("formatMessage is marked non-null but is null");
        }
        Map mappedDiagnosticCtx = Collections.emptyMap();
        MDCAdapter mdc = MDC.getMDCAdapter();
        if (mdc != null) {
            Map pm;
            LogbackMDCAdapter lb = Extends.as(mdc, LogbackMDCAdapter.class);
            Map map = pm = lb != null ? lb.getPropertyMap() : mdc.getCopyOfContextMap();
            if (pm != null) {
                mappedDiagnosticCtx = pm;
            }
        }
        boolean bl = doWrite = !mappedDiagnosticCtx.isEmpty();
        if (!doWrite) {
            if (eventArgs.getLogStrategy() == null) {
                eventArgs.setLogStrategy(eventArgs.getError() != null ? LogStrategy.WRITE_ON_ERROR : LogStrategy.WRITE_ON_NULL);
            }
            switch (eventArgs.getLogStrategy()) {
                case WRITE_ON_NULL: {
                    doWrite = eventArgs.getError() != null || !eventArgs.isVoid() && eventArgs.getReturnValue() == null || !Arrays.isEmpty((Object[])eventArgs.getParameters()) && Arrays.contains((Object[])eventArgs.getParameters(), null);
                    break;
                }
                case WRITE_ON_ERROR: {
                    if (eventArgs.getError() == null) break;
                    doWrite = true;
                    break;
                }
                case ALWAYS: {
                    doWrite = true;
                }
            }
        }
        if (doWrite && !CollectionUtils.isEmpty(whitelist = eventArgs.getLogTypeWhitelist())) {
            doWrite = Linq.from(whitelist).any(p -> eventArgs.getDeclaringType().getName().startsWith((String)p));
        }
        if (doWrite) {
            Logger log = LoggerFactory.getLogger(eventArgs.getDeclaringType());
            StringBuilder msg = new StringBuilder(256);
            formatMessage.invoke(msg);
            boolean first = true;
            for (Map.Entry entry : mappedDiagnosticCtx.entrySet()) {
                if (first) {
                    msg.append("MDC:\t");
                    first = false;
                }
                msg.append("%s=%s ", entry.getKey(), entry.getValue());
            }
            if (!first) {
                msg.appendLine();
            }
            if (eventArgs.getError() != null) {
                TraceHandler.INSTANCE.log(msg.toString(), eventArgs.getError());
            } else {
                log.info(msg.toString());
            }
        }
    }

    public static synchronized void mxScheduleTask(BiAction<Info> mxHandler) {
        if (samplingTimeout != null) {
            samplingTimeout.cancel();
        }
        samplingTimeout = ThreadPool.timer.newTimeout(t -> {
            try {
                mxHandler.invoke(Sys.mxInfo());
            }
            catch (Throwable e) {
                TraceHandler.INSTANCE.log(e);
            }
            finally {
                t.timer().newTimeout(t.task(), RxConfig.INSTANCE.getMxSamplingPeriod(), TimeUnit.MILLISECONDS);
            }
        }, RxConfig.INSTANCE.getMxSamplingPeriod(), TimeUnit.MILLISECONDS);
    }

    public static Info mxInfo() {
        File bd = new File("/");
        return new Info(osMx.getAvailableProcessors(), osMx.getSystemCpuLoad(), threadMx.getThreadCount(), osMx.getFreePhysicalMemorySize(), osMx.getTotalPhysicalMemorySize(), Linq.from(File.listRoots()).select(p -> new DiskInfo(p.getName(), p.getAbsolutePath(), p.getFreeSpace(), p.getTotalSpace(), bd.getAbsolutePath().equals(p.getAbsolutePath()))));
    }

    public static List<ThreadInfo> findDeadlockedThreads() {
        long[] deadlockedTids = Arrays.addAll((long[])threadMx.findDeadlockedThreads(), (long[])threadMx.findMonitorDeadlockedThreads());
        if (Arrays.isEmpty((long[])deadlockedTids)) {
            return Collections.emptyList();
        }
        return Linq.from(threadMx.getThreadInfo(deadlockedTids)).select((p, i) -> new ThreadInfo((java.lang.management.ThreadInfo)p, -1L, -1L)).toList();
    }

    public static Linq<ThreadInfo> getAllThreads() {
        if (!threadMx.isThreadContentionMonitoringEnabled()) {
            threadMx.setThreadContentionMonitoringEnabled(true);
        }
        if (!threadMx.isThreadCpuTimeEnabled()) {
            threadMx.setThreadCpuTimeEnabled(true);
        }
        boolean includeLock = false;
        Linq<java.lang.management.ThreadInfo> allThreads = Linq.from(threadMx.dumpAllThreads(includeLock, includeLock));
        long[] tids = Arrays.toPrimitive((Long[])allThreads.select(java.lang.management.ThreadInfo::getThreadId).toArray());
        long[] threadUserTime = threadMx.getThreadUserTime(tids);
        long[] threadCpuTime = threadMx.getThreadCpuTime(tids);
        return allThreads.select((p, i) -> new ThreadInfo((java.lang.management.ThreadInfo)p, threadUserTime[i], threadCpuTime[i]));
    }

    public static String formatCpuLoad(double val) {
        String p = String.valueOf(val * 100.0);
        int ix = p.indexOf(".") + 1;
        String percent = p.substring(0, ix) + p.charAt(ix);
        return percent + "%";
    }

    public static String formatNanosElapsed(long nanoseconds) {
        return Sys.formatNanosElapsed(nanoseconds, 0);
    }

    public static String formatNanosElapsed(long nanoseconds, int i) {
        long v;
        long d = 1000L;
        for (v = nanoseconds; v >= d; v /= d) {
            if (++i < 3) continue;
        }
        return v + seconds[i];
    }

    public static <T extends Serializable> T deepClone(T obj) {
        return (T)((Serializable)Serializer.DEFAULT.deserialize(Serializer.DEFAULT.serialize(obj)));
    }

    public static String fastCacheKey(String region, Object ... args) {
        if (region == null) {
            region = Reflects.stackClass(1).getSimpleName();
        }
        if (!Arrays.isEmpty((Object[])args)) {
            region = region + java.util.Arrays.hashCode(args);
        }
        return region;
    }

    public static String cacheKey(String region, Object ... args) {
        if (region == null) {
            region = Reflects.stackClass(1).getSimpleName();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(region);
        if (!Arrays.isEmpty((Object[])args)) {
            buf.append(":");
            if (args.length == 1 && args[0] instanceof String) {
                buf.append(args[0]);
            } else {
                buf.append(CodecUtil.hash64(args));
            }
        }
        return buf.toString();
    }

    public static <T> T readJsonValue(@NonNull Map<String, ?> json, String path, BiFunc<Object, ?> childSelect, boolean throwOnEmptyChild) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        Object child = json.get(path);
        if (child != null) {
            if (childSelect != null) {
                child = childSelect.apply(child);
            }
            return (T)child;
        }
        String[] paths = Strings.split(path, ".");
        if (paths.length == 0) {
            return null;
        }
        int last = paths.length - 1;
        Map tmp = json;
        for (int i = 0; i < last; ++i) {
            child = tmp.get(paths[i]);
            if (childSelect != null) {
                child = childSelect.apply(child);
            }
            if ((tmp = Extends.as(child, Map.class)) != null) continue;
            if (throwOnEmptyChild) {
                throw new InvalidException("Get empty sub object by path {}", paths[i]);
            }
            return null;
        }
        child = tmp.get(paths[last]);
        if (child != null && childSelect != null && !Reflects.isBasicType(child.getClass())) {
            child = childSelect.apply(child);
        }
        return (T)child;
    }

    public static <T> T fromJson(Object src, Type type) {
        String js = Sys.toJsonString(src);
        try {
            return (T)JSON.parseObject((String)js, (Type)type, (JSONReader.Feature[])JSON_READ_FLAGS);
        }
        catch (Exception e) {
            throw new InvalidException("Invalid json {}", js, e);
        }
    }

    public static JSONObject toJsonObject(Object src) {
        if (src instanceof JSONObject) {
            return (JSONObject)src;
        }
        if (src instanceof Map) {
            return new JSONObject((Map)src);
        }
        String js = Sys.toJsonString(src);
        try {
            return JSON.parseObject((String)js);
        }
        catch (Exception e) {
            throw new InvalidException("Invalid json {}", js, e);
        }
    }

    public static JSONArray toJsonArray(Object src) {
        if (src instanceof JSONArray) {
            return (JSONArray)src;
        }
        if (src instanceof List) {
            return new JSONArray((Collection)((List)src));
        }
        String js = Sys.toJsonString(src);
        try {
            return JSON.parseArray((String)js);
        }
        catch (Exception e) {
            throw new InvalidException("Invalid json {}", js, e);
        }
    }

    public static String toJsonString(Object src) {
        return Sys.toJsonString(src, null);
    }

    public static String toJsonString(Object src, ValueFilter valueFilter) {
        if (src == null) {
            return "{}";
        }
        String s = Extends.as(src, String.class);
        if (s != null) {
            return s;
        }
        try {
            return JSON.toJSONString((Object)JSON_WRITE_SKIP_TYPES.apply(null, null, src), (Filter)((Filter)Extends.ifNull(valueFilter, JSON_WRITE_SKIP_TYPES)), (JSONWriter.Feature[])JSON_WRITE_FLAGS);
        }
        catch (Throwable e) {
            Linq<Object> q = Linq.tryAsIterableType(src.getClass()) ? Linq.fromIterable(src) : Linq.from(src);
            Set<Class<?>> jsonSkipTypes = RxConfig.INSTANCE.jsonSkipTypes;
            jsonSkipTypes.addAll(q.where(x -> x != null && !Reflects.isBasicType(x.getClass())).select(Object::getClass).toSet());
            TraceHandler.INSTANCE.log("toJsonString {}", Linq.from(jsonSkipTypes).toJoinString(",", Class::getName), e);
            JSONObject json = new JSONObject();
            json.put((Object)"_input", (Object)src.toString());
            json.put((Object)"_error", (Object)e.getMessage());
            return json.toString();
        }
    }

    static Object jsonValueFilter(Object o, String k, Object v) {
        if (v != null) {
            if (v instanceof InetAddress) {
                return v.toString();
            }
            if (Linq.from(RxConfig.INSTANCE.jsonSkipTypes).any(t -> Reflects.isInstance(v, t))) {
                return v.getClass().getName();
            }
        }
        return v;
    }

    static {
        RxConfig conf = RxConfig.INSTANCE;
        log.info("RxMeta {} {}_{}_{} @ {} & {}\n{}", new Object[]{JAVA_VERSION, OS_NAME, OS_VERSION, OS_ARCH, new File("").getAbsolutePath(), Sockets.getLocalAddresses(false), JSON.toJSONString((Object)conf)});
        ObjectChangeTracker.DEFAULT.watch(conf, true).register(Sys.class).register(Tasks.class).register(TraceHandler.INSTANCE);
        IOC.register(Cache.class, IOC.get(conf.cache.mainCache));
    }

    public static class ThreadInfo {
        private final java.lang.management.ThreadInfo thread;
        private final long userNanos;
        private final long cpuNanos;

        public String toString() {
            StringBuilder buf = new StringBuilder(this.thread.toString());
            int i = buf.indexOf("\n");
            buf.insert(i, String.format(" BlockedTime=%s WaitedTime=%s UserTime=%s CpuTime=%s", Sys.formatNanosElapsed(this.thread.getBlockedTime(), 2), Sys.formatNanosElapsed(this.thread.getWaitedTime(), 2), Sys.formatNanosElapsed(this.userNanos), Sys.formatNanosElapsed(this.cpuNanos)));
            return buf.toString();
        }

        public java.lang.management.ThreadInfo getThread() {
            return this.thread;
        }

        public long getUserNanos() {
            return this.userNanos;
        }

        public long getCpuNanos() {
            return this.cpuNanos;
        }

        public ThreadInfo(java.lang.management.ThreadInfo thread, long userNanos, long cpuNanos) {
            this.thread = thread;
            this.userNanos = userNanos;
            this.cpuNanos = cpuNanos;
        }
    }

    public static class DiskInfo
    implements Serializable {
        private static final long serialVersionUID = -9137708658583628112L;
        private final String name;
        private final String path;
        private final long freeSpace;
        private final long totalSpace;
        private final boolean bootstrapDisk;

        public long getUsedSpace() {
            return this.totalSpace - this.freeSpace;
        }

        public int getUsedPercent() {
            return Numbers.toPercent((double)this.getUsedSpace() / (double)this.totalSpace);
        }

        public boolean hasDiskUsageWarning() {
            return this.getUsedPercent() > RxConfig.INSTANCE.disk.diskUsageWarningThreshold;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public long getFreeSpace() {
            return this.freeSpace;
        }

        public long getTotalSpace() {
            return this.totalSpace;
        }

        public boolean isBootstrapDisk() {
            return this.bootstrapDisk;
        }

        public DiskInfo(String name, String path, long freeSpace, long totalSpace, boolean bootstrapDisk) {
            this.name = name;
            this.path = path;
            this.freeSpace = freeSpace;
            this.totalSpace = totalSpace;
            this.bootstrapDisk = bootstrapDisk;
        }
    }

    public static class Info
    implements Serializable {
        private static final long serialVersionUID = -1263477025428108392L;
        private final int cpuThreads;
        private final double cpuLoad;
        private final int liveThreadCount;
        private final long freePhysicalMemory;
        private final long totalPhysicalMemory;
        private final Linq<DiskInfo> disks;

        public int getCpuLoadPercent() {
            return Numbers.toPercent(this.cpuLoad);
        }

        public long getUsedPhysicalMemory() {
            return this.totalPhysicalMemory - this.freePhysicalMemory;
        }

        public int getUsedPhysicalMemoryPercent() {
            return Numbers.toPercent((double)this.getUsedPhysicalMemory() / (double)this.totalPhysicalMemory);
        }

        public boolean hasCpuLoadWarning() {
            return this.getCpuLoadPercent() > RxConfig.INSTANCE.threadPool.cpuLoadWarningThreshold;
        }

        public boolean hasPhysicalMemoryUsageWarning() {
            return this.getUsedPhysicalMemoryPercent() > RxConfig.INSTANCE.cache.physicalMemoryUsageWarningThreshold;
        }

        public boolean hasDiskUsageWarning() {
            return this.disks.any(DiskInfo::hasDiskUsageWarning);
        }

        public DiskInfo getSummedDisk() {
            return this.disks.groupBy(p -> true, (p, x) -> new DiskInfo("SummedDisk", "/", (long)x.sum(y -> ((DiskInfo)y).freeSpace), (long)x.sum(y -> ((DiskInfo)y).totalSpace), false)).first();
        }

        public int getCpuThreads() {
            return this.cpuThreads;
        }

        public double getCpuLoad() {
            return this.cpuLoad;
        }

        public int getLiveThreadCount() {
            return this.liveThreadCount;
        }

        public long getFreePhysicalMemory() {
            return this.freePhysicalMemory;
        }

        public long getTotalPhysicalMemory() {
            return this.totalPhysicalMemory;
        }

        public Linq<DiskInfo> getDisks() {
            return this.disks;
        }

        public Info(int cpuThreads, double cpuLoad, int liveThreadCount, long freePhysicalMemory, long totalPhysicalMemory, Linq<DiskInfo> disks) {
            this.cpuThreads = cpuThreads;
            this.cpuLoad = cpuLoad;
            this.liveThreadCount = liveThreadCount;
            this.freePhysicalMemory = freePhysicalMemory;
            this.totalPhysicalMemory = totalPhysicalMemory;
            this.disks = disks;
        }
    }
}

