/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongUnaryOperator;
import lombok.NonNull;
import org.rx.bean.$;
import org.rx.bean.FlagsEnum;
import org.rx.core.Constants;
import org.rx.core.RxConfig;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.core.ThreadPool;
import org.rx.core.TimeoutFlag;
import org.rx.core.TimeoutFuture;
import org.rx.util.function.Action;
import org.rx.util.function.Func;

public class WheelTimer
extends AbstractExecutorService
implements ScheduledExecutorService {
    static final long TICK_DURATION = 100L;
    static final Map<Object, TimeoutFuture> holder = new ConcurrentHashMap<Object, TimeoutFuture>();
    final ExecutorService executor;
    final HashedWheelTimer timer = new HashedWheelTimer(ThreadPool.newThreadFactory("TIMER"), 100L, TimeUnit.MILLISECONDS);
    final EmptyTimeout nonTask = new EmptyTimeout();
    static final String M_0 = "isCancelled";
    static final String M_1 = "cancel";
    boolean shutdown;

    public TimeoutFuture<?> setTimeout(Action fn, LongUnaryOperator nextDelay) {
        return this.setTimeout(fn, nextDelay, null, null);
    }

    public TimeoutFuture<?> setTimeout(@NonNull Action fn, LongUnaryOperator nextDelay, Object taskId, FlagsEnum<TimeoutFlag> flags) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        return this.setTimeout(new Task(fn.toFunc(), flags, taskId, nextDelay));
    }

    public <T> TimeoutFuture<T> setTimeout(Func<T> fn, LongUnaryOperator nextDelay) {
        return this.setTimeout(fn, nextDelay, null, null);
    }

    public <T> TimeoutFuture<T> setTimeout(@NonNull Func<T> fn, LongUnaryOperator nextDelay, Object taskId, FlagsEnum<TimeoutFlag> flags) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        return this.setTimeout(new Task<T>(fn, flags, taskId, nextDelay));
    }

    public TimeoutFuture<?> setTimeout(Action fn, long delay) {
        return this.setTimeout(fn, delay, null, null);
    }

    public TimeoutFuture<?> setTimeout(@NonNull Action fn, long delay, Object taskId, FlagsEnum<TimeoutFlag> flags) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        Task task = new Task(fn.toFunc(), flags, taskId, null);
        task.delay = delay;
        return this.setTimeout(task);
    }

    public <T> TimeoutFuture<T> setTimeout(Func<T> fn, long delay) {
        return this.setTimeout(fn, delay, null, null);
    }

    public <T> TimeoutFuture<T> setTimeout(@NonNull Func<T> fn, long delay, Object taskId, FlagsEnum<TimeoutFlag> flags) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        Task<T> task = new Task<T>(fn, flags, taskId, null);
        task.delay = delay;
        return this.setTimeout(task);
    }

    private <T> TimeoutFuture<T> setTimeout(Task<T> task) {
        TimeoutFuture ot;
        if (task.id == null) {
            this.newTimeout(task, 0L, (Timer)this.timer);
            return task;
        }
        FlagsEnum<TimeoutFlag> flags = task.flags;
        if (flags.has(new TimeoutFlag[]{TimeoutFlag.SINGLE}) && (ot = holder.get(task.id)) != null) {
            return ot;
        }
        ot = holder.put(task.id, task);
        this.newTimeout(task, 0L, (Timer)this.timer);
        if (flags.has(new TimeoutFlag[]{TimeoutFlag.REPLACE}) && ot != null) {
            ot.cancel();
        }
        return task;
    }

    private <T> void newTimeout(Task<T> task, long initDelay, Timer timer) {
        if (task.nextDelayFn != null) {
            task.delay = task.nextDelayFn.applyAsLong(initDelay);
        }
        task.timeout = task.delay == -1L ? this.nonTask : timer.newTimeout(task, task.delay, TimeUnit.MILLISECONDS);
        task.expiredTime = System.currentTimeMillis() + task.delay;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.setTimeout(command::run, TimeUnit.MILLISECONDS.convert(delay, unit));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.setTimeout(callable::call, TimeUnit.MILLISECONDS.convert(delay, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        long initDelay = TimeUnit.MILLISECONDS.convert(initialDelay, unit);
        Task t = (Task)this.setTimeout(command::run, initDelay);
        AtomicBoolean cancel = new AtomicBoolean();
        ScheduledFuture future = (ScheduledFuture)Sys.proxy(ScheduledFuture.class, (m, p) -> {
            if (Strings.hashEquals(m.getName(), M_0)) {
                return cancel.get();
            }
            if (Strings.hashEquals(m.getName(), M_1)) {
                cancel.set(true);
            }
            return p.fastInvoke(t);
        });
        long nextDelay = initDelay + period;
        long periodMillis = TimeUnit.MILLISECONDS.convert(period, unit);
        this.nextFixedRate(future, t, nextDelay, command, periodMillis);
        return future;
    }

    void nextFixedRate(ScheduledFuture<?> proxy, Task<?> future, long nextDelay, Runnable command, long period) {
        $ t = $.$();
        t.v = (Task)this.setTimeout(() -> {
            if (!proxy.isCancelled()) {
                this.nextFixedRate(proxy, future, period - 100L, command, period);
                Task p = (Task)t.v;
                future.timeout = p.timeout;
                future.future = p.future;
                future.delay = p.delay;
                future.expiredTime = p.expiredTime;
            }
            command.run();
        }, nextDelay);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.setTimeout(command::run, (long d) -> d == 0L ? initialDelay : TimeUnit.MILLISECONDS.convert(period, unit), null, Constants.TIMER_PERIOD_FLAG);
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public void shutdown() {
        this.timer.stop();
        this.shutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return this.shutdown;
    }

    protected WheelTimer(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    class EmptyTimeout
    implements Timeout,
    TimerTask {
        EmptyTimeout() {
        }

        public Timer timer() {
            return WheelTimer.this.timer;
        }

        public TimerTask task() {
            return this;
        }

        public boolean isExpired() {
            return true;
        }

        public boolean isCancelled() {
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public void run(Timeout timeout) throws Exception {
        }
    }

    class Task<T>
    implements TimerTask,
    TimeoutFuture<T> {
        final Func<T> fn;
        final FlagsEnum<TimeoutFlag> flags;
        final Object id;
        final LongUnaryOperator nextDelayFn;
        final String traceId;
        long delay;
        long expiredTime;
        volatile Timeout timeout;
        volatile Future<T> future;
        long p0;
        long p1;
        int p2;

        Task(Func<T> fn, FlagsEnum<TimeoutFlag> flags, Object id, LongUnaryOperator nextDelayFn) {
            if (flags == null) {
                flags = TimeoutFlag.NONE.flags();
            }
            if (RxConfig.INSTANCE.threadPool.traceName != null) {
                flags.add(new TimeoutFlag[]{TimeoutFlag.THREAD_TRACE});
            }
            this.fn = fn;
            this.flags = flags;
            this.id = id;
            this.nextDelayFn = nextDelayFn;
            this.traceId = ThreadPool.CTX_TRACE_ID.get();
        }

        public synchronized void run(Timeout timeout) throws Exception {
            boolean traceFlag = this.flags.has(new TimeoutFlag[]{TimeoutFlag.THREAD_TRACE});
            if (traceFlag) {
                ThreadPool.startTrace(this.traceId);
            }
            try {
                this.future = WheelTimer.this.executor.submit(() -> {
                    boolean doContinue = this.flags.has(new TimeoutFlag[]{TimeoutFlag.PERIOD});
                    try {
                        T t = this.fn.get();
                        return t;
                    }
                    finally {
                        if (ThreadPool.asyncContinueFlag(doContinue)) {
                            WheelTimer.this.newTimeout(this, this.delay, timeout.timer());
                        } else if (this.id != null) {
                            holder.remove(this.id);
                        }
                    }
                });
            }
            finally {
                if (traceFlag) {
                    ThreadPool.endTrace();
                }
            }
            this.notifyAll();
        }

        public String toString() {
            String hc = this.id != null ? this.id.toString() : Integer.toHexString(this.hashCode());
            return String.format("WheelTask-%s[%s]", hc, this.flags.getValue());
        }

        public Timer timer() {
            return this.timeout.timer();
        }

        public TimerTask task() {
            return this.timeout.task();
        }

        public boolean isExpired() {
            return this.timeout.isExpired();
        }

        @Override
        public boolean isCancelled() {
            return this.timeout.isCancelled();
        }

        public boolean cancel() {
            return this.cancel(true);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.future != null) {
                this.future.cancel(mayInterruptIfRunning);
            }
            if (this.timeout != null) {
                return this.timeout.cancel();
            }
            return true;
        }

        @Override
        public boolean isDone() {
            return this.future != null && this.future.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws InterruptedException, ExecutionException {
            Task task = this;
            synchronized (task) {
                if (this.future == null) {
                    this.wait();
                }
            }
            if (this.future == null) {
                throw new InterruptedException();
            }
            return this.future.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Task task = this;
            synchronized (task) {
                if (this.future == null) {
                    this.wait(TimeUnit.MILLISECONDS.convert(timeout, unit));
                }
            }
            if (this.future == null) {
                throw new TimeoutException();
            }
            return this.future.get(timeout, unit);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expiredTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            if (!(o instanceof Task)) {
                return 0;
            }
            long otherExpiredTime = ((Task)o).expiredTime;
            return Long.compare(this.expiredTime, otherExpiredTime);
        }
    }
}

