/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.rx.annotation.ErrorCode;
import org.rx.core.Arrays;
import org.rx.core.Delegate;
import org.rx.core.EventArgs;
import org.rx.core.EventPublisher;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.core.StringBuilder;
import org.rx.core.Strings;
import org.rx.exception.ApplicationException;
import org.rx.exception.InvalidException;
import org.rx.io.FileStream;
import org.rx.io.FileWatcher;
import org.rx.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YamlConfiguration
implements EventPublisher<YamlConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(YamlConfiguration.class);
    static final String APP_CONFIG_FILE = "application.yml";
    public static final YamlConfiguration RX_CONF = new YamlConfiguration("rx.yml", "application.yml");
    public final Delegate<YamlConfiguration, ChangedEventArgs> onChanged = Delegate.create();
    final String[] fileNames;
    final Map<String, Object> yaml;
    String outputFile;
    FileWatcher watcher;

    public static Map<String, Object> loadYaml(String ... fileNames) {
        return YamlConfiguration.loadYaml(Linq.from(fileNames).selectMany(p -> {
            File file = new File((String)p);
            if (file.exists()) {
                return Arrays.toList(new FileStream(file).getReader());
            }
            Linq<InputStream> resources = Reflects.getResources(p);
            if (resources.any()) {
                return resources.reverse();
            }
            return resources;
        }).toList());
    }

    public static Map<String, Object> loadYaml(List<InputStream> streams) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (CollectionUtils.isEmpty(streams)) {
            return result;
        }
        Yaml yaml = new Yaml();
        for (Object data : Linq.from(streams).selectMany(arg_0 -> ((Yaml)yaml).loadAll(arg_0))) {
            Map sub = (Map)data;
            YamlConfiguration.fill(sub, result);
        }
        return result;
    }

    private static void fill(Map<String, Object> child, Map<String, Object> parent) {
        if (child == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : child.entrySet()) {
            Map next = Extends.as(entry.getValue(), Map.class);
            if (next == null) {
                parent.put(entry.getKey(), entry.getValue());
                continue;
            }
            Map nextAll = (Map)parent.get(entry.getKey());
            if (nextAll == null) {
                parent.put(entry.getKey(), next);
                continue;
            }
            YamlConfiguration.fill(next, nextAll);
        }
    }

    public YamlConfiguration(String ... fileNames) {
        if (fileNames == null) {
            throw new NullPointerException("fileNames is marked non-null but is null");
        }
        this.fileNames = fileNames;
        this.yaml = YamlConfiguration.loadYaml(fileNames);
    }

    public YamlConfiguration enableWatch() {
        if (this.fileNames.length == 0) {
            throw new InvalidException("Empty loaded fileNames", new Object[0]);
        }
        return this.enableWatch(this.fileNames[this.fileNames.length - 1]);
    }

    public synchronized YamlConfiguration enableWatch(@NonNull String outputFile) {
        if (outputFile == null) {
            throw new NullPointerException("outputFile is marked non-null but is null");
        }
        if (this.watcher != null) {
            throw new InvalidException("Already watched", new Object[0]);
        }
        if (!this.yaml.isEmpty()) {
            try (FileStream fs = new FileStream(outputFile);){
                fs.setPosition(0L);
                fs.writeString(new Yaml().dumpAsMap(this.yaml));
                fs.flip();
            }
        }
        this.outputFile = outputFile;
        this.watcher = new FileWatcher(Files.getFullPath((String)this.outputFile), p -> p.toString().equals(this.outputFile));
        this.watcher.onChanged.combine((s, e) -> {
            String filePath = e.getPath().toString();
            log.info("Config changing {} {} -> {}", new Object[]{e.isCreate(), filePath, this.yaml});
            YamlConfiguration yamlConfiguration = this;
            synchronized (yamlConfiguration) {
                this.yaml.clear();
                if (!e.isDelete()) {
                    this.write(filePath);
                }
            }
            log.info("Config changed {} {} -> {}", new Object[]{e.isCreate(), filePath, this.yaml});
            this.raiseEvent(this.onChanged, new ChangedEventArgs(filePath));
        });
        return this;
    }

    public synchronized void raiseChange() {
        this.raiseChange(this.outputFile);
    }

    public synchronized void raiseChange(String filePath) {
        if (filePath == null) {
            return;
        }
        File f = new File(filePath);
        if (!f.exists()) {
            log.warn("File not found {}", (Object)filePath);
            return;
        }
        this.write(filePath);
        log.info("Config changed {} -> {}", (Object)filePath, this.yaml);
        this.raiseEvent(this.onChanged, new ChangedEventArgs(filePath));
    }

    public synchronized YamlConfiguration write(@NonNull String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        Object[] clone = (String[])this.fileNames.clone();
        this.yaml.putAll(YamlConfiguration.loadYaml((String[])Arrays.add((Object[])clone, (Object)fileName)));
        return this;
    }

    public <T> T read(String key, T defaultVal) {
        Object val = this.readAs(key, Object.class);
        return (T)(val != null ? val : defaultVal);
    }

    public <T> T readAs(Class<T> type) {
        return this.readAs(null, type, false);
    }

    public <T> T readAs(String key, Class<T> type) {
        return this.readAs(key, type, false);
    }

    @ErrorCode.ErrorCodes(value={@ErrorCode(value="keyError"), @ErrorCode(value="partialKeyError")})
    public synchronized <T> T readAs(String key, Class<T> type, boolean throwOnEmpty) {
        Map tmp = this.yaml;
        if (key == null) {
            return this.convert(tmp, type);
        }
        Object val = tmp.get(key);
        if (val != null) {
            return this.convert(val, type);
        }
        StringBuilder buf = new StringBuilder();
        String[] splits = Strings.split(key, ".");
        int c = splits.length - 1;
        for (int i = 0; i <= c; ++i) {
            String k;
            if (buf.length() > 0) {
                buf.append(".");
            }
            if ((val = tmp.get(k = buf.append(splits[i]).toString())) == null) continue;
            if (i == c) {
                return this.convert(val, type);
            }
            tmp = Extends.as(val, Map.class);
            if (tmp == null) {
                throw new ApplicationException("partialKeyError", Extends.values(k, type));
            }
            buf.setLength(0);
        }
        if (throwOnEmpty) {
            throw new ApplicationException("keyError", Extends.values(key, type));
        }
        return null;
    }

    <T> T convert(Object p, Class<T> type) {
        if (type == null) {
            return null;
        }
        Map map = Extends.as(p, Map.class);
        if (map != null) {
            if (type.equals(Map.class)) {
                return (T)map;
            }
            return (T)JSON.parseObject((String)JSON.toJSONString((Object)map), type, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.SupportClassForName});
        }
        return Reflects.changeType(p, type);
    }

    public Map<String, Object> getYaml() {
        return this.yaml;
    }

    public static class ChangedEventArgs
    extends EventArgs {
        private static final long serialVersionUID = -1217316266335592369L;
        final String filePath;

        public ChangedEventArgs(String filePath) {
            this.filePath = filePath;
        }

        public String getFilePath() {
            return this.filePath;
        }
    }
}

