/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core.cache;

import com.github.benmanes.caffeine.cache.Expiry;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.rx.core.CachePolicy;
import org.rx.core.RxConfig;

class CaffeineExpiry
implements Expiry<Object, Object> {
    static final long DEFAULT_SLIDING_NANOS = TimeUnit.SECONDS.toNanos(RxConfig.INSTANCE.getCache().getSlidingSeconds());

    static long computeNanos(Object value, long currentDuration) {
        if (value instanceof CachePolicy) {
            CachePolicy policy = (CachePolicy)value;
            return TimeUnit.MILLISECONDS.toNanos(policy.ttl());
        }
        return DEFAULT_SLIDING_NANOS;
    }

    public long expireAfterCreate(@NonNull Object key, @NonNull Object value, long currentTime) {
        return CaffeineExpiry.computeNanos(value, -1L);
    }

    public long expireAfterUpdate(@NonNull Object key, @NonNull Object value, long currentTime, @NonNegative long currentDuration) {
        return CaffeineExpiry.computeNanos(value, currentDuration);
    }

    public long expireAfterRead(@NonNull Object key, @NonNull Object value, long currentTime, @NonNegative long currentDuration) {
        return CaffeineExpiry.computeNanos(value, currentDuration);
    }
}

