/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core.cache;

import com.github.benmanes.caffeine.cache.RemovalCause;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rx.core.Cache;
import org.rx.core.CachePolicy;
import org.rx.core.Delegate;
import org.rx.core.EventPublisher;
import org.rx.core.IOC;
import org.rx.core.Linq;
import org.rx.core.NEventArgs;
import org.rx.core.cache.DiskCacheItem;
import org.rx.core.cache.MemoryCache;
import org.rx.io.KeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCache<TK, TV>
implements Cache<TK, TV>,
EventPublisher<DiskCache<TK, TV>> {
    private static final Logger log = LoggerFactory.getLogger(DiskCache.class);
    public final Delegate<DiskCache<TK, TV>, NEventArgs<Map.Entry<TK, TV>>> onExpired = Delegate.create();
    final Cache<TK, DiskCacheItem<TV>> cache = new MemoryCache<TK, DiskCacheItem<TV>>(b -> b.maximumSize((long)cacheSize).removalListener(this::onRemoval));
    final KeyValueStore<TK, DiskCacheItem<TV>> store = KeyValueStore.getInstance(Object.class, DiskCacheItem.class);

    public DiskCache() {
        this(1000);
    }

    public DiskCache(int cacheSize) {
    }

    void onRemoval(@Nullable TK key, DiskCacheItem<TV> item, @NonNull RemovalCause removalCause) {
        if (item == null) {
            return;
        }
        log.info("onRemoval {}[{}] -> {}", new Object[]{key, item.getExpiration(), removalCause});
        if (item.value == null || removalCause == RemovalCause.REPLACED || removalCause == RemovalCause.EXPLICIT) {
            return;
        }
        if (item.isExpired()) {
            this.raiseEvent(this.onExpired, new NEventArgs(new AbstractMap.SimpleEntry(key, item.value)));
            return;
        }
        if (!(key instanceof Serializable) || !(item.value instanceof Serializable)) {
            return;
        }
        this.store.fastPut(key, item);
        log.info("onRemoval copy to store {} -> {}ms", key, (Object)(item.getExpiration() - System.currentTimeMillis()));
    }

    @Override
    public int size() {
        return this.cache.size() + this.store.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cache.containsValue(value) || this.store.containsValue(value);
    }

    @Override
    public TV get(Object key) {
        boolean doRenew = false;
        DiskCacheItem<TV> item = (DiskCacheItem<TV>)this.cache.get(key);
        if (item == null) {
            item = this.store.get(key);
            doRenew = true;
        }
        return this.unwrap(key, item, doRenew);
    }

    private TV unwrap(TK key, DiskCacheItem<TV> item, boolean doRenew) {
        if (item == null) {
            return null;
        }
        if (item.isExpired()) {
            this.remove(key);
            if (this.onExpired == null) {
                return null;
            }
            NEventArgs args = new NEventArgs(new AbstractMap.SimpleEntry(key, item.value));
            this.raiseEvent(this.onExpired, args);
            return (TV)((Map.Entry)args.getValue()).getValue();
        }
        if (doRenew && item.slidingRenew()) {
            this.cache.put(key, item);
        }
        return item.value;
    }

    @Override
    public TV put(TK key, TV value, CachePolicy policy) {
        DiskCacheItem<TV> old = this.cache.put(key, new DiskCacheItem<TV>(value, policy));
        return this.unwrap(key, old, false);
    }

    @Override
    public TV remove(Object key) {
        DiskCacheItem<TV> remove = (DiskCacheItem<TV>)this.cache.remove(key);
        if (remove == null) {
            remove = this.store.remove(key);
        }
        return remove == null ? null : (TV)remove.value;
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.store.clear();
    }

    @Override
    public Set<TK> keySet() {
        return this.cache.keySet();
    }

    @Override
    public Collection<TV> values() {
        return Linq.from(this.keySet()).select(k -> this.get(k)).where(Objects::nonNull).toList();
    }

    @Override
    public Set<Map.Entry<TK, TV>> entrySet() {
        return Linq.from(this.keySet()).select(k -> {
            Object v = this.get(k);
            return v == null ? null : new AbstractMap.SimpleEntry(k, v);
        }).where(Objects::nonNull).toSet();
    }

    static {
        IOC.register(DiskCache.class, new DiskCache());
    }
}

