/*
 * Decompiled with CFR 0.152.
 */
package org.rx.core.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.rx.core.Cache;
import org.rx.core.CachePolicy;
import org.rx.core.Extends;
import org.rx.core.IOC;
import org.rx.core.RxConfig;
import org.rx.core.Tasks;
import org.rx.core.cache.CaffeineExpiry;
import org.rx.util.function.BiAction;

public class MemoryCache<TK, TV>
implements Cache<TK, TV> {
    final com.github.benmanes.caffeine.cache.Cache<TK, TV> cache;
    final Policy.VarExpiration<TK, TV> expireVariably;

    public static Caffeine<Object, Object> weightBuilder(Caffeine<Object, Object> b, float memoryPercent, int entryBytes) {
        Extends.require(Float.valueOf(memoryPercent), 0.0f < memoryPercent && memoryPercent <= 1.0f);
        return MemoryCache.weightBuilder(b, (long)((float)Runtime.getRuntime().maxMemory() * memoryPercent), entryBytes);
    }

    public static Caffeine<Object, Object> weightBuilder(Caffeine<Object, Object> b, long maxBytes, int entryBytes) {
        return b.maximumWeight(maxBytes).weigher((k, v) -> entryBytes);
    }

    static Caffeine<Object, Object> rootBuilder() {
        return Caffeine.newBuilder().executor((Executor)Tasks.executor()).scheduler(Scheduler.forScheduledExecutorService((ScheduledExecutorService)Tasks.timer()));
    }

    public MemoryCache() {
        this(b -> b.maximumSize((long)RxConfig.INSTANCE.getCache().getMaxItemSize()));
    }

    public MemoryCache(BiAction<Caffeine<Object, Object>> onBuild) {
        Caffeine builder = MemoryCache.rootBuilder().expireAfter((Expiry)new CaffeineExpiry());
        if (onBuild != null) {
            onBuild.invoke((Caffeine<Object, Object>)builder);
        }
        this.cache = builder.build();
        this.expireVariably = (Policy.VarExpiration)this.cache.policy().expireVariably().get();
    }

    public void setExpire(TK key, long millis) {
        this.expireVariably.setExpiresAfter(key, millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public int size() {
        return (int)this.cache.estimatedSize();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.getIfPresent(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cache.asMap().containsValue(value);
    }

    @Override
    public TV get(Object key) {
        return (TV)this.cache.getIfPresent(key);
    }

    @Override
    public TV put(TK key, TV value, CachePolicy policy) {
        TV oldValue = this.cache.asMap().put(key, value);
        if (policy != null) {
            this.setExpire(key, TimeUnit.NANOSECONDS.toMillis(CaffeineExpiry.computeNanos(value, -1L)));
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends TK, ? extends TV> m) {
        this.cache.putAll(m);
    }

    @Override
    public TV putIfAbsent(TK key, TV value) {
        return this.cache.asMap().putIfAbsent(key, value);
    }

    @Override
    public TV replace(TK key, TV value) {
        return this.cache.asMap().replace(key, value);
    }

    @Override
    public boolean replace(TK key, TV oldValue, TV newValue) {
        return this.cache.asMap().replace(key, oldValue, newValue);
    }

    @Override
    public TV remove(Object key) {
        return (TV)this.cache.asMap().remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.cache.asMap().remove(key, value);
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public Set<TK> keySet() {
        return this.cache.asMap().keySet();
    }

    @Override
    public Collection<TV> values() {
        return this.cache.asMap().values();
    }

    @Override
    public Set<Map.Entry<TK, TV>> entrySet() {
        return this.cache.asMap().entrySet();
    }

    static {
        IOC.register(MemoryCache.class, new MemoryCache());
    }
}

