/*
 * Decompiled with CFR 0.152.
 */
package org.rx.exception;

import lombok.NonNull;
import org.rx.core.Arrays;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.exception.InvalidException;
import org.rx.exception.YamlCodeHandler;
import org.rx.util.Snowflake;
import org.slf4j.helpers.MessageFormatter;

public class ApplicationException
extends InvalidException {
    private static final long serialVersionUID = -2150583552731782944L;
    public static final String DEFAULT_MESSAGE = "\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002";
    private final long id = Snowflake.DEFAULT.nextId();
    private final Object errorCode;
    private final Object[] codeValues;
    private String friendlyMessage;
    private final Linq<StackTraceElement> stacks;

    public static String getMessage(Throwable e) {
        if (e == null) {
            return DEFAULT_MESSAGE;
        }
        ApplicationException applicationException = Extends.as(e, ApplicationException.class);
        if (applicationException == null) {
            return Extends.ifNull(e.getMessage(), DEFAULT_MESSAGE);
        }
        return applicationException.getFriendlyMessage();
    }

    public String getMessage() {
        return Extends.ifNull(this.friendlyMessage, String.format("%s %s", this.id, super.getMessage()));
    }

    public String getFriendlyMessage() {
        return Extends.ifNull(this.friendlyMessage, DEFAULT_MESSAGE);
    }

    public ApplicationException(Object[] codeValues) {
        this(codeValues, null);
    }

    public ApplicationException(Object[] codeValues, Throwable cause) {
        this((Object)"", codeValues, cause);
    }

    public <T extends Enum<T>> ApplicationException(T errorCode, Object ... codeValues) {
        this(errorCode, MessageFormatter.getThrowableCandidate((Object[])codeValues) != null ? MessageFormatter.trimmedCopy((Object[])codeValues) : codeValues, MessageFormatter.getThrowableCandidate((Object[])codeValues));
    }

    public ApplicationException(String errorCode, Object ... codeValues) {
        this((Object)errorCode, MessageFormatter.getThrowableCandidate((Object[])codeValues) != null ? MessageFormatter.trimmedCopy((Object[])codeValues) : codeValues, MessageFormatter.getThrowableCandidate((Object[])codeValues));
    }

    protected ApplicationException(@NonNull Object errorCode, Object[] codeValues, Throwable cause) {
        super(cause != null ? cause.getMessage() : null, cause);
        if (errorCode == null) {
            throw new NullPointerException("errorCode is marked non-null but is null");
        }
        Extends.require(errorCode, Linq.from(Enum.class, String.class).any(p -> Reflects.isInstance(errorCode, p)));
        this.errorCode = errorCode;
        if (codeValues == null) {
            codeValues = Arrays.EMPTY_OBJECT_ARRAY;
        }
        this.codeValues = codeValues;
        this.stacks = errorCode instanceof CharSequence ? Reflects.stackTrace(8) : null;
        YamlCodeHandler.INSTANCE.handle(this);
    }

    public long getId() {
        return this.id;
    }

    public Object getErrorCode() {
        return this.errorCode;
    }

    public Object[] getCodeValues() {
        return this.codeValues;
    }

    public Linq<StackTraceElement> getStacks() {
        return this.stacks;
    }

    public void setFriendlyMessage(String friendlyMessage) {
        this.friendlyMessage = friendlyMessage;
    }
}

