/*
 * Decompiled with CFR 0.152.
 */
package org.rx.exception;

import java.io.Serializable;
import java.sql.Time;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.rx.annotation.DbColumn;
import org.rx.annotation.Subscribe;
import org.rx.bean.DateTime;
import org.rx.codec.CodecUtil;
import org.rx.core.Arrays;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.ObjectChangeTracker;
import org.rx.core.ObjectChangedEvent;
import org.rx.core.Reflects;
import org.rx.core.RxConfig;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.exception.ExceptionLevel;
import org.rx.exception.InvalidException;
import org.rx.io.EntityDatabase;
import org.rx.io.EntityQueryLambda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class TraceHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(TraceHandler.class);
    public static final TraceHandler INSTANCE = new TraceHandler();
    ScheduledFuture<?> future;

    public static Object[] getMessageCandidate(Object ... args) {
        int lastIndex;
        Object last;
        if (args != null && args.length != 0 && (last = args[lastIndex = args.length - 1]) instanceof Throwable) {
            if (lastIndex == 0) {
                return Arrays.EMPTY_OBJECT_ARRAY;
            }
            return Linq.from(args).take(lastIndex).toArray();
        }
        return args;
    }

    private TraceHandler() {
        try {
            Thread.setDefaultUncaughtExceptionHandler(this);
            EntityDatabase db = EntityDatabase.DEFAULT;
            db.createMapping(ErrorEntity.class, MethodEntity.class, MetricsEntity.class);
        }
        catch (Throwable e) {
            log.error("RxMeta init error", e);
        }
    }

    @Subscribe(topicClass=RxConfig.class)
    void onChanged(ObjectChangedEvent event) {
        ObjectChangeTracker.ChangedValue changedValue = event.getChangedMap().get(RxConfig.ConfigNames.getWithoutPrefix("app.traceKeepDays"));
        if (changedValue == null) {
            return;
        }
        int keepDays = (Integer)changedValue.newValue();
        log.info("RxMeta {} changed {}", (Object)"app.traceKeepDays", (Object)changedValue);
        if (keepDays > 0) {
            if (this.future == null) {
                this.future = Tasks.scheduleDaily(() -> {
                    EntityDatabase db = EntityDatabase.DEFAULT;
                    DateTime d = DateTime.now().addDays(-keepDays - 1);
                    db.delete(new EntityQueryLambda<ErrorEntity>(ErrorEntity.class).lt(ErrorEntity::getModifyTime, d));
                    db.delete(new EntityQueryLambda<MethodEntity>(MethodEntity.class).lt(MethodEntity::getModifyTime, d));
                    db.compact();
                }, Time.valueOf("3:00:00"));
            }
        } else if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    public void log(String format, Object ... args) {
        try {
            FormattingTuple tuple = MessageFormatter.arrayFormat((String)format, (Object[])args);
            if (tuple.getThrowable() == null) {
                log.warn(format + "[NoThrowableCandidate]", args);
                return;
            }
            log.error(format, args);
            this.saveTrace(Thread.currentThread(), tuple.getMessage(), tuple.getThrowable());
        }
        catch (Throwable ie) {
            ie.printStackTrace();
        }
    }

    public void log(Throwable e) {
        this.uncaughtException(Thread.currentThread(), e);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            log.error("Thread[{}] uncaught", (Object)t.getId(), (Object)e);
            this.saveTrace(t, null, e);
        }
        catch (Throwable ie) {
            ie.printStackTrace();
        }
    }

    public void saveTrace(Thread t, String msg, Throwable e) {
        RxConfig conf = RxConfig.INSTANCE;
        if (conf.getTraceKeepDays() <= 0) {
            return;
        }
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
        long pk = CodecUtil.hash64(stackTrace);
        Tasks.nextPool().runSerial(() -> {
            EntityDatabase db = EntityDatabase.DEFAULT;
            db.begin();
            try {
                Queue<String> queue;
                boolean doInsert;
                ErrorEntity entity = db.findById(ErrorEntity.class, Long.valueOf(pk));
                boolean bl = doInsert = entity == null;
                if (doInsert) {
                    entity = new ErrorEntity();
                    entity.setId(pk);
                    InvalidException invalidException = Extends.as(e, InvalidException.class);
                    ExceptionLevel level = invalidException != null && invalidException.getLevel() != null ? invalidException.getLevel() : ExceptionLevel.SYSTEM;
                    entity.setLevel(level);
                    entity.setMessages(new ConcurrentLinkedQueue<String>());
                    entity.setStackTrace(stackTrace);
                }
                if ((queue = entity.getMessages()).size() > conf.getTraceErrorMessageSize()) {
                    queue.poll();
                }
                queue.offer(String.format("%s\t%s", DateTime.now().toDateTimeString(), msg));
                ++entity.occurCount;
                entity.setAppName(conf.getId());
                entity.setThreadName(t.getName());
                entity.setModifyTime(DateTime.now());
                db.save(entity, doInsert);
                db.commit();
            }
            catch (Throwable ex) {
                log.error("dbTrace", ex);
                db.rollback();
            }
            return null;
        }, pk);
    }

    public List<ErrorEntity> queryTraces(Boolean newest, ExceptionLevel level, Integer limit) {
        if (newest == null) {
            newest = Boolean.FALSE;
        }
        if (limit == null) {
            limit = 20;
        }
        EntityQueryLambda<ErrorEntity> q = new EntityQueryLambda<ErrorEntity>(ErrorEntity.class).limit(limit);
        if (newest.booleanValue()) {
            q.orderByDescending(ErrorEntity::getModifyTime);
        } else {
            q.orderByDescending(ErrorEntity::getOccurCount);
        }
        if (level != null) {
            q.eq(ErrorEntity::getLevel, level);
        }
        EntityDatabase db = EntityDatabase.DEFAULT;
        return db.findBy(q);
    }

    public void saveTrace(Class<?> declaringType, String methodName, Object[] parameters, long elapsedMicros) {
        RxConfig conf = RxConfig.INSTANCE;
        if (conf.getTraceKeepDays() <= 0 || elapsedMicros < conf.getTraceSlowElapsedMicros()) {
            return;
        }
        String fullName = String.format("%s.%s(%s)", declaringType.getName(), methodName, parameters == null ? 0 : parameters.length);
        long pk = CodecUtil.hash64(fullName);
        Tasks.nextPool().runSerial(() -> {
            EntityDatabase db = EntityDatabase.DEFAULT;
            db.begin();
            try {
                boolean doInsert;
                MethodEntity entity = db.findById(MethodEntity.class, Long.valueOf(pk));
                boolean bl = doInsert = entity == null;
                if (doInsert) {
                    entity = new MethodEntity();
                    entity.setId(pk);
                    entity.setMethodName(fullName);
                }
                if (parameters != null) {
                    entity.setParameters(Sys.toJsonString(parameters));
                }
                entity.elapsedMicros = Math.max(entity.elapsedMicros, elapsedMicros);
                ++entity.occurCount;
                entity.setAppName(conf.getId());
                entity.setThreadName(Thread.currentThread().getName());
                entity.setModifyTime(DateTime.now());
                db.save(entity, doInsert);
                db.commit();
            }
            catch (Throwable e) {
                log.error("dbTrace", e);
                db.rollback();
            }
            return null;
        }, pk);
    }

    public List<MethodEntity> queryTraces(Boolean methodOccurMost, String methodNamePrefix, Integer limit) {
        if (methodOccurMost == null) {
            methodOccurMost = Boolean.FALSE;
        }
        if (limit == null) {
            limit = 20;
        }
        EntityQueryLambda<MethodEntity> q = new EntityQueryLambda<MethodEntity>(MethodEntity.class).limit(limit);
        if (methodOccurMost.booleanValue()) {
            q.orderByDescending(MethodEntity::getOccurCount);
        } else {
            q.orderByDescending(MethodEntity::getElapsedMicros);
        }
        if (methodNamePrefix != null) {
            q.like(MethodEntity::getMethodName, String.format("%s%%", methodNamePrefix));
        }
        EntityDatabase db = EntityDatabase.DEFAULT;
        return db.findBy(q);
    }

    public void saveMetric(String name, String message) {
        log.info("saveMetric {} {}", (Object)name, (Object)message);
        String stackTrace = Reflects.getStackTrace(Thread.currentThread());
        Tasks.nextPool().runSerial(() -> {
            EntityDatabase db = EntityDatabase.DEFAULT;
            db.begin();
            try {
                boolean doInsert;
                MetricsEntity entity = db.findById(MetricsEntity.class, (Serializable)((Object)name));
                boolean bl = doInsert = entity == null;
                if (doInsert) {
                    entity = new MetricsEntity();
                    entity.setName(name);
                }
                entity.setMessage(message);
                entity.setStackTrace(stackTrace);
                ++entity.occurCount;
                entity.setModifyTime(DateTime.now());
                db.save(entity, doInsert);
                db.commit();
            }
            catch (Throwable e) {
                log.error("dbTrace", e);
                db.rollback();
            }
            return null;
        }, name);
    }

    public List<MetricsEntity> queryMetrics(String name, Integer limit) {
        if (limit == null) {
            limit = 20;
        }
        EntityQueryLambda<MetricsEntity> q = new EntityQueryLambda<MetricsEntity>(MetricsEntity.class);
        if (name != null) {
            q.eq(MetricsEntity::getName, name);
        }
        EntityDatabase db = EntityDatabase.DEFAULT;
        return db.findBy(q.orderByDescending(MetricsEntity::getOccurCount).limit(limit));
    }

    public static class MetricsEntity
    implements Serializable {
        private static final long serialVersionUID = 2049476730423563051L;
        @DbColumn(primaryKey=true)
        String name;
        String message;
        String stackTrace;
        int occurCount;
        Date modifyTime;

        public String getName() {
            return this.name;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public int getOccurCount() {
            return this.occurCount;
        }

        public Date getModifyTime() {
            return this.modifyTime;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }

        public void setOccurCount(int occurCount) {
            this.occurCount = occurCount;
        }

        public void setModifyTime(Date modifyTime) {
            this.modifyTime = modifyTime;
        }

        public String toString() {
            return "TraceHandler.MetricsEntity(name=" + this.getName() + ", message=" + this.getMessage() + ", stackTrace=" + this.getStackTrace() + ", occurCount=" + this.getOccurCount() + ", modifyTime=" + this.getModifyTime() + ")";
        }
    }

    public static class MethodEntity
    implements Serializable {
        private static final long serialVersionUID = 941255683071148L;
        @DbColumn(primaryKey=true)
        long id;
        String methodName;
        String parameters;
        long elapsedMicros;
        int occurCount;
        String appName;
        String threadName;
        Date modifyTime;

        public long getId() {
            return this.id;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getParameters() {
            return this.parameters;
        }

        public long getElapsedMicros() {
            return this.elapsedMicros;
        }

        public int getOccurCount() {
            return this.occurCount;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public Date getModifyTime() {
            return this.modifyTime;
        }

        public void setId(long id) {
            this.id = id;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public void setElapsedMicros(long elapsedMicros) {
            this.elapsedMicros = elapsedMicros;
        }

        public void setOccurCount(int occurCount) {
            this.occurCount = occurCount;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        public void setModifyTime(Date modifyTime) {
            this.modifyTime = modifyTime;
        }

        public String toString() {
            return "TraceHandler.MethodEntity(id=" + this.getId() + ", methodName=" + this.getMethodName() + ", parameters=" + this.getParameters() + ", elapsedMicros=" + this.getElapsedMicros() + ", occurCount=" + this.getOccurCount() + ", appName=" + this.getAppName() + ", threadName=" + this.getThreadName() + ", modifyTime=" + this.getModifyTime() + ")";
        }
    }

    public static class ErrorEntity
    implements Serializable {
        private static final long serialVersionUID = 8387064071982888474L;
        @DbColumn(primaryKey=true)
        long id;
        ExceptionLevel level;
        Queue<String> messages;
        String stackTrace;
        int occurCount;
        String appName;
        String threadName;
        Date modifyTime;

        public long getId() {
            return this.id;
        }

        public ExceptionLevel getLevel() {
            return this.level;
        }

        public Queue<String> getMessages() {
            return this.messages;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public int getOccurCount() {
            return this.occurCount;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public Date getModifyTime() {
            return this.modifyTime;
        }

        public void setId(long id) {
            this.id = id;
        }

        public void setLevel(ExceptionLevel level) {
            this.level = level;
        }

        public void setMessages(Queue<String> messages) {
            this.messages = messages;
        }

        public void setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }

        public void setOccurCount(int occurCount) {
            this.occurCount = occurCount;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        public void setModifyTime(Date modifyTime) {
            this.modifyTime = modifyTime;
        }

        public String toString() {
            return "TraceHandler.ErrorEntity(id=" + this.getId() + ", level=" + (Object)((Object)this.getLevel()) + ", messages=" + this.getMessages() + ", stackTrace=" + this.getStackTrace() + ", occurCount=" + this.getOccurCount() + ", appName=" + this.getAppName() + ", threadName=" + this.getThreadName() + ", modifyTime=" + this.getModifyTime() + ")";
        }
    }
}

